/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.file;

import java.io.File;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.marketcetera.util.except.I18NException;
import org.marketcetera.util.exec.Disposition;
import org.marketcetera.util.exec.Exec;
import org.marketcetera.util.file.Deleter;
import org.marketcetera.util.misc.OperatingSystem;
import org.marketcetera.util.test.TestCaseBase;

public class DeleterTest
extends TestCaseBase {
    private static final String TEST_ROOT = DIR_ROOT + File.separator + "deleter" + File.separator;
    private static final String TEST_TEMPLATES = TEST_ROOT + "templates";
    private static final String TEST_TEMPLATE_WIN32 = "win32";
    private static final String TEST_TEMPLATE_UNIX = "unix";
    private static final String TEST_PLAIN_FILE = "file.txt";
    private static final String TEST_PLAIN_DIR = "dir";
    private static final String TEST_PLAIN_DIR_CONTENTS = "dir" + File.separator + "b.txt";
    private static final String TEST_NONEXISTENT_FILE = TEST_ROOT + "nonexistent";
    private static final String TEST_FILE_LINK = "file_link";
    private static final String TEST_DIR_LINK = "dir_link";
    private static final String TEST_DANGLING_LINK = "dangling_link";
    private static final String TEST_RECURSIVE_LINK = "recursive_link";

    private static void cleanCopy() throws I18NException {
        if (OperatingSystem.LOCAL.isUnix()) {
            Exec.run((String)TEST_TEMPLATES, (Disposition)Disposition.STDERR, (String[])new String[]{"rm", "-r", "-f", ".." + File.separator + TEST_TEMPLATE_UNIX});
            return;
        }
        if (OperatingSystem.LOCAL.isWin32()) {
            Exec.run((String)TEST_TEMPLATES, (Disposition)Disposition.STDERR, (String[])new String[]{"cmd.exe", "/c", "rd", "/S", "/Q", ".." + File.separator + TEST_TEMPLATE_WIN32});
            return;
        }
        throw new AssertionError((Object)"Unknown platform");
    }

    private static String createCopy() throws I18NException {
        if (OperatingSystem.LOCAL.isUnix()) {
            Exec.run((String)TEST_TEMPLATES, (Disposition)Disposition.STDERR, (String[])new String[]{"cp", "-r", TEST_TEMPLATE_UNIX, ".." + File.separator + TEST_TEMPLATE_UNIX});
            return TEST_ROOT + TEST_TEMPLATE_UNIX;
        }
        Exec.run((String)TEST_TEMPLATES, (Disposition)Disposition.STDERR, (String[])new String[]{"xcopy.exe", "/E", "/I", TEST_TEMPLATE_WIN32, ".." + File.separator + TEST_TEMPLATE_WIN32});
        return TEST_ROOT + TEST_TEMPLATE_WIN32;
    }

    private static void single(String name, String resolvedName) throws I18NException {
        DeleterTest.cleanCopy();
        String rootName = DeleterTest.createCopy();
        String fileName = rootName + File.separator + name;
        File root = new File(rootName);
        File file = new File(fileName);
        File resolvedFile = null;
        if (resolvedName != null) {
            resolvedFile = new File(rootName + File.separator + resolvedName);
        }
        Deleter.apply((File)file);
        Assert.assertTrue((boolean)root.exists());
        Assert.assertFalse((boolean)file.exists());
        if (resolvedFile != null) {
            Assert.assertTrue((boolean)resolvedFile.exists());
        }
        DeleterTest.cleanCopy();
        DeleterTest.createCopy();
        Deleter.apply((String)fileName);
        Assert.assertTrue((boolean)root.exists());
        Assert.assertFalse((boolean)file.exists());
        if (resolvedFile != null) {
            Assert.assertTrue((boolean)resolvedFile.exists());
        }
    }

    @After
    public void tearDownDeleterTest() throws Exception {
        DeleterTest.cleanCopy();
    }

    @Test
    public void existing() throws Exception {
        DeleterTest.single(TEST_PLAIN_DIR, null);
        DeleterTest.single(TEST_PLAIN_FILE, null);
    }

    @Test
    public void nonexistent() throws Exception {
        Deleter.apply((File)new File(TEST_NONEXISTENT_FILE));
        Deleter.apply((String)TEST_NONEXISTENT_FILE);
    }

    @Test
    public void unixDeleter() throws Exception {
        Assume.assumeTrue((boolean)OperatingSystem.LOCAL.isUnix());
        DeleterTest.single(TEST_FILE_LINK, TEST_PLAIN_FILE);
        DeleterTest.single(TEST_DIR_LINK, TEST_PLAIN_DIR_CONTENTS);
        DeleterTest.single(TEST_DANGLING_LINK, null);
        DeleterTest.single(TEST_RECURSIVE_LINK, null);
    }
}

