/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.file;

import java.io.File;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.marketcetera.util.file.FileType;
import org.marketcetera.util.misc.OperatingSystem;
import org.marketcetera.util.test.TestCaseBase;

public class FileTypeTest
extends TestCaseBase {
    private static final String TEST_ROOT = DIR_ROOT + File.separator + "file_type" + File.separator;
    private static final String TEST_PLAIN_FILE = TEST_ROOT + "file.txt";
    private static final String TEST_PLAIN_DIR = TEST_ROOT + "dir";
    private static final String TEST_NONEXISTENT_FILE = TEST_ROOT + "nonexistent";
    private static final String TEST_FILE_LINK = TEST_ROOT + "file_link";
    private static final String TEST_DIR_LINK = TEST_ROOT + "dir_link";
    private static final String TEST_DANGLING_LINK = TEST_ROOT + "dangling_link";
    private static final String TEST_RECURSIVE_LINK = TEST_ROOT + "recursive_link";
    private static final String TEST_UNKNOWN_FILE = "/dev/null";
    private static final String TEST_ALIASED_FILE = TEST_ROOT + "dir_link" + File.separator + "file.txt";
    private static final String TEST_ALIASED_DIR = TEST_ROOT + "dir_link" + File.separator + "dir";
    private static final String TEST_ALIASED_NONEXISTENT_FILE = TEST_ROOT + "dir_link" + File.separator + "nonexistent";
    private static final String TEST_ALIASED_FILE_LINK = TEST_ROOT + "dir_link" + File.separator + "file_link";
    private static final String TEST_ALIASED_DIR_LINK = TEST_ROOT + "dir_link" + File.separator + "dir_link";
    private static final String TEST_ALIASED_DANGLING_LINK = TEST_ROOT + "dir_link" + File.separator + "dangling_link";
    private static final String TEST_ALIASED_RECURSIVE_LINK = TEST_ROOT + "dir_link" + File.separator + "recursive_link";
    private static final String TEST_DP_DIRECT_FILE_LINK = TEST_ROOT + "dp_direct_file_link";
    private static final String TEST_DP_DIRECT_DIR_LINK = TEST_ROOT + "dp_direct_dir_link";
    private static final String TEST_DP_DIRECT_DANGLING_LINK = TEST_ROOT + "dp_direct_dangling_link";
    private static final String TEST_DP_INDIRECT_FILE_LINK = TEST_ROOT + "dp_indirect_file_link";
    private static final String TEST_DP_INDIRECT_DIR_LINK = TEST_ROOT + "dp_indirect_dir_link";
    private static final String TEST_DP_INDIRECT_DANGLING_LINK = TEST_ROOT + "dp_indirect_dangling_link";
    private static final String TEST_DP_RECURSIVE_LINK = TEST_ROOT + "dp_recursive_link";

    private static void singleTest(FileType type, boolean isSymbolicLink, boolean isDirectory, boolean isFile) {
        Assert.assertEquals((Object)isSymbolicLink, (Object)type.isSymbolicLink());
        Assert.assertEquals((Object)isDirectory, (Object)type.isDirectory());
        Assert.assertEquals((Object)isFile, (Object)type.isFile());
    }

    @Test
    public void all() {
        FileTypeTest.singleTest(FileType.NONEXISTENT, false, false, false);
        FileTypeTest.singleTest(FileType.LINK_DIR, true, true, false);
        FileTypeTest.singleTest(FileType.DIR, false, true, false);
        FileTypeTest.singleTest(FileType.LINK_FILE, true, false, true);
        FileTypeTest.singleTest(FileType.FILE, false, false, true);
        FileTypeTest.singleTest(FileType.LINK_UNKNOWN, true, false, false);
        FileTypeTest.singleTest(FileType.UNKNOWN, false, false, false);
    }

    @Test
    public void commonTypes() {
        Assert.assertEquals((Object)FileType.FILE, (Object)FileType.get((String)TEST_PLAIN_FILE));
        Assert.assertEquals((Object)FileType.DIR, (Object)FileType.get((String)TEST_PLAIN_DIR));
        Assert.assertEquals((Object)FileType.NONEXISTENT, (Object)FileType.get((String)TEST_NONEXISTENT_FILE));
        Assert.assertEquals((Object)FileType.UNKNOWN, (Object)FileType.get((String)null));
        Assert.assertEquals((Object)FileType.UNKNOWN, (Object)FileType.get((File)null));
    }

    @Test
    public void unixTypes() {
        Assume.assumeTrue((boolean)OperatingSystem.LOCAL.isUnix());
        Assert.assertEquals((Object)FileType.LINK_FILE, (Object)FileType.get((String)TEST_FILE_LINK));
        Assert.assertEquals((Object)FileType.LINK_DIR, (Object)FileType.get((String)TEST_DIR_LINK));
        Assert.assertEquals((Object)FileType.LINK_UNKNOWN, (Object)FileType.get((String)TEST_DANGLING_LINK));
        Assert.assertEquals((Object)FileType.LINK_UNKNOWN, (Object)FileType.get((String)TEST_RECURSIVE_LINK));
        Assert.assertEquals((Object)FileType.UNKNOWN, (Object)FileType.get((String)TEST_UNKNOWN_FILE));
        Assert.assertEquals((Object)FileType.FILE, (Object)FileType.get((String)TEST_ALIASED_FILE));
        Assert.assertEquals((Object)FileType.DIR, (Object)FileType.get((String)TEST_ALIASED_DIR));
        Assert.assertEquals((Object)FileType.NONEXISTENT, (Object)FileType.get((String)TEST_ALIASED_NONEXISTENT_FILE));
        Assert.assertEquals((Object)FileType.LINK_FILE, (Object)FileType.get((String)TEST_ALIASED_FILE_LINK));
        Assert.assertEquals((Object)FileType.LINK_DIR, (Object)FileType.get((String)TEST_ALIASED_DIR_LINK));
        Assert.assertEquals((Object)FileType.LINK_UNKNOWN, (Object)FileType.get((String)TEST_ALIASED_DANGLING_LINK));
        Assert.assertEquals((Object)FileType.LINK_UNKNOWN, (Object)FileType.get((String)TEST_ALIASED_RECURSIVE_LINK));
        Assert.assertEquals((Object)FileType.LINK_FILE, (Object)FileType.get((String)TEST_DP_DIRECT_FILE_LINK));
        Assert.assertEquals((Object)FileType.LINK_DIR, (Object)FileType.get((String)TEST_DP_DIRECT_DIR_LINK));
        Assert.assertEquals((Object)FileType.LINK_UNKNOWN, (Object)FileType.get((String)TEST_DP_DIRECT_DANGLING_LINK));
        Assert.assertEquals((Object)FileType.LINK_FILE, (Object)FileType.get((String)TEST_DP_INDIRECT_FILE_LINK));
        Assert.assertEquals((Object)FileType.LINK_DIR, (Object)FileType.get((String)TEST_DP_INDIRECT_DIR_LINK));
        Assert.assertEquals((Object)FileType.LINK_UNKNOWN, (Object)FileType.get((String)TEST_DP_INDIRECT_DANGLING_LINK));
        Assert.assertEquals((Object)FileType.LINK_UNKNOWN, (Object)FileType.get((String)TEST_DP_RECURSIVE_LINK));
    }
}

