/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.file;

import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ArrayUtils;
import org.junit.Assert;
import org.junit.Test;
import org.marketcetera.util.file.CloseableRegistry;
import org.marketcetera.util.file.InputStreamWrapper;
import org.marketcetera.util.file.OutputStreamWrapper;
import org.marketcetera.util.file.ReaderWrapper;
import org.marketcetera.util.file.WrapperTestBase;
import org.marketcetera.util.file.WriterWrapper;
import org.marketcetera.util.unicode.DecodingStrategy;
import org.marketcetera.util.unicode.SignatureCharset;

public class FileWrapperTest
extends WrapperTestBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void inputOutputStreams() throws Exception {
        InputStreamWrapper in;
        OutputStreamWrapper out;
        CloseableRegistry r = new CloseableRegistry();
        try {
            out = new OutputStreamWrapper(TEST_FILE);
            r.register((Closeable)out);
            Assert.assertFalse((boolean)out.getSkipClose());
            Assert.assertNotNull((Object)out.getStream());
            out.getStream().write(VALUE_BYTES);
        }
        finally {
            r.close();
        }
        r = new CloseableRegistry();
        try {
            in = new InputStreamWrapper(TEST_FILE);
            r.register((Closeable)in);
            Assert.assertFalse((boolean)in.getSkipClose());
            Assert.assertNotNull((Object)in.getStream());
            Assert.assertArrayEquals((byte[])VALUE_BYTES, (byte[])IOUtils.toByteArray((InputStream)in.getStream()));
        }
        finally {
            r.close();
        }
        r = new CloseableRegistry();
        try {
            out = new OutputStreamWrapper(":append:" + TEST_FILE);
            r.register((Closeable)out);
            out.getStream().write(VALUE_BYTES);
        }
        finally {
            r.close();
        }
        r = new CloseableRegistry();
        try {
            in = new InputStreamWrapper(TEST_FILE);
            r.register((Closeable)in);
            Assert.assertArrayEquals((byte[])ArrayUtils.addAll((byte[])VALUE_BYTES, (byte[])VALUE_BYTES), (byte[])IOUtils.toByteArray((InputStream)in.getStream()));
        }
        finally {
            r.close();
        }
        r = new CloseableRegistry();
        try {
            out = new OutputStreamWrapper(new File(TEST_FILE));
            r.register((Closeable)out);
            out.getStream().write(VALUE_BYTES);
        }
        finally {
            r.close();
        }
        r = new CloseableRegistry();
        try {
            in = new InputStreamWrapper(new File(TEST_FILE));
            r.register((Closeable)in);
            Assert.assertArrayEquals((byte[])VALUE_BYTES, (byte[])IOUtils.toByteArray((InputStream)in.getStream()));
        }
        finally {
            r.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void readerWriter() throws Exception {
        ReaderWrapper in;
        WriterWrapper out;
        CloseableRegistry r = new CloseableRegistry();
        try {
            out = new WriterWrapper(new File(TEST_FILE));
            r.register((Closeable)out);
            Assert.assertFalse((boolean)out.getSkipClose());
            Assert.assertNotNull((Object)out.getWriter());
            out.getWriter().write("Hello");
        }
        finally {
            r.close();
        }
        r = new CloseableRegistry();
        try {
            in = new ReaderWrapper(new File(TEST_FILE));
            r.register((Closeable)in);
            Assert.assertFalse((boolean)in.getSkipClose());
            Assert.assertNotNull((Object)in.getReader());
            Assert.assertEquals((Object)"Hello", (Object)IOUtils.toString((Reader)in.getReader()));
        }
        finally {
            r.close();
        }
        r = new CloseableRegistry();
        try {
            out = new WriterWrapper(":append:" + TEST_FILE);
            r.register((Closeable)out);
            out.getWriter().write("Hello");
        }
        finally {
            r.close();
        }
        r = new CloseableRegistry();
        try {
            in = new ReaderWrapper(TEST_FILE);
            r.register((Closeable)in);
            Assert.assertEquals((Object)"HelloHello", (Object)IOUtils.toString((Reader)in.getReader()));
        }
        finally {
            r.close();
        }
        r = new CloseableRegistry();
        try {
            out = new WriterWrapper(new File(TEST_FILE), SignatureCharset.UTF8_UTF8);
            r.register((Closeable)out);
            out.getWriter().write("Hello Spr\u00e5k \u0393\u0395\u0399\u0391 \u03a3\u039f\u03a5 \u0645\u0646\u0632\u0644 \u3055\u3088\u3046\u306a\u3089 \ud800\udc88 \ud800\udc89 \ud834\udd1e");
        }
        finally {
            r.close();
        }
        r = new CloseableRegistry();
        try {
            in = new ReaderWrapper(new File(TEST_FILE), DecodingStrategy.SIG_REQ);
            r.register((Closeable)in);
            Assert.assertEquals((Object)"Hello Spr\u00e5k \u0393\u0395\u0399\u0391 \u03a3\u039f\u03a5 \u0645\u0646\u0632\u0644 \u3055\u3088\u3046\u306a\u3089 \ud800\udc88 \ud800\udc89 \ud834\udd1e", (Object)IOUtils.toString((Reader)in.getReader()));
        }
        finally {
            r.close();
        }
        r = new CloseableRegistry();
        try {
            out = new WriterWrapper(":append:" + TEST_FILE, SignatureCharset.UTF8_UTF8);
            r.register((Closeable)out);
            out.getWriter().write("Hello Spr\u00e5k \u0393\u0395\u0399\u0391 \u03a3\u039f\u03a5 \u0645\u0646\u0632\u0644 \u3055\u3088\u3046\u306a\u3089 \ud800\udc88 \ud800\udc89 \ud834\udd1e");
        }
        finally {
            r.close();
        }
        r = new CloseableRegistry();
        try {
            in = new ReaderWrapper(TEST_FILE, DecodingStrategy.SIG_REQ);
            r.register((Closeable)in);
            Assert.assertEquals((Object)"Hello Spr\u00e5k \u0393\u0395\u0399\u0391 \u03a3\u039f\u03a5 \u0645\u0646\u0632\u0644 \u3055\u3088\u3046\u306a\u3089 \ud800\udc88 \ud800\udc89 \ud834\udd1eHello Spr\u00e5k \u0393\u0395\u0399\u0391 \u03a3\u039f\u03a5 \u0645\u0646\u0632\u0644 \u3055\u3088\u3046\u306a\u3089 \ud800\udc88 \ud800\udc89 \ud834\udd1e", (Object)IOUtils.toString((Reader)in.getReader()));
        }
        finally {
            r.close();
        }
    }
}

