/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.l10n;

import org.apache.commons.lang.SystemUtils;
import org.junit.Assert;
import org.junit.Test;
import org.marketcetera.util.l10n.ContainerClassInfo;
import org.marketcetera.util.l10n.I18NMessageInfo;
import org.marketcetera.util.l10n.MessageComparator;
import org.marketcetera.util.l10n.MessageInfo;
import org.marketcetera.util.l10n.MessageInfoPair;
import org.marketcetera.util.l10n.MessageInfoProvider;
import org.marketcetera.util.l10n.PropertiesFileInfo;
import org.marketcetera.util.l10n.PropertyMessageInfo;
import org.marketcetera.util.l10n.TestMessages;
import org.marketcetera.util.log.I18NMessage;
import org.marketcetera.util.log.I18NMessage0P;
import org.marketcetera.util.log.I18NMessage1P;
import org.marketcetera.util.log.I18NMessageNP;
import org.marketcetera.util.test.CollectionAssert;
import org.marketcetera.util.test.TestCaseBase;

public class MessageComparatorTest
extends TestCaseBase {
    private static void assertMatches(MessageComparator comparator) {
        Assert.assertEquals((Object)"", (Object)comparator.getDifferences());
        Assert.assertTrue((boolean)comparator.isMatch());
    }

    @Test
    public void match() throws Exception {
        MessageComparatorTest.assertMatches(new MessageComparator(CorrectMessages.class));
        ContainerClassInfo provider = new ContainerClassInfo(CorrectMessages.class);
        MessageComparatorTest.assertMatches(new MessageComparator((MessageInfoProvider)provider, (MessageInfoProvider)provider));
        provider = new PropertiesFileInfo(TestMessages.PROVIDER);
        MessageComparatorTest.assertMatches(new MessageComparator((MessageInfoProvider)provider, (MessageInfoProvider)provider));
    }

    @Test
    public void mismatch() throws Exception {
        MessageComparator comparator = new MessageComparator(MismatchMessages.class);
        Assert.assertFalse((boolean)comparator.isMatch());
        CollectionAssert.assertArrayPermutation((Object[])new MessageInfoPair[]{new MessageInfoPair((MessageInfo)new I18NMessageInfo("b1.ttl", 1, (I18NMessage)MismatchMessages.B1_TTL), (MessageInfo)new PropertyMessageInfo("b1.ttl", 0, "B Text"))}, (Object[])comparator.getMismatches());
        CollectionAssert.assertArrayPermutation((Object[])new MessageInfo[]{new I18NMessageInfo("b3.ttl", -1, (I18NMessage)MismatchMessages.B3_TTL)}, (Object[])comparator.getExtraSrcInfo());
        CollectionAssert.assertArrayPermutation((Object[])new MessageInfo[]{new PropertyMessageInfo("b2.ttl", 1, "B Text {0,date,full}")}, (Object[])comparator.getExtraDstInfo());
        Assert.assertEquals((Object)("Parameter count mismatch: message key 'b1.ttl'; source count is 1; destination count is 0" + SystemUtils.LINE_SEPARATOR + "Extra message in source: key 'b3.ttl'" + SystemUtils.LINE_SEPARATOR + "Extra message in destination: key 'b2.ttl'"), (Object)comparator.getDifferences());
    }

    private static interface MismatchMessages
    extends TestMessages {
        public static final I18NMessage1P B1_TTL = new I18NMessage1P(LOGGER, "b1", "ttl");
        public static final I18NMessageNP B3_TTL = new I18NMessageNP(LOGGER, "b3", "ttl");
    }

    private static interface CorrectMessages
    extends TestMessages {
        public static final I18NMessage0P B1_TTL = new I18NMessage0P(LOGGER, "b1", "ttl");
        public static final I18NMessage1P B2_TTL = new I18NMessage1P(LOGGER, "b2", "ttl");
    }
}

