/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.quickfix;

import java.io.File;
import java.io.Serializable;
import java.util.Locale;
import org.apache.log4j.Level;
import org.junit.Assert;
import org.junit.Test;
import org.marketcetera.util.except.I18NRuntimeException;
import org.marketcetera.util.log.ActiveLocale;
import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.log.I18NBoundMessage1P;
import org.marketcetera.util.quickfix.Messages;
import org.marketcetera.util.quickfix.SpringSessionDescriptor;
import org.marketcetera.util.test.TestCaseBase;
import org.springframework.context.support.FileSystemXmlApplicationContext;
import quickfix.Dictionary;
import quickfix.SessionID;

public class SpringSessionDescriptorTest
extends TestCaseBase {
    private static final String TEST_ROOT = DIR_ROOT + File.separator + "quickfix" + File.separator;
    private static final String TEST_BEAN_GOOD_DESCRIPTOR = "goodDescriptor";
    private static final String TEST_BEAN_MISSING_BEGIN_STRING = "missingBeginString";
    private static final String TEST_BEAN_MISSING_SENDER_COMP_ID = "missingSenderCompId";
    private static final String TEST_BEAN_MISSING_TARGET_COMP_ID = "missingTargetCompId";
    private static final String TEST_BEAN_GOOD_DEFAULT_DICTIONARY = "goodDefaultDictionary";
    private static final String TEST_BEAN_BAD_DEFAULT_DICTIONARY = "badDefaultDictionary";
    private static final String TEST_BEAN_INHERITS_DEFAULTS = "inheritsDefaults";
    private static final String TEST_DEFAULT_DICTIONARY_BEGIN_STRING = "FIX.4.1";
    private static final String TEST_DEFAULT_DICTIONARY = "FIX41.xml";
    private static final String TEST_BAD_BEGIN_STRING = "FIX.3.0";
    private static final String TEST_KEY = "testKey";
    private static final String TEST_VALUE_SUFFIX = "Value";
    private static final String TEST_VALUE_OVERRIDE_SUFFIX = "ValueOverride";
    private static final String TEST_FILE = TEST_ROOT + "descriptor.xml";
    private static final String TEST_CATEGORY = SpringSessionDescriptor.class.getName();
    private static final String TEST_MESSAGE = "The descriptor has no settings assigned to it";

    @Test
    public void all() throws Exception {
        ActiveLocale.setProcessLocale((Locale)Locale.ROOT);
        SpringSessionDescriptorTest.setLevel((String)TEST_CATEGORY, (Level)Level.WARN);
        FileSystemXmlApplicationContext context = new FileSystemXmlApplicationContext(TEST_FILE);
        Assert.assertNotNull((Object)"metc.DefaultDataDictionary");
        SpringSessionDescriptor descriptor = (SpringSessionDescriptor)context.getBean(TEST_BEAN_GOOD_DESCRIPTOR);
        this.getAppender().clear();
        SessionID qID = descriptor.getQSessionID();
        Assert.assertNotNull((Object)qID);
        Dictionary qDictionary = descriptor.getQDictionary();
        Assert.assertNotNull((Object)qDictionary);
        try {
            descriptor.setDictionary(descriptor.getDictionary());
            Assert.fail();
        }
        catch (I18NRuntimeException ex) {
            // empty catch block
        }
        Assert.assertNotNull((Object)descriptor.getDictionary());
        try {
            descriptor.setSettings(descriptor.getSettings());
            Assert.fail();
        }
        catch (I18NRuntimeException ex) {
            // empty catch block
        }
        Assert.assertNull((Object)descriptor.getSettings());
        this.assertSingleEvent(Level.WARN, TEST_CATEGORY, TEST_MESSAGE, TEST_CATEGORY);
        Assert.assertEquals((Object)"BeginStringValue", (Object)qDictionary.getString("BeginString"));
        Assert.assertEquals((Object)"SenderCompIDValue", (Object)qDictionary.getString("SenderCompID"));
        Assert.assertEquals((Object)"SenderSubIDValue", (Object)qDictionary.getString("SenderSubID"));
        Assert.assertEquals((Object)"SenderLocationIDValue", (Object)qDictionary.getString("SenderLocationID"));
        Assert.assertEquals((Object)"TargetCompIDValue", (Object)qDictionary.getString("TargetCompID"));
        Assert.assertEquals((Object)"TargetSubIDValue", (Object)qDictionary.getString("TargetSubID"));
        Assert.assertEquals((Object)"TargetLocationIDValue", (Object)qDictionary.getString("TargetLocationID"));
        Assert.assertEquals((Object)"SessionQualifierValue", (Object)qDictionary.getString("SessionQualifier"));
        Assert.assertEquals((Object)"DataDictionaryValue", (Object)qDictionary.getString("DataDictionary"));
        Assert.assertEquals((Object)"testKeyValue", (Object)qDictionary.getString(TEST_KEY));
        Assert.assertEquals((Object)"BeginStringValue", (Object)qID.getBeginString());
        Assert.assertEquals((Object)"SenderCompIDValue", (Object)qID.getSenderCompID());
        Assert.assertEquals((Object)"SenderSubIDValue", (Object)qID.getSenderSubID());
        Assert.assertEquals((Object)"SenderLocationIDValue", (Object)qID.getSenderLocationID());
        Assert.assertEquals((Object)"TargetCompIDValue", (Object)qID.getTargetCompID());
        Assert.assertEquals((Object)"TargetSubIDValue", (Object)qID.getTargetSubID());
        Assert.assertEquals((Object)"TargetLocationIDValue", (Object)qID.getTargetLocationID());
        Assert.assertEquals((Object)"SessionQualifierValue", (Object)qID.getSessionQualifier());
        descriptor = (SpringSessionDescriptor)context.getBean(TEST_BEAN_MISSING_BEGIN_STRING);
        this.getAppender().clear();
        try {
            descriptor.getQDictionary();
            Assert.fail();
        }
        catch (I18NRuntimeException ex) {
            Assert.assertEquals((Object)((Object)new I18NRuntimeException((I18NBoundMessage)new I18NBoundMessage1P(Messages.FIELD_REQUIRED, (Serializable)((Object)"BeginString")))), (Object)((Object)ex));
        }
        Assert.assertNull((Object)descriptor.getDictionary());
        Assert.assertNull((Object)descriptor.getSettings());
        this.assertSingleEvent(Level.WARN, TEST_CATEGORY, TEST_MESSAGE, TEST_CATEGORY);
        descriptor = (SpringSessionDescriptor)context.getBean(TEST_BEAN_MISSING_SENDER_COMP_ID);
        this.getAppender().clear();
        try {
            descriptor.getQDictionary();
            Assert.fail();
        }
        catch (I18NRuntimeException ex) {
            Assert.assertEquals((Object)((Object)new I18NRuntimeException((I18NBoundMessage)new I18NBoundMessage1P(Messages.FIELD_REQUIRED, (Serializable)((Object)"SenderCompID")))), (Object)((Object)ex));
        }
        Assert.assertNotNull((Object)descriptor.getDictionary());
        Assert.assertNotNull((Object)descriptor.getSettings());
        this.assertNoEvents();
        descriptor = (SpringSessionDescriptor)context.getBean(TEST_BEAN_MISSING_TARGET_COMP_ID);
        this.getAppender().clear();
        try {
            descriptor.getQDictionary();
            Assert.fail();
        }
        catch (I18NRuntimeException ex) {
            Assert.assertEquals((Object)((Object)new I18NRuntimeException((I18NBoundMessage)new I18NBoundMessage1P(Messages.FIELD_REQUIRED, (Serializable)((Object)"TargetCompID")))), (Object)((Object)ex));
        }
        Assert.assertNotNull((Object)descriptor.getDictionary());
        Assert.assertNotNull((Object)descriptor.getSettings());
        this.assertNoEvents();
        descriptor = (SpringSessionDescriptor)context.getBean(TEST_BEAN_GOOD_DEFAULT_DICTIONARY);
        this.getAppender().clear();
        qID = descriptor.getQSessionID();
        Assert.assertNotNull((Object)qID);
        qDictionary = descriptor.getQDictionary();
        Assert.assertNotNull((Object)qDictionary);
        Assert.assertNull((Object)descriptor.getDictionary());
        Assert.assertNotNull((Object)descriptor.getSettings());
        this.assertNoEvents();
        Assert.assertEquals((Object)TEST_DEFAULT_DICTIONARY_BEGIN_STRING, (Object)qID.getBeginString());
        Assert.assertEquals((Object)TEST_DEFAULT_DICTIONARY, (Object)qDictionary.getString("DataDictionary"));
        descriptor = (SpringSessionDescriptor)context.getBean(TEST_BEAN_BAD_DEFAULT_DICTIONARY);
        this.getAppender().clear();
        try {
            descriptor.getQDictionary();
            Assert.fail();
        }
        catch (I18NRuntimeException ex) {
            Assert.assertEquals((Object)((Object)new I18NRuntimeException((I18NBoundMessage)new I18NBoundMessage1P(Messages.NO_DEFAULT_DATA_DICTIONARY, (Serializable)((Object)TEST_BAD_BEGIN_STRING)))), (Object)((Object)ex));
        }
        Assert.assertNotNull((Object)descriptor.getDictionary());
        Assert.assertNull((Object)descriptor.getSettings());
        this.assertSingleEvent(Level.WARN, TEST_CATEGORY, TEST_MESSAGE, TEST_CATEGORY);
        descriptor = (SpringSessionDescriptor)context.getBean(TEST_BEAN_INHERITS_DEFAULTS);
        this.getAppender().clear();
        qID = descriptor.getQSessionID();
        Assert.assertNotNull((Object)qID);
        qDictionary = descriptor.getQDictionary();
        Assert.assertNotNull((Object)qDictionary);
        Assert.assertNotNull((Object)descriptor.getDictionary());
        Assert.assertNotNull((Object)descriptor.getSettings());
        this.assertNoEvents();
        Assert.assertEquals((Object)TEST_DEFAULT_DICTIONARY_BEGIN_STRING, (Object)qID.getBeginString());
        Assert.assertEquals((Object)"SenderCompIDValue", (Object)qID.getSenderCompID());
        Assert.assertEquals((Object)"TargetCompIDValueOverride", (Object)qID.getTargetCompID());
        Assert.assertEquals((Object)TEST_DEFAULT_DICTIONARY, (Object)qDictionary.getString("DataDictionary"));
    }
}

