/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.quickfix;

import java.io.File;
import java.io.Serializable;
import java.util.Iterator;
import org.junit.Assert;
import org.junit.Test;
import org.marketcetera.util.except.I18NRuntimeException;
import org.marketcetera.util.log.I18NBoundMessage1P;
import org.marketcetera.util.quickfix.Messages;
import org.marketcetera.util.quickfix.SpringSessionDescriptor;
import org.marketcetera.util.quickfix.SpringSessionSettings;
import org.marketcetera.util.test.TestCaseBase;
import org.springframework.context.support.FileSystemXmlApplicationContext;
import quickfix.ConfigError;
import quickfix.FileStoreFactory;
import quickfix.JdbcLogFactory;
import quickfix.JdbcStoreFactory;
import quickfix.SLF4JLogFactory;
import quickfix.SessionID;
import quickfix.SessionSettings;

public class SpringSessionSettingsTest
extends TestCaseBase {
    private static final String TEST_ROOT = DIR_ROOT + File.separator + "quickfix" + File.separator;
    private static final String TEST_BEAN_GOOD_SETTINGS = "goodSettings";
    private static final String TEST_BEAN_EMPTY_SETTINGS = "emptySettings";
    private static final String TEST_BEAN_GOOD_CUSTOM_FACTORIES = "goodCustomFactories";
    private static final String TEST_BEAN_BAD_CUSTOM_LOG_FACTORY = "badCustomLogFactory";
    private static final String TEST_BEAN_BAD_CUSTOM_STORE_FACTORY = "badCustomStoreFactory";
    private static final String TEST_BAD_LOG_FACTORY = "BadLogFactory";
    private static final String TEST_BAD_STORE_FACTORY = "BadStoreFactory";
    private static final String TEST_KEY = "testKey";
    private static final String TEST_VALUE_SUFFIX = "Value";
    private static final String TEST_VALUE1_SUFFIX = "Value1";
    private static final String TEST_VALUE2_SUFFIX = "Value2";
    private static final String TEST_FILE = TEST_ROOT + "settings.xml";

    @Test
    public void all() throws Exception {
        FileSystemXmlApplicationContext context = new FileSystemXmlApplicationContext(TEST_FILE);
        Assert.assertNotNull((Object)"metc.LogFactoryClass");
        Assert.assertNotNull((Object)"metc.MessageStoreFactoryClass");
        SpringSessionSettings settings = (SpringSessionSettings)context.getBean(TEST_BEAN_GOOD_SETTINGS);
        SessionSettings qSettings = settings.getQSettings();
        Assert.assertNotNull((Object)qSettings);
        Assert.assertEquals(SLF4JLogFactory.class, settings.getQLogFactory().getClass());
        Assert.assertEquals(FileStoreFactory.class, settings.getQMessageStoreFactory().getClass());
        try {
            settings.setDefaults(settings.getDefaults());
            Assert.fail();
        }
        catch (I18NRuntimeException ex) {
            // empty catch block
        }
        Assert.assertNotNull((Object)settings.getDefaults());
        try {
            settings.setDescriptors(settings.getDescriptors());
            Assert.fail();
        }
        catch (I18NRuntimeException ex) {
            // empty catch block
        }
        Assert.assertNotNull((Object)settings.getDescriptors());
        Assert.assertEquals((Object)"SenderCompIDValue", (Object)qSettings.getString("SenderCompID"));
        Assert.assertEquals((Object)"testKeyValue", (Object)qSettings.getString(TEST_KEY));
        Iterator descriptors = settings.getDescriptors().iterator();
        SessionID qID = ((SpringSessionDescriptor)descriptors.next()).getQSessionID();
        Assert.assertEquals((Object)"BeginStringValue1", (Object)qSettings.getString(qID, "BeginString"));
        Assert.assertEquals((Object)"SenderCompIDValue1", (Object)qSettings.getString(qID, "SenderCompID"));
        Assert.assertEquals((Object)"TargetCompIDValue1", (Object)qSettings.getString(qID, "TargetCompID"));
        Assert.assertEquals((Object)"testKeyValue", (Object)qSettings.getString(qID, TEST_KEY));
        qID = ((SpringSessionDescriptor)descriptors.next()).getQSessionID();
        Assert.assertEquals((Object)"BeginStringValue2", (Object)qSettings.getString(qID, "BeginString"));
        Assert.assertEquals((Object)"SenderCompIDValue", (Object)qSettings.getString(qID, "SenderCompID"));
        Assert.assertEquals((Object)"TargetCompIDValue2", (Object)qSettings.getString(qID, "TargetCompID"));
        Assert.assertEquals((Object)"testKeyValue", (Object)qSettings.getString(qID, TEST_KEY));
        settings = (SpringSessionSettings)context.getBean(TEST_BEAN_EMPTY_SETTINGS);
        Assert.assertNotNull((Object)settings.getQSettings());
        Assert.assertEquals(SLF4JLogFactory.class, settings.getQLogFactory().getClass());
        Assert.assertEquals(FileStoreFactory.class, settings.getQMessageStoreFactory().getClass());
        Assert.assertNull((Object)settings.getDefaults());
        Assert.assertNull((Object)settings.getDescriptors());
        settings = (SpringSessionSettings)context.getBean(TEST_BEAN_GOOD_CUSTOM_FACTORIES);
        qSettings = settings.getQSettings();
        Assert.assertNotNull((Object)qSettings);
        Assert.assertEquals(JdbcLogFactory.class, settings.getQLogFactory().getClass());
        Assert.assertEquals(JdbcStoreFactory.class, settings.getQMessageStoreFactory().getClass());
        Assert.assertNotNull((Object)settings.getDefaults());
        Assert.assertEquals((Object)JdbcLogFactory.class.getName(), settings.getDefaults().get("metc.LogFactoryClass"));
        Assert.assertEquals((Object)JdbcStoreFactory.class.getName(), settings.getDefaults().get("metc.MessageStoreFactoryClass"));
        Assert.assertNull((Object)settings.getDescriptors());
        try {
            qSettings.getString("metc.LogFactoryClass");
            Assert.fail();
        }
        catch (ConfigError ex) {
            // empty catch block
        }
        try {
            qSettings.getString("metc.MessageStoreFactoryClass");
            Assert.fail();
        }
        catch (ConfigError ex) {
            // empty catch block
        }
        settings = (SpringSessionSettings)context.getBean(TEST_BEAN_BAD_CUSTOM_LOG_FACTORY);
        try {
            settings.getQSettings();
            Assert.fail();
        }
        catch (I18NRuntimeException ex) {
            Assert.assertEquals(I18NRuntimeException.class, ((Object)((Object)ex)).getClass());
            Assert.assertEquals((Object)new I18NBoundMessage1P(Messages.BAD_LOG_FACTORY, (Serializable)((Object)TEST_BAD_LOG_FACTORY)), (Object)ex.getI18NBoundMessage());
            Assert.assertEquals(ClassNotFoundException.class, ex.getCause().getClass());
        }
        Assert.assertNotNull((Object)settings.getDefaults());
        Assert.assertNull((Object)settings.getDescriptors());
        settings = (SpringSessionSettings)context.getBean(TEST_BEAN_BAD_CUSTOM_STORE_FACTORY);
        try {
            settings.getQSettings();
            Assert.fail();
        }
        catch (I18NRuntimeException ex) {
            Assert.assertEquals(I18NRuntimeException.class, ((Object)((Object)ex)).getClass());
            Assert.assertEquals((Object)new I18NBoundMessage1P(Messages.BAD_MESSAGE_STORE_FACTORY, (Serializable)((Object)TEST_BAD_STORE_FACTORY)), (Object)ex.getI18NBoundMessage());
            Assert.assertEquals(ClassNotFoundException.class, ex.getCause().getClass());
        }
        Assert.assertNotNull((Object)settings.getDefaults());
        Assert.assertNull((Object)settings.getDescriptors());
    }
}

