/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.unicode;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.Reader;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.marketcetera.util.file.CloseableRegistry;
import org.marketcetera.util.file.InputStreamWrapper;
import org.marketcetera.util.file.ReaderWrapper;
import org.marketcetera.util.unicode.DecoderTestBase;
import org.marketcetera.util.unicode.DecodingStrategy;
import org.marketcetera.util.unicode.SignatureCharset;
import org.marketcetera.util.unicode.UnicodeInputStreamReader;

public class MemoryDecoderTest
extends DecoderTestBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String decode(ReaderCreator creator, DecodingStrategy strategy, SignatureCharset requestedSignatureCharset, SignatureCharset signatureCharset, byte[] bytes) throws Exception {
        CloseableRegistry r = new CloseableRegistry();
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(bytes);
            r.register((Closeable)new InputStreamWrapper((InputStream)is));
            UnicodeInputStreamReader reader = creator.create(is);
            r.register((Closeable)new ReaderWrapper((Reader)reader));
            Assert.assertEquals((Object)strategy, (Object)reader.getDecodingStrategy());
            Assert.assertEquals((Object)requestedSignatureCharset, (Object)reader.getRequestedSignatureCharset());
            Assert.assertEquals((Object)signatureCharset, (Object)reader.getSignatureCharset());
            String string = IOUtils.toString((Reader)reader);
            return string;
        }
        finally {
            r.close();
        }
    }

    @Override
    protected String decode(byte[] bytes) throws Exception {
        return this.decode(new ReaderCreator(){

            @Override
            public UnicodeInputStreamReader create(InputStream is) {
                return new UnicodeInputStreamReader(is);
            }
        }, null, null, null, bytes);
    }

    @Override
    protected String decode(final SignatureCharset sc, byte[] bytes) throws Exception {
        return this.decode(new ReaderCreator(){

            @Override
            public UnicodeInputStreamReader create(InputStream is) {
                return new UnicodeInputStreamReader(is, sc);
            }
        }, null, sc, sc, bytes);
    }

    @Override
    protected String decode(final DecodingStrategy strategy, SignatureCharset sc, byte[] bytes) throws Exception {
        return this.decode(new ReaderCreator(){

            @Override
            public UnicodeInputStreamReader create(InputStream is) {
                return new UnicodeInputStreamReader(is, strategy);
            }
        }, strategy, null, sc, bytes);
    }

    private static interface ReaderCreator {
        public UnicodeInputStreamReader create(InputStream var1);
    }
}

