/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.ws.sample;

import org.marketcetera.util.except.I18NException;
import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.log.I18NMessage2P;
import org.marketcetera.util.misc.ClassVersion;
import org.marketcetera.util.ws.sample.SampleMessages;
import org.marketcetera.util.ws.sample.SampleStatelessService;
import org.marketcetera.util.ws.stateless.StatelessClientContext;
import org.marketcetera.util.ws.stateless.StatelessRemoteCaller;
import org.marketcetera.util.ws.stateless.StatelessServiceBaseImpl;
import org.marketcetera.util.ws.wrappers.RemoteException;

@ClassVersion(value="$Id: SampleStatelessServiceImpl.java 16154 2012-07-14 16:34:05Z colin $")
public class SampleStatelessServiceImpl
extends StatelessServiceBaseImpl
implements SampleStatelessService {
    private I18NMessage2P mGreeting;

    public SampleStatelessServiceImpl(I18NMessage2P greeting) {
        this.mGreeting = greeting;
    }

    public static void checkName(String name) throws I18NException {
        if ("I18NException".equals(name)) {
            throw new I18NException((I18NBoundMessage)SampleMessages.EXCEPTION_MESSAGE);
        }
        if ("AssertionError".equals(name)) {
            throw new AssertionError((Object)"This is the error message");
        }
        if ("IllegalArgumentException".equals(name)) {
            throw new IllegalArgumentException("This is the exception message");
        }
        if (name == null) {
            throw new AssertionError();
        }
    }

    private String helloImpl(StatelessClientContext context, String name) throws I18NException {
        SampleStatelessServiceImpl.checkName(name);
        return this.mGreeting.getText((Object)name, (Object)-1);
    }

    @Override
    public String hello(StatelessClientContext context, final String name) throws RemoteException {
        return (String)new StatelessRemoteCaller<String>(){

            protected String call(StatelessClientContext context) throws I18NException {
                return SampleStatelessServiceImpl.this.helloImpl(context, name);
            }
        }.execute(context);
    }
}

