/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.ws.stateful;

import java.util.Locale;
import org.apache.log4j.Level;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.marketcetera.util.log.ActiveLocale;
import org.marketcetera.util.test.TestCaseBase;
import org.marketcetera.util.ws.stateful.SessionFactory;
import org.marketcetera.util.ws.stateful.SessionHolder;
import org.marketcetera.util.ws.stateful.SessionManager;
import org.marketcetera.util.ws.stateless.StatelessClientContext;
import org.marketcetera.util.ws.tags.NodeId;
import org.marketcetera.util.ws.tags.SessionId;

public class SessionManagerTest
extends TestCaseBase {
    private static final long TEST_LIFESPAN = 500L;
    private static final NodeId TEST_SERVER_ID = NodeId.generate();
    private static final SessionId TEST_SESSION_ID = SessionId.generate();
    private static final SessionId TEST_SESSION_ID_D = SessionId.generate();
    private static final String TEST_USER = "metc";
    private static final StatelessClientContext TEST_CONTEXT = new StatelessClientContext();
    private static final Integer TEST_SESSION = new Integer(1);
    private static final Integer TEST_SESSION_D = new Integer(2);
    private static final String TEST_CATEGORY = SessionManager.Reaper.class.getName();

    @Before
    public void setupSessionManagerTest() {
        ActiveLocale.setProcessLocale((Locale)Locale.ROOT);
        SessionManagerTest.setLevel((String)TEST_CATEGORY, (Level)Level.INFO);
    }

    @Test
    public void basics() throws Exception {
        TestFactory f = new TestFactory();
        SessionManager s = new SessionManager((SessionFactory)f);
        Assert.assertSame((Object)f, (Object)s.getSessionFactory());
        Assert.assertEquals((long)-1L, (long)s.getLifespan());
        Assert.assertNull((Object)s.getServerId());
        s.setServerId(TEST_SERVER_ID);
        Assert.assertEquals((Object)TEST_SERVER_ID, (Object)s.getServerId());
        s.setServerId(null);
        Assert.assertNull((Object)s.getServerId());
        Assert.assertNull((Object)s.get(TEST_SESSION_ID));
        SessionHolder hD = new SessionHolder(TEST_USER, TEST_CONTEXT);
        long time = hD.getLastAccess();
        Thread.sleep(100L);
        s.put(TEST_SESSION_ID, hD);
        Assert.assertTrue((hD.getLastAccess() > time ? 1 : 0) != 0);
        Assert.assertEquals((Object)TEST_SESSION_ID, (Object)f.getLastSessionId());
        time = hD.getLastAccess();
        Thread.sleep(100L);
        Assert.assertSame((Object)hD, (Object)s.get(TEST_SESSION_ID));
        Assert.assertTrue((hD.getLastAccess() > time ? 1 : 0) != 0);
        SessionHolder h = new SessionHolder(TEST_USER, TEST_CONTEXT);
        s.put(TEST_SESSION_ID, h);
        Assert.assertSame((Object)h, (Object)s.get(TEST_SESSION_ID));
        Assert.assertNull((Object)s.get(TEST_SESSION_ID_D));
        s.put(TEST_SESSION_ID_D, hD);
        Assert.assertSame((Object)hD, (Object)s.get(TEST_SESSION_ID_D));
        Assert.assertSame((Object)h, (Object)s.get(TEST_SESSION_ID));
        Assert.assertEquals((Object)TEST_SESSION_ID_D, (Object)f.getLastSessionId());
        s.remove(TEST_SESSION_ID);
        Assert.assertNull((Object)s.get(TEST_SESSION_ID));
        Assert.assertSame((Object)hD, (Object)s.get(TEST_SESSION_ID_D));
        Assert.assertEquals((Object)TEST_SESSION, (Object)f.getLastRemovedSession());
        s.remove(TEST_SESSION_ID);
    }

    @Test
    public void basicsNoFactory() throws Exception {
        SessionManager s = new SessionManager();
        Assert.assertEquals((long)-1L, (long)s.getLifespan());
        SessionHolder h = new SessionHolder(TEST_USER, TEST_CONTEXT);
        s.put(TEST_SESSION_ID, h);
        Assert.assertSame((Object)h, (Object)s.get(TEST_SESSION_ID));
        s.remove(TEST_SESSION_ID);
        Assert.assertNull((Object)s.get(TEST_SESSION_ID));
        s.remove(TEST_SESSION_ID);
    }

    @Test
    public void timeout() throws Exception {
        TestFactory f = new TestFactory();
        SessionManager s = new SessionManager((SessionFactory)f, 500L);
        Assert.assertEquals((long)500L, (long)s.getLifespan());
        SessionHolder h = new SessionHolder(TEST_USER, TEST_CONTEXT);
        s.put(TEST_SESSION_ID, h);
        Assert.assertSame((Object)h, (Object)s.get(TEST_SESSION_ID));
        Assert.assertEquals((Object)TEST_SESSION_ID, (Object)f.getLastSessionId());
        for (int i = 0; i < 10; ++i) {
            Thread.sleep(250L);
            Assert.assertSame((Object)h, (Object)s.get(TEST_SESSION_ID));
        }
        Thread.sleep(1000L);
        this.assertSingleEvent(Level.INFO, TEST_CATEGORY, "Session " + TEST_SESSION_ID.toString() + " has expired; creation context: " + TEST_CONTEXT.toString(), TEST_CATEGORY);
        Assert.assertNull((Object)s.get(TEST_SESSION_ID));
        Assert.assertEquals((Object)TEST_SESSION, (Object)f.getLastRemovedSession());
    }

    @Test
    public void timeoutNoFactory() throws Exception {
        SessionManager s = new SessionManager(500L);
        Assert.assertEquals((long)500L, (long)s.getLifespan());
        SessionHolder h = new SessionHolder(TEST_USER, TEST_CONTEXT);
        s.put(TEST_SESSION_ID, h);
        Assert.assertSame((Object)h, (Object)s.get(TEST_SESSION_ID));
        for (int i = 0; i < 10; ++i) {
            Thread.sleep(250L);
            Assert.assertSame((Object)h, (Object)s.get(TEST_SESSION_ID));
        }
        Thread.sleep(1000L);
        this.assertSingleEvent(Level.INFO, TEST_CATEGORY, "Session " + TEST_SESSION_ID.toString() + " has expired; creation context: " + TEST_CONTEXT.toString(), TEST_CATEGORY);
        Assert.assertNull((Object)s.get(TEST_SESSION_ID));
    }

    @Test
    public void termination() throws Exception {
        ThreadGroup group = new ThreadGroup("group");
        Thread t = new Thread(group, "testThread"){

            @Override
            public void run() {
                new SessionManager(500L).setServerId(TEST_SERVER_ID);
            }
        };
        t.start();
        Thread.sleep(500L);
        Assert.assertEquals((long)1L, (long)group.activeCount());
        group.interrupt();
        Thread.sleep(1000L);
        Assert.assertEquals((long)0L, (long)group.activeCount());
        this.assertSingleEvent(Level.INFO, TEST_CATEGORY, "Reaper for server " + TEST_SERVER_ID.toString() + " was terminated", TEST_CATEGORY);
    }

    private static class TestFactory
    implements SessionFactory<Integer> {
        private SessionId mLastSessionId;
        private Integer mLastRemovedSession;

        private TestFactory() {
        }

        public void setLastSessionId(SessionId lastSessionId) {
            this.mLastSessionId = lastSessionId;
        }

        public SessionId getLastSessionId() {
            return this.mLastSessionId;
        }

        public void setLastRemovedSession(Integer lastRemovedSession) {
            this.mLastRemovedSession = lastRemovedSession;
        }

        public Object getLastRemovedSession() {
            return this.mLastRemovedSession;
        }

        public Integer createSession(StatelessClientContext context, String user, SessionId id) {
            Assert.assertEquals((Object)TEST_CONTEXT, (Object)context);
            Assert.assertEquals((Object)SessionManagerTest.TEST_USER, (Object)user);
            this.setLastSessionId(id);
            if (id == TEST_SESSION_ID) {
                return TEST_SESSION;
            }
            return TEST_SESSION_D;
        }

        public void removedSession(Integer session) {
            this.setLastRemovedSession(session);
        }
    }
}

