/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.ws.stateless;

import java.util.Locale;
import javax.jws.WebService;
import javax.xml.ws.soap.SOAPFaultException;
import org.apache.cxf.service.factory.ServiceConstructionException;
import org.junit.Assert;
import org.junit.Before;
import org.marketcetera.util.log.ActiveLocale;
import org.marketcetera.util.ws.stateless.Node;
import org.marketcetera.util.ws.stateless.NodeTestBase;
import org.marketcetera.util.ws.stateless.ServiceInterface;
import org.marketcetera.util.ws.stateless.StatelessClient;
import org.marketcetera.util.ws.stateless.StatelessClientContext;
import org.marketcetera.util.ws.stateless.StatelessServer;
import org.marketcetera.util.ws.stateless.StatelessServiceBase;
import org.marketcetera.util.ws.stateless.StatelessServiceBaseImpl;
import org.marketcetera.util.ws.tags.AppId;
import org.marketcetera.util.ws.tags.VersionId;
import org.marketcetera.util.ws.wrappers.RemoteException;
import org.marketcetera.util.ws.wrappers.RemoteProperties;

public class ClientServerTestBase
extends NodeTestBase {
    protected static final AppId TEST_APP = new AppId("testApp");
    protected static final int TEST_BAD_PORT = -1;
    private static final Exception TEST_EXCEPTION = new IllegalArgumentException();
    private static final String EXPECTED_MESSAGE = "Remote exception; see cause for details";

    @Before
    public void setupClientServerTestBase() {
        ActiveLocale.setProcessLocale((Locale)Locale.ROOT);
    }

    protected static void singleClientEmpty(StatelessClient client, StatelessClient empty) {
        Assert.assertEquals((Object)TEST_APP, (Object)client.getAppId());
        Assert.assertNull((Object)empty.getAppId());
        StatelessClientContext context = client.getContext();
        Assert.assertEquals((Object)VersionId.SELF, (Object)context.getVersionId());
        Assert.assertEquals((Object)TEST_APP, (Object)context.getAppId());
        Assert.assertEquals((Object)client.getId(), (Object)context.getClientId());
        Assert.assertEquals((Object)Locale.ROOT, (Object)context.getLocale().getRaw());
        ClientServerTestBase.singleNode((Node)client, (Node)empty);
    }

    protected static void singleClientJustId(StatelessClient client, StatelessClient justId) {
        Assert.assertEquals((Object)TEST_APP, (Object)justId.getAppId());
        ClientServerTestBase.singleNode((Node)client, (Node)justId);
    }

    protected static void singleServer(StatelessServer server, StatelessServer empty) {
        ClientServerTestBase.singleNode((Node)server, (Node)empty);
        server.stop();
    }

    protected static void checkException(RemoteException ex) {
        Assert.assertEquals((Object)EXPECTED_MESSAGE, (Object)ex.getMessage());
        Assert.assertEquals((Object)new RemoteProperties((Throwable)TEST_EXCEPTION), (Object)ex.getProperties());
        Assert.assertEquals(TEST_EXCEPTION.getClass(), ex.getCause().getClass());
        Assert.assertEquals((Object)ClientServerTestBase.class.getName(), (Object)ex.getCause().getStackTrace()[0].getClassName());
    }

    protected static void calls(StatelessServer server1, StatelessClient client1, String contextStr1, StatelessServer server2, StatelessClient client2, String contextStr2) {
        ServiceInterface si1 = server1.publish((StatelessServiceBase)new TestServiceImpl(), TestService.class);
        ServiceInterface si2 = server2.publish((StatelessServiceBase)new TestServiceImpl(), TestService.class);
        TestService i1 = (TestService)client1.getService(TestService.class);
        TestService i2 = (TestService)client2.getService(TestService.class);
        Assert.assertEquals((Object)contextStr1, (Object)i1.testCall(client1.getContext()));
        try {
            i1.testException();
            Assert.fail();
        }
        catch (RemoteException ex) {
            ClientServerTestBase.checkException(ex);
        }
        Assert.assertEquals((Object)contextStr2, (Object)i2.testCall(client2.getContext()));
        try {
            i2.testException();
            Assert.fail();
        }
        catch (RemoteException ex) {
            ClientServerTestBase.checkException(ex);
        }
        si1.stop();
        try {
            i1.testCall(client1.getContext());
            Assert.fail();
        }
        catch (SOAPFaultException ex) {
            // empty catch block
        }
        Assert.assertEquals((Object)contextStr2, (Object)i2.testCall(client2.getContext()));
        si2.stop();
        try {
            i2.testCall(client2.getContext());
            Assert.fail();
        }
        catch (SOAPFaultException ex) {
            // empty catch block
        }
        server1.stop();
        server2.stop();
    }

    protected static void badConnection(StatelessServer badServer, StatelessClient badClient) {
        try {
            badServer.publish((StatelessServiceBase)new TestServiceImpl(), TestService.class);
            Assert.fail();
        }
        catch (ServiceConstructionException ex) {
            // empty catch block
        }
        TestService i = (TestService)badClient.getService(TestService.class);
        try {
            i.testCall(badClient.getContext());
            Assert.fail();
        }
        catch (SOAPFaultException sOAPFaultException) {
            // empty catch block
        }
        badServer.stop();
    }

    private static class TestServiceImpl
    extends StatelessServiceBaseImpl
    implements TestService {
        private TestServiceImpl() {
        }

        @Override
        public String testCall(StatelessClientContext arg) {
            return arg.toString();
        }

        @Override
        public void testException() throws RemoteException {
            throw new RemoteException((Throwable)TEST_EXCEPTION);
        }
    }

    @WebService
    public static interface TestService
    extends StatelessServiceBase {
        public String testCall(StatelessClientContext var1);

        public void testException() throws RemoteException;
    }
}

