/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.ws.types;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.lang.ArrayUtils;
import org.junit.Assert;
import org.junit.Test;
import org.marketcetera.util.test.TestCaseBase;
import org.marketcetera.util.ws.stateless.StatelessClient;
import org.marketcetera.util.ws.stateless.StatelessServer;
import org.marketcetera.util.ws.stateless.StatelessServiceBase;
import org.marketcetera.util.ws.types.BigDecimalHolder;
import org.marketcetera.util.ws.types.BigIntegerHolder;
import org.marketcetera.util.ws.types.BooleanHolder;
import org.marketcetera.util.ws.types.ByteHolder;
import org.marketcetera.util.ws.types.CharacterHolder;
import org.marketcetera.util.ws.types.CompSerWrapperHolder;
import org.marketcetera.util.ws.types.DateHolder;
import org.marketcetera.util.ws.types.DateWrapperHolder;
import org.marketcetera.util.ws.types.DoubleHolder;
import org.marketcetera.util.ws.types.EnumObject;
import org.marketcetera.util.ws.types.EnumObjectHolder;
import org.marketcetera.util.ws.types.FloatHolder;
import org.marketcetera.util.ws.types.InnerObject;
import org.marketcetera.util.ws.types.InnerObjectHolder;
import org.marketcetera.util.ws.types.IntegerHolder;
import org.marketcetera.util.ws.types.LocaleWrapperHolder;
import org.marketcetera.util.ws.types.LongHolder;
import org.marketcetera.util.ws.types.SerWrapperHolder;
import org.marketcetera.util.ws.types.Service;
import org.marketcetera.util.ws.types.ServiceImpl;
import org.marketcetera.util.ws.types.ShortHolder;
import org.marketcetera.util.ws.types.StringHolder;
import org.marketcetera.util.ws.types.WrappableObject;
import org.marketcetera.util.ws.wrappers.CompSerWrapper;
import org.marketcetera.util.ws.wrappers.DateWrapper;
import org.marketcetera.util.ws.wrappers.LocaleWrapper;
import org.marketcetera.util.ws.wrappers.MapWrapper;
import org.marketcetera.util.ws.wrappers.RemoteException;
import org.marketcetera.util.ws.wrappers.SerWrapper;

public class TypeTest
extends TestCaseBase {
    private static final boolean TEST_P_BOOLEAN = true;
    private static final Boolean TEST_O_BOOLEAN = false;
    private static final boolean[] TEST_PARR_BOOLEAN = new boolean[]{true, false, true};
    private static final Boolean[] TEST_OARR_BOOLEAN = new Boolean[]{false, true, false};
    private static final List<Boolean> TEST_LST_BOOLEAN = Arrays.asList(TEST_OARR_BOOLEAN);
    private static final Collection<Boolean> TEST_COL_BOOLEAN = TEST_LST_BOOLEAN;
    private static final LinkedList<Boolean> TEST_LLST_BOOLEAN = TypeTest.toLinkedList(TEST_LST_BOOLEAN);
    private static final HashSet<Boolean> TEST_HSET_BOOLEAN = TypeTest.toHashSet(TEST_LST_BOOLEAN);
    private static final TreeSet<Boolean> TEST_TSET_BOOLEAN = TypeTest.toTreeSet(TEST_LST_BOOLEAN);
    private static final Set<Boolean> TEST_SET_BOOLEAN = TEST_HSET_BOOLEAN;
    private static final HashMap<Boolean, Boolean> TEST_HMAP_BOOLEAN = TypeTest.toHashMap(TEST_LST_BOOLEAN);
    private static final MapWrapper<Boolean, Boolean> TEST_WHMAP_BOOLEAN = new MapWrapper(TEST_HMAP_BOOLEAN);
    private static final TreeMap<Boolean, Boolean> TEST_TMAP_BOOLEAN = TypeTest.toTreeMap(TEST_LST_BOOLEAN);
    private static final MapWrapper<Boolean, Boolean> TEST_WTMAP_BOOLEAN = new MapWrapper(TEST_TMAP_BOOLEAN);
    private static final Map<Boolean, Boolean> TEST_MAP_BOOLEAN = TEST_HMAP_BOOLEAN;
    private static final MapWrapper<Boolean, Boolean> TEST_WMAP_BOOLEAN = new MapWrapper(TEST_MAP_BOOLEAN);
    private static final BooleanHolder TEST_HLD_BOOLEAN = new BooleanHolder(true, TEST_O_BOOLEAN, TEST_PARR_BOOLEAN, TEST_OARR_BOOLEAN, TEST_COL_BOOLEAN, TEST_LST_BOOLEAN, TEST_LLST_BOOLEAN, TEST_SET_BOOLEAN, TEST_HSET_BOOLEAN, TEST_TSET_BOOLEAN, TEST_MAP_BOOLEAN, TEST_HMAP_BOOLEAN, TEST_TMAP_BOOLEAN);
    private static final byte TEST_P_BYTE = -128;
    private static final Byte TEST_O_BYTE = 127;
    private static final byte[] TEST_PARR_BYTE = new byte[]{1, 2, 3};
    private static final Byte[] TEST_OARR_BYTE = new Byte[]{(byte)4, (byte)5, (byte)6};
    private static final List<Byte> TEST_LST_BYTE = Arrays.asList(TEST_OARR_BYTE);
    private static final Collection<Byte> TEST_COL_BYTE = TEST_LST_BYTE;
    private static final LinkedList<Byte> TEST_LLST_BYTE = TypeTest.toLinkedList(TEST_LST_BYTE);
    private static final HashSet<Byte> TEST_HSET_BYTE = TypeTest.toHashSet(TEST_LST_BYTE);
    private static final TreeSet<Byte> TEST_TSET_BYTE = TypeTest.toTreeSet(TEST_LST_BYTE);
    private static final Set<Byte> TEST_SET_BYTE = TEST_HSET_BYTE;
    private static final HashMap<Byte, Byte> TEST_HMAP_BYTE = TypeTest.toHashMap(TEST_LST_BYTE);
    private static final MapWrapper<Byte, Byte> TEST_WHMAP_BYTE = new MapWrapper(TEST_HMAP_BYTE);
    private static final TreeMap<Byte, Byte> TEST_TMAP_BYTE = TypeTest.toTreeMap(TEST_LST_BYTE);
    private static final MapWrapper<Byte, Byte> TEST_WTMAP_BYTE = new MapWrapper(TEST_TMAP_BYTE);
    private static final Map<Byte, Byte> TEST_MAP_BYTE = TEST_HMAP_BYTE;
    private static final MapWrapper<Byte, Byte> TEST_WMAP_BYTE = new MapWrapper(TEST_MAP_BYTE);
    private static final ByteHolder TEST_HLD_BYTE = new ByteHolder(-128, TEST_O_BYTE, TEST_PARR_BYTE, TEST_OARR_BYTE, TEST_COL_BYTE, TEST_LST_BYTE, TEST_LLST_BYTE, TEST_SET_BYTE, TEST_HSET_BYTE, TEST_TSET_BYTE, TEST_MAP_BYTE, TEST_HMAP_BYTE, TEST_TMAP_BYTE);
    private static final char TEST_P_CHAR = '\u0001';
    private static final Character TEST_O_CHAR = Character.valueOf('\u0002');
    private static final char[] TEST_PARR_CHAR = new char[]{'\u0001', '\u0002', 'a'};
    private static final Character[] TEST_OARR_CHAR = new Character[]{Character.valueOf('\u0003'), Character.valueOf('\u0004'), Character.valueOf('b')};
    private static final List<Character> TEST_LST_CHAR = Arrays.asList(TEST_OARR_CHAR);
    private static final Collection<Character> TEST_COL_CHAR = TEST_LST_CHAR;
    private static final LinkedList<Character> TEST_LLST_CHAR = TypeTest.toLinkedList(TEST_LST_CHAR);
    private static final HashSet<Character> TEST_HSET_CHAR = TypeTest.toHashSet(TEST_LST_CHAR);
    private static final TreeSet<Character> TEST_TSET_CHAR = TypeTest.toTreeSet(TEST_LST_CHAR);
    private static final Set<Character> TEST_SET_CHAR = TEST_HSET_CHAR;
    private static final HashMap<Character, Character> TEST_HMAP_CHAR = TypeTest.toHashMap(TEST_LST_CHAR);
    private static final MapWrapper<Character, Character> TEST_WHMAP_CHAR = new MapWrapper(TEST_HMAP_CHAR);
    private static final TreeMap<Character, Character> TEST_TMAP_CHAR = TypeTest.toTreeMap(TEST_LST_CHAR);
    private static final MapWrapper<Character, Character> TEST_WTMAP_CHAR = new MapWrapper(TEST_TMAP_CHAR);
    private static final Map<Character, Character> TEST_MAP_CHAR = TEST_HMAP_CHAR;
    private static final MapWrapper<Character, Character> TEST_WMAP_CHAR = new MapWrapper(TEST_MAP_CHAR);
    private static final CharacterHolder TEST_HLD_CHAR = new CharacterHolder('\u0001', TEST_O_CHAR, TEST_PARR_CHAR, TEST_OARR_CHAR, TEST_COL_CHAR, TEST_LST_CHAR, TEST_LLST_CHAR, TEST_SET_CHAR, TEST_HSET_CHAR, TEST_TSET_CHAR, TEST_MAP_CHAR, TEST_HMAP_CHAR, TEST_TMAP_CHAR);
    private static final double TEST_P_DOUBLE = Double.MIN_VALUE;
    private static final Double TEST_O_DOUBLE = Double.MAX_VALUE;
    private static final double[] TEST_PARR_DOUBLE = new double[]{1.5, 2.5, 3.5, Double.MIN_NORMAL, Double.NEGATIVE_INFINITY};
    private static final Double[] TEST_OARR_DOUBLE = new Double[]{4.5, 5.5, 6.5, Double.NaN, Double.POSITIVE_INFINITY};
    private static final List<Double> TEST_LST_DOUBLE = Arrays.asList(TEST_OARR_DOUBLE);
    private static final Collection<Double> TEST_COL_DOUBLE = TEST_LST_DOUBLE;
    private static final LinkedList<Double> TEST_LLST_DOUBLE = TypeTest.toLinkedList(TEST_LST_DOUBLE);
    private static final HashSet<Double> TEST_HSET_DOUBLE = TypeTest.toHashSet(TEST_LST_DOUBLE);
    private static final TreeSet<Double> TEST_TSET_DOUBLE = TypeTest.toTreeSet(TEST_LST_DOUBLE);
    private static final Set<Double> TEST_SET_DOUBLE = TEST_HSET_DOUBLE;
    private static final HashMap<Double, Double> TEST_HMAP_DOUBLE = TypeTest.toHashMap(TEST_LST_DOUBLE);
    private static final MapWrapper<Double, Double> TEST_WHMAP_DOUBLE = new MapWrapper(TEST_HMAP_DOUBLE);
    private static final TreeMap<Double, Double> TEST_TMAP_DOUBLE = TypeTest.toTreeMap(TEST_LST_DOUBLE);
    private static final MapWrapper<Double, Double> TEST_WTMAP_DOUBLE = new MapWrapper(TEST_TMAP_DOUBLE);
    private static final Map<Double, Double> TEST_MAP_DOUBLE = TEST_HMAP_DOUBLE;
    private static final MapWrapper<Double, Double> TEST_WMAP_DOUBLE = new MapWrapper(TEST_MAP_DOUBLE);
    private static final DoubleHolder TEST_HLD_DOUBLE = new DoubleHolder(Double.MIN_VALUE, TEST_O_DOUBLE, TEST_PARR_DOUBLE, TEST_OARR_DOUBLE, TEST_COL_DOUBLE, TEST_LST_DOUBLE, TEST_LLST_DOUBLE, TEST_SET_DOUBLE, TEST_HSET_DOUBLE, TEST_TSET_DOUBLE, TEST_MAP_DOUBLE, TEST_HMAP_DOUBLE, TEST_TMAP_DOUBLE);
    private static final float TEST_P_FLOAT = Float.MIN_VALUE;
    private static final Float TEST_O_FLOAT = Float.valueOf(Float.MAX_VALUE);
    private static final float[] TEST_PARR_FLOAT = new float[]{1.5f, 2.5f, 3.5f, Float.MIN_NORMAL, Float.NEGATIVE_INFINITY};
    private static final Float[] TEST_OARR_FLOAT = new Float[]{Float.valueOf(4.5f), Float.valueOf(5.5f), Float.valueOf(6.5f), Float.valueOf(Float.NaN), Float.valueOf(Float.POSITIVE_INFINITY)};
    private static final List<Float> TEST_LST_FLOAT = Arrays.asList(TEST_OARR_FLOAT);
    private static final Collection<Float> TEST_COL_FLOAT = TEST_LST_FLOAT;
    private static final LinkedList<Float> TEST_LLST_FLOAT = TypeTest.toLinkedList(TEST_LST_FLOAT);
    private static final HashSet<Float> TEST_HSET_FLOAT = TypeTest.toHashSet(TEST_LST_FLOAT);
    private static final TreeSet<Float> TEST_TSET_FLOAT = TypeTest.toTreeSet(TEST_LST_FLOAT);
    private static final Set<Float> TEST_SET_FLOAT = TEST_HSET_FLOAT;
    private static final HashMap<Float, Float> TEST_HMAP_FLOAT = TypeTest.toHashMap(TEST_LST_FLOAT);
    private static final MapWrapper<Float, Float> TEST_WHMAP_FLOAT = new MapWrapper(TEST_HMAP_FLOAT);
    private static final TreeMap<Float, Float> TEST_TMAP_FLOAT = TypeTest.toTreeMap(TEST_LST_FLOAT);
    private static final MapWrapper<Float, Float> TEST_WTMAP_FLOAT = new MapWrapper(TEST_TMAP_FLOAT);
    private static final Map<Float, Float> TEST_MAP_FLOAT = TEST_HMAP_FLOAT;
    private static final MapWrapper<Float, Float> TEST_WMAP_FLOAT = new MapWrapper(TEST_MAP_FLOAT);
    private static final FloatHolder TEST_HLD_FLOAT = new FloatHolder(Float.MIN_VALUE, TEST_O_FLOAT, TEST_PARR_FLOAT, TEST_OARR_FLOAT, TEST_COL_FLOAT, TEST_LST_FLOAT, TEST_LLST_FLOAT, TEST_SET_FLOAT, TEST_HSET_FLOAT, TEST_TSET_FLOAT, TEST_MAP_FLOAT, TEST_HMAP_FLOAT, TEST_TMAP_FLOAT);
    private static final int TEST_P_INT = Integer.MIN_VALUE;
    private static final Integer TEST_O_INT = Integer.MAX_VALUE;
    private static final int[] TEST_PARR_INT = new int[]{1, 2, 3};
    private static final Integer[] TEST_OARR_INT = new Integer[]{4, 5, 6};
    private static final List<Integer> TEST_LST_INT = Arrays.asList(TEST_OARR_INT);
    private static final Collection<Integer> TEST_COL_INT = TEST_LST_INT;
    private static final LinkedList<Integer> TEST_LLST_INT = TypeTest.toLinkedList(TEST_LST_INT);
    private static final HashSet<Integer> TEST_HSET_INT = TypeTest.toHashSet(TEST_LST_INT);
    private static final TreeSet<Integer> TEST_TSET_INT = TypeTest.toTreeSet(TEST_LST_INT);
    private static final Set<Integer> TEST_SET_INT = TEST_HSET_INT;
    private static final HashMap<Integer, Integer> TEST_HMAP_INT = TypeTest.toHashMap(TEST_LST_INT);
    private static final MapWrapper<Integer, Integer> TEST_WHMAP_INT = new MapWrapper(TEST_HMAP_INT);
    private static final TreeMap<Integer, Integer> TEST_TMAP_INT = TypeTest.toTreeMap(TEST_LST_INT);
    private static final MapWrapper<Integer, Integer> TEST_WTMAP_INT = new MapWrapper(TEST_TMAP_INT);
    private static final Map<Integer, Integer> TEST_MAP_INT = TEST_HMAP_INT;
    private static final MapWrapper<Integer, Integer> TEST_WMAP_INT = new MapWrapper(TEST_MAP_INT);
    private static final IntegerHolder TEST_HLD_INT = new IntegerHolder(Integer.MIN_VALUE, TEST_O_INT, TEST_PARR_INT, TEST_OARR_INT, TEST_COL_INT, TEST_LST_INT, TEST_LLST_INT, TEST_SET_INT, TEST_HSET_INT, TEST_TSET_INT, TEST_MAP_INT, TEST_HMAP_INT, TEST_TMAP_INT);
    private static final long TEST_P_LONG = Long.MIN_VALUE;
    private static final Long TEST_O_LONG = Long.MAX_VALUE;
    private static final long[] TEST_PARR_LONG = new long[]{1L, 2L, 3L};
    private static final Long[] TEST_OARR_LONG = new Long[]{4L, 5L, 6L};
    private static final List<Long> TEST_LST_LONG = Arrays.asList(TEST_OARR_LONG);
    private static final Collection<Long> TEST_COL_LONG = TEST_LST_LONG;
    private static final LinkedList<Long> TEST_LLST_LONG = TypeTest.toLinkedList(TEST_LST_LONG);
    private static final HashSet<Long> TEST_HSET_LONG = TypeTest.toHashSet(TEST_LST_LONG);
    private static final TreeSet<Long> TEST_TSET_LONG = TypeTest.toTreeSet(TEST_LST_LONG);
    private static final Set<Long> TEST_SET_LONG = TEST_HSET_LONG;
    private static final HashMap<Long, Long> TEST_HMAP_LONG = TypeTest.toHashMap(TEST_LST_LONG);
    private static final MapWrapper<Long, Long> TEST_WHMAP_LONG = new MapWrapper(TEST_HMAP_LONG);
    private static final TreeMap<Long, Long> TEST_TMAP_LONG = TypeTest.toTreeMap(TEST_LST_LONG);
    private static final MapWrapper<Long, Long> TEST_WTMAP_LONG = new MapWrapper(TEST_TMAP_LONG);
    private static final Map<Long, Long> TEST_MAP_LONG = TEST_HMAP_LONG;
    private static final MapWrapper<Long, Long> TEST_WMAP_LONG = new MapWrapper(TEST_MAP_LONG);
    private static final LongHolder TEST_HLD_LONG = new LongHolder(Long.MIN_VALUE, TEST_O_LONG, TEST_PARR_LONG, TEST_OARR_LONG, TEST_COL_LONG, TEST_LST_LONG, TEST_LLST_LONG, TEST_SET_LONG, TEST_HSET_LONG, TEST_TSET_LONG, TEST_MAP_LONG, TEST_HMAP_LONG, TEST_TMAP_LONG);
    private static final short TEST_P_SHORT = Short.MIN_VALUE;
    private static final Short TEST_O_SHORT = Short.MAX_VALUE;
    private static final short[] TEST_PARR_SHORT = new short[]{1, 2, 3};
    private static final Short[] TEST_OARR_SHORT = new Short[]{(short)4, (short)5, (short)6};
    private static final List<Short> TEST_LST_SHORT = Arrays.asList(TEST_OARR_SHORT);
    private static final Collection<Short> TEST_COL_SHORT = TEST_LST_SHORT;
    private static final LinkedList<Short> TEST_LLST_SHORT = TypeTest.toLinkedList(TEST_LST_SHORT);
    private static final HashSet<Short> TEST_HSET_SHORT = TypeTest.toHashSet(TEST_LST_SHORT);
    private static final TreeSet<Short> TEST_TSET_SHORT = TypeTest.toTreeSet(TEST_LST_SHORT);
    private static final Set<Short> TEST_SET_SHORT = TEST_HSET_SHORT;
    private static final HashMap<Short, Short> TEST_HMAP_SHORT = TypeTest.toHashMap(TEST_LST_SHORT);
    private static final MapWrapper<Short, Short> TEST_WHMAP_SHORT = new MapWrapper(TEST_HMAP_SHORT);
    private static final TreeMap<Short, Short> TEST_TMAP_SHORT = TypeTest.toTreeMap(TEST_LST_SHORT);
    private static final MapWrapper<Short, Short> TEST_WTMAP_SHORT = new MapWrapper(TEST_TMAP_SHORT);
    private static final Map<Short, Short> TEST_MAP_SHORT = TEST_HMAP_SHORT;
    private static final MapWrapper<Short, Short> TEST_WMAP_SHORT = new MapWrapper(TEST_MAP_SHORT);
    private static final ShortHolder TEST_HLD_SHORT = new ShortHolder(Short.MIN_VALUE, TEST_O_SHORT, TEST_PARR_SHORT, TEST_OARR_SHORT, TEST_COL_SHORT, TEST_LST_SHORT, TEST_LLST_SHORT, TEST_SET_SHORT, TEST_HSET_SHORT, TEST_TSET_SHORT, TEST_MAP_SHORT, TEST_HMAP_SHORT, TEST_TMAP_SHORT);
    private static final String TEST_STR = "Hello Spr\u00e5k \u0393\u0395\u0399\u0391 \u03a3\u039f\u03a5 \u0645\u0646\u0632\u0644 \u3055\u3088\u3046\u306a\u3089 \ud800\udc88 \ud800\udc89 \ud834\udd1e";
    private static final String[] TEST_ARR_STR = new String[]{"Hello", "Spr\u00e5k", "\u0393\u0395\u0399\u0391 \u03a3\u039f\u03a5", "\u0645\u0646\u0632\u0644", "\u3055\u3088\u3046\u306a\u3089", "\ud800\udc88 \ud800\udc89", "\ud834\udd1e", "Hello Spr\u00e5k \u0393\u0395\u0399\u0391 \u03a3\u039f\u03a5 \u0645\u0646\u0632\u0644 \u3055\u3088\u3046\u306a\u3089 \ud800\udc88 \ud800\udc89 \ud834\udd1e"};
    private static final List<String> TEST_LST_STR = Arrays.asList(TEST_ARR_STR);
    private static final Collection<String> TEST_COL_STR = TEST_LST_STR;
    private static final LinkedList<String> TEST_LLST_STR = TypeTest.toLinkedList(TEST_LST_STR);
    private static final HashSet<String> TEST_HSET_STR = TypeTest.toHashSet(TEST_LST_STR);
    private static final TreeSet<String> TEST_TSET_STR = TypeTest.toTreeSet(TEST_LST_STR);
    private static final Set<String> TEST_SET_STR = TEST_HSET_STR;
    private static final HashMap<String, String> TEST_HMAP_STR = TypeTest.toHashMap(TEST_LST_STR);
    private static final MapWrapper<String, String> TEST_WHMAP_STR = new MapWrapper(TEST_HMAP_STR);
    private static final TreeMap<String, String> TEST_TMAP_STR = TypeTest.toTreeMap(TEST_LST_STR);
    private static final MapWrapper<String, String> TEST_WTMAP_STR = new MapWrapper(TEST_TMAP_STR);
    private static final Map<String, String> TEST_MAP_STR = TEST_HMAP_STR;
    private static final MapWrapper<String, String> TEST_WMAP_STR = new MapWrapper(TEST_MAP_STR);
    private static final StringHolder TEST_HLD_STR = new StringHolder("Hello Spr\u00e5k \u0393\u0395\u0399\u0391 \u03a3\u039f\u03a5 \u0645\u0646\u0632\u0644 \u3055\u3088\u3046\u306a\u3089 \ud800\udc88 \ud800\udc89 \ud834\udd1e", TEST_ARR_STR, TEST_COL_STR, TEST_LST_STR, TEST_LLST_STR, TEST_SET_STR, TEST_HSET_STR, TEST_TSET_STR, TEST_MAP_STR, TEST_HMAP_STR, TEST_TMAP_STR);
    private static final BigDecimal TEST_BD = new BigDecimal("10012001310004100.0499991992100045");
    private static final BigDecimal[] TEST_ARR_BD = new BigDecimal[]{new BigDecimal("10012001310004100.0499991992100045"), new BigDecimal("20012001310004100.0499991992100045"), new BigDecimal("30012001310004100.0499991992100045")};
    private static final List<BigDecimal> TEST_LST_BD = Arrays.asList(TEST_ARR_BD);
    private static final Collection<BigDecimal> TEST_COL_BD = TEST_LST_BD;
    private static final LinkedList<BigDecimal> TEST_LLST_BD = TypeTest.toLinkedList(TEST_LST_BD);
    private static final HashSet<BigDecimal> TEST_HSET_BD = TypeTest.toHashSet(TEST_LST_BD);
    private static final TreeSet<BigDecimal> TEST_TSET_BD = TypeTest.toTreeSet(TEST_LST_BD);
    private static final Set<BigDecimal> TEST_SET_BD = TEST_HSET_BD;
    private static final HashMap<BigDecimal, BigDecimal> TEST_HMAP_BD = TypeTest.toHashMap(TEST_LST_BD);
    private static final MapWrapper<BigDecimal, BigDecimal> TEST_WHMAP_BD = new MapWrapper(TEST_HMAP_BD);
    private static final TreeMap<BigDecimal, BigDecimal> TEST_TMAP_BD = TypeTest.toTreeMap(TEST_LST_BD);
    private static final MapWrapper<BigDecimal, BigDecimal> TEST_WTMAP_BD = new MapWrapper(TEST_TMAP_BD);
    private static final Map<BigDecimal, BigDecimal> TEST_MAP_BD = TEST_HMAP_BD;
    private static final MapWrapper<BigDecimal, BigDecimal> TEST_WMAP_BD = new MapWrapper(TEST_MAP_BD);
    private static final BigDecimalHolder TEST_HLD_BD = new BigDecimalHolder(TEST_BD, TEST_ARR_BD, TEST_COL_BD, TEST_LST_BD, TEST_LLST_BD, TEST_SET_BD, TEST_HSET_BD, TEST_TSET_BD, TEST_MAP_BD, TEST_HMAP_BD, TEST_TMAP_BD);
    private static final BigInteger TEST_BI = new BigInteger("100120013100041000499991992100045");
    private static final BigInteger[] TEST_ARR_BI = new BigInteger[]{new BigInteger("100120013100041000499991992100045"), new BigInteger("200120013100041000499991992100045"), new BigInteger("300120013100041000499991992100045")};
    private static final List<BigInteger> TEST_LST_BI = Arrays.asList(TEST_ARR_BI);
    private static final Collection<BigInteger> TEST_COL_BI = TEST_LST_BI;
    private static final LinkedList<BigInteger> TEST_LLST_BI = TypeTest.toLinkedList(TEST_LST_BI);
    private static final HashSet<BigInteger> TEST_HSET_BI = TypeTest.toHashSet(TEST_LST_BI);
    private static final TreeSet<BigInteger> TEST_TSET_BI = TypeTest.toTreeSet(TEST_LST_BI);
    private static final Set<BigInteger> TEST_SET_BI = TEST_HSET_BI;
    private static final HashMap<BigInteger, BigInteger> TEST_HMAP_BI = TypeTest.toHashMap(TEST_LST_BI);
    private static final MapWrapper<BigInteger, BigInteger> TEST_WHMAP_BI = new MapWrapper(TEST_HMAP_BI);
    private static final TreeMap<BigInteger, BigInteger> TEST_TMAP_BI = TypeTest.toTreeMap(TEST_LST_BI);
    private static final MapWrapper<BigInteger, BigInteger> TEST_WTMAP_BI = new MapWrapper(TEST_TMAP_BI);
    private static final Map<BigInteger, BigInteger> TEST_MAP_BI = TEST_HMAP_BI;
    private static final MapWrapper<BigInteger, BigInteger> TEST_WMAP_BI = new MapWrapper(TEST_MAP_BI);
    private static final BigIntegerHolder TEST_HLD_BI = new BigIntegerHolder(TEST_BI, TEST_ARR_BI, TEST_COL_BI, TEST_LST_BI, TEST_LLST_BI, TEST_SET_BI, TEST_HSET_BI, TEST_TSET_BI, TEST_MAP_BI, TEST_HMAP_BI, TEST_TMAP_BI);
    private static final InnerObject TEST_IO = new InnerObject(1, 2L);
    private static final InnerObject[] TEST_ARR_IO = new InnerObject[]{new InnerObject(1, 2L), new InnerObject(3, 4L)};
    private static final List<InnerObject> TEST_LST_IO = Arrays.asList(TEST_ARR_IO);
    private static final Collection<InnerObject> TEST_COL_IO = TEST_LST_IO;
    private static final LinkedList<InnerObject> TEST_LLST_IO = TypeTest.toLinkedList(TEST_LST_IO);
    private static final HashSet<InnerObject> TEST_HSET_IO = TypeTest.toHashSet(TEST_LST_IO);
    private static final TreeSet<InnerObject> TEST_TSET_IO = TypeTest.toTreeSet(TEST_LST_IO);
    private static final Set<InnerObject> TEST_SET_IO = TEST_HSET_IO;
    private static final HashMap<InnerObject, InnerObject> TEST_HMAP_IO = TypeTest.toHashMap(TEST_LST_IO);
    private static final MapWrapper<InnerObject, InnerObject> TEST_WHMAP_IO = new MapWrapper(TEST_HMAP_IO);
    private static final TreeMap<InnerObject, InnerObject> TEST_TMAP_IO = TypeTest.toTreeMap(TEST_LST_IO);
    private static final MapWrapper<InnerObject, InnerObject> TEST_WTMAP_IO = new MapWrapper(TEST_TMAP_IO);
    private static final Map<InnerObject, InnerObject> TEST_MAP_IO = TEST_HMAP_IO;
    private static final MapWrapper<InnerObject, InnerObject> TEST_WMAP_IO = new MapWrapper(TEST_MAP_IO);
    private static final InnerObjectHolder TEST_HLD_IO = new InnerObjectHolder(TEST_IO, TEST_ARR_IO, TEST_COL_IO, TEST_LST_IO, TEST_LLST_IO, TEST_SET_IO, TEST_HSET_IO, TEST_TSET_IO, TEST_MAP_IO, TEST_HMAP_IO, TEST_TMAP_IO);
    private static final EnumObject TEST_EO = EnumObject.ONE;
    private static final EnumObject[] TEST_ARR_EO = new EnumObject[]{EnumObject.ONE, EnumObject.TWO};
    private static final List<EnumObject> TEST_LST_EO = Arrays.asList(TEST_ARR_EO);
    private static final Collection<EnumObject> TEST_COL_EO = TEST_LST_EO;
    private static final LinkedList<EnumObject> TEST_LLST_EO = TypeTest.toLinkedList(TEST_LST_EO);
    private static final HashSet<EnumObject> TEST_HSET_EO = TypeTest.toHashSet(TEST_LST_EO);
    private static final TreeSet<EnumObject> TEST_TSET_EO = TypeTest.toTreeSet(TEST_LST_EO);
    private static final Set<EnumObject> TEST_SET_EO = TEST_HSET_EO;
    private static final HashMap<EnumObject, EnumObject> TEST_HMAP_EO = TypeTest.toHashMap(TEST_LST_EO);
    private static final MapWrapper<EnumObject, EnumObject> TEST_WHMAP_EO = new MapWrapper(TEST_HMAP_EO);
    private static final TreeMap<EnumObject, EnumObject> TEST_TMAP_EO = TypeTest.toTreeMap(TEST_LST_EO);
    private static final MapWrapper<EnumObject, EnumObject> TEST_WTMAP_EO = new MapWrapper(TEST_TMAP_EO);
    private static final Map<EnumObject, EnumObject> TEST_MAP_EO = TEST_HMAP_EO;
    private static final MapWrapper<EnumObject, EnumObject> TEST_WMAP_EO = new MapWrapper(TEST_MAP_EO);
    private static final EnumObjectHolder TEST_HLD_EO = new EnumObjectHolder(TEST_EO, TEST_ARR_EO, TEST_COL_EO, TEST_LST_EO, TEST_LLST_EO, TEST_SET_EO, TEST_HSET_EO, TEST_TSET_EO, TEST_MAP_EO, TEST_HMAP_EO, TEST_TMAP_EO);
    private static final Date TEST_DT = new Date(1L);
    private static final Date[] TEST_ARR_DT = new Date[]{new Date(1L), new Date(2L)};
    private static final List<Date> TEST_LST_DT = Arrays.asList(TEST_ARR_DT);
    private static final Collection<Date> TEST_COL_DT = TEST_LST_DT;
    private static final LinkedList<Date> TEST_LLST_DT = TypeTest.toLinkedList(TEST_LST_DT);
    private static final HashSet<Date> TEST_HSET_DT = TypeTest.toHashSet(TEST_LST_DT);
    private static final TreeSet<Date> TEST_TSET_DT = TypeTest.toTreeSet(TEST_LST_DT);
    private static final Set<Date> TEST_SET_DT = TEST_HSET_DT;
    private static final HashMap<Date, Date> TEST_HMAP_DT = TypeTest.toHashMap(TEST_LST_DT);
    private static final MapWrapper<Date, Date> TEST_WHMAP_DT = new MapWrapper(TEST_HMAP_DT);
    private static final TreeMap<Date, Date> TEST_TMAP_DT = TypeTest.toTreeMap(TEST_LST_DT);
    private static final MapWrapper<Date, Date> TEST_WTMAP_DT = new MapWrapper(TEST_TMAP_DT);
    private static final Map<Date, Date> TEST_MAP_DT = TEST_HMAP_DT;
    private static final MapWrapper<Date, Date> TEST_WMAP_DT = new MapWrapper(TEST_MAP_DT);
    private static final DateHolder TEST_HLD_DT = new DateHolder(TEST_DT, TEST_ARR_DT, TEST_COL_DT, TEST_LST_DT, TEST_LLST_DT, TEST_SET_DT, TEST_HSET_DT, TEST_TSET_DT, TEST_MAP_DT, TEST_HMAP_DT, TEST_TMAP_DT);
    private static final DateWrapper TEST_DW = new DateWrapper(new Date(1L));
    private static final DateWrapper[] TEST_ARR_DW = new DateWrapper[]{new DateWrapper(new Date(1L)), new DateWrapper(new Date(2L))};
    private static final List<DateWrapper> TEST_LST_DW = Arrays.asList(TEST_ARR_DW);
    private static final Collection<DateWrapper> TEST_COL_DW = TEST_LST_DW;
    private static final LinkedList<DateWrapper> TEST_LLST_DW = TypeTest.toLinkedList(TEST_LST_DW);
    private static final HashSet<DateWrapper> TEST_HSET_DW = TypeTest.toHashSet(TEST_LST_DW);
    private static final TreeSet<DateWrapper> TEST_TSET_DW = TypeTest.toTreeSet(TEST_LST_DW);
    private static final Set<DateWrapper> TEST_SET_DW = TEST_HSET_DW;
    private static final HashMap<DateWrapper, DateWrapper> TEST_HMAP_DW = TypeTest.toHashMap(TEST_LST_DW);
    private static final MapWrapper<DateWrapper, DateWrapper> TEST_WHMAP_DW = new MapWrapper(TEST_HMAP_DW);
    private static final TreeMap<DateWrapper, DateWrapper> TEST_TMAP_DW = TypeTest.toTreeMap(TEST_LST_DW);
    private static final MapWrapper<DateWrapper, DateWrapper> TEST_WTMAP_DW = new MapWrapper(TEST_TMAP_DW);
    private static final Map<DateWrapper, DateWrapper> TEST_MAP_DW = TEST_HMAP_DW;
    private static final MapWrapper<DateWrapper, DateWrapper> TEST_WMAP_DW = new MapWrapper(TEST_MAP_DW);
    private static final DateWrapperHolder TEST_HLD_DW = new DateWrapperHolder(TEST_DW, TEST_ARR_DW, TEST_COL_DW, TEST_LST_DW, TEST_LLST_DW, TEST_SET_DW, TEST_HSET_DW, TEST_TSET_DW, TEST_MAP_DW, TEST_HMAP_DW, TEST_TMAP_DW);
    private static final LocaleWrapper TEST_LWRP = new LocaleWrapper(Locale.FRENCH);
    private static final LocaleWrapper[] TEST_ARR_LWRP = new LocaleWrapper[]{new LocaleWrapper(Locale.GERMAN), new LocaleWrapper(Locale.ITALIAN)};
    private static final List<LocaleWrapper> TEST_LST_LWRP = Arrays.asList(TEST_ARR_LWRP);
    private static final Collection<LocaleWrapper> TEST_COL_LWRP = TEST_LST_LWRP;
    private static final LinkedList<LocaleWrapper> TEST_LLST_LWRP = TypeTest.toLinkedList(TEST_LST_LWRP);
    private static final HashSet<LocaleWrapper> TEST_HSET_LWRP = TypeTest.toHashSet(TEST_LST_LWRP);
    private static final Set<LocaleWrapper> TEST_SET_LWRP = TEST_HSET_LWRP;
    private static final HashMap<LocaleWrapper, LocaleWrapper> TEST_HMAP_LWRP = TypeTest.toHashMap(TEST_LST_LWRP);
    private static final MapWrapper<LocaleWrapper, LocaleWrapper> TEST_WHMAP_LWRP = new MapWrapper(TEST_HMAP_LWRP);
    private static final Map<LocaleWrapper, LocaleWrapper> TEST_MAP_LWRP = TEST_HMAP_LWRP;
    private static final MapWrapper<LocaleWrapper, LocaleWrapper> TEST_WMAP_LWRP = new MapWrapper(TEST_MAP_LWRP);
    private static final LocaleWrapperHolder TEST_HLD_LWRP = new LocaleWrapperHolder(TEST_LWRP, TEST_ARR_LWRP, TEST_COL_LWRP, TEST_LST_LWRP, TEST_LLST_LWRP, TEST_SET_LWRP, TEST_HSET_LWRP, null, TEST_MAP_LWRP, TEST_HMAP_LWRP, null);
    private static final SerWrapper<WrappableObject> TEST_SWRP = new SerWrapper((Serializable)new WrappableObject(1));
    private static final SerWrapper[] TEST_ARR_SWRP = new SerWrapper[]{new SerWrapper((Serializable)new WrappableObject(1)), new SerWrapper((Serializable)new WrappableObject(2))};
    private static final List<SerWrapper> TEST_LST_SWRP = Arrays.asList(TEST_ARR_SWRP);
    private static final Collection<SerWrapper> TEST_COL_SWRP = TEST_LST_SWRP;
    private static final LinkedList<SerWrapper> TEST_LLST_SWRP = TypeTest.toLinkedList(TEST_LST_SWRP);
    private static final HashSet<SerWrapper> TEST_HSET_SWRP = TypeTest.toHashSet(TEST_LST_SWRP);
    private static final TreeSet<SerWrapper> TEST_TSET_SWRP = TypeTest.toTreeSet(TEST_LST_SWRP, new SerWrapperComparator());
    private static final Set<SerWrapper> TEST_SET_SWRP = TEST_HSET_SWRP;
    private static final HashMap<SerWrapper, SerWrapper> TEST_HMAP_SWRP = TypeTest.toHashMap(TEST_LST_SWRP);
    private static final MapWrapper<SerWrapper, SerWrapper> TEST_WHMAP_SWRP = new MapWrapper(TEST_HMAP_SWRP);
    private static final TreeMap<SerWrapper, SerWrapper> TEST_TMAP_SWRP = TypeTest.toTreeMap(TEST_LST_SWRP, new SerWrapperComparator());
    private static final MapWrapper<SerWrapper, SerWrapper> TEST_WTMAP_SWRP = new MapWrapper(TEST_TMAP_SWRP);
    private static final Map<SerWrapper, SerWrapper> TEST_MAP_SWRP = TEST_HMAP_SWRP;
    private static final MapWrapper<SerWrapper, SerWrapper> TEST_WMAP_SWRP = new MapWrapper(TEST_MAP_SWRP);
    private static final SerWrapperHolder TEST_HLD_SWRP = new SerWrapperHolder(TEST_SWRP, TEST_ARR_SWRP, TEST_COL_SWRP, TEST_LST_SWRP, TEST_LLST_SWRP, TEST_SET_SWRP, TEST_HSET_SWRP, null, TEST_MAP_SWRP, TEST_HMAP_SWRP, null);
    private static final CompSerWrapper<WrappableObject> TEST_CWRP = new CompSerWrapper((Serializable)new WrappableObject(1));
    private static final CompSerWrapper[] TEST_ARR_CWRP = new CompSerWrapper[]{new CompSerWrapper((Serializable)new WrappableObject(1)), new CompSerWrapper((Serializable)new WrappableObject(2))};
    private static final List<CompSerWrapper> TEST_LST_CWRP = Arrays.asList(TEST_ARR_CWRP);
    private static final Collection<CompSerWrapper> TEST_COL_CWRP = TEST_LST_CWRP;
    private static final LinkedList<CompSerWrapper> TEST_LLST_CWRP = TypeTest.toLinkedList(TEST_LST_CWRP);
    private static final HashSet<CompSerWrapper> TEST_HSET_CWRP = TypeTest.toHashSet(TEST_LST_CWRP);
    private static final TreeSet<CompSerWrapper> TEST_TSET_CWRP = TypeTest.toTreeSet(TEST_LST_CWRP);
    private static final Set<CompSerWrapper> TEST_SET_CWRP = TEST_HSET_CWRP;
    private static final HashMap<CompSerWrapper, CompSerWrapper> TEST_HMAP_CWRP = TypeTest.toHashMap(TEST_LST_CWRP);
    private static final MapWrapper<CompSerWrapper, CompSerWrapper> TEST_WHMAP_CWRP = new MapWrapper(TEST_HMAP_CWRP);
    private static final TreeMap<CompSerWrapper, CompSerWrapper> TEST_TMAP_CWRP = TypeTest.toTreeMap(TEST_LST_CWRP);
    private static final MapWrapper<CompSerWrapper, CompSerWrapper> TEST_WTMAP_CWRP = new MapWrapper(TEST_TMAP_CWRP);
    private static final Map<CompSerWrapper, CompSerWrapper> TEST_MAP_CWRP = TEST_HMAP_CWRP;
    private static final MapWrapper<CompSerWrapper, CompSerWrapper> TEST_WMAP_CWRP = new MapWrapper(TEST_MAP_CWRP);
    private static final CompSerWrapperHolder TEST_HLD_CWRP = new CompSerWrapperHolder(TEST_CWRP, TEST_ARR_CWRP, TEST_COL_CWRP, TEST_LST_CWRP, TEST_LLST_CWRP, TEST_SET_CWRP, TEST_HSET_CWRP, TEST_TSET_CWRP, TEST_MAP_CWRP, TEST_HMAP_CWRP, TEST_TMAP_CWRP);
    private static final String TEST_MSG = "a";

    private static <V> LinkedList<V> toLinkedList(List<V> in) {
        LinkedList<V> out = new LinkedList<V>();
        out.addAll(in);
        return out;
    }

    private static <V> HashSet<V> toHashSet(List<V> in) {
        HashSet<V> out = new HashSet<V>();
        out.addAll(in);
        return out;
    }

    private static <V> TreeSet<V> toTreeSet(List<V> in, Comparator<? super V> comparator) {
        TreeSet<Object> out = comparator == null ? new TreeSet() : new TreeSet<V>(comparator);
        out.addAll(in);
        return out;
    }

    private static <V> TreeSet<V> toTreeSet(List<V> in) {
        return TypeTest.toTreeSet(in, null);
    }

    private static <V> HashMap<V, V> toHashMap(List<V> in) {
        HashMap<V, V> out = new HashMap<V, V>();
        for (V item : in) {
            out.put(item, item);
        }
        return out;
    }

    private static <V> TreeMap<V, V> toTreeMap(List<V> in, Comparator<? super V> comparator) {
        TreeMap<Object, V> out = comparator == null ? new TreeMap() : new TreeMap(comparator);
        for (V item : in) {
            out.put(item, item);
        }
        return out;
    }

    private static <V> TreeMap<V, V> toTreeMap(List<V> in) {
        return TypeTest.toTreeMap(in, null);
    }

    private static void assertColEquals(Collection<?> expected, Collection<?> actual) {
        Assert.assertEquals(expected, actual);
        Assert.assertEquals(ArrayList.class, actual.getClass());
    }

    private static void assertSetEquals(Set<?> expected, Set<?> actual) {
        Assert.assertEquals(expected, actual);
        Assert.assertEquals(HashSet.class, actual.getClass());
    }

    private static void assertMapEquals(MapWrapper<?, ?> expected, MapWrapper<?, ?> actual) {
        Assert.assertEquals((Object)expected.getMap(), (Object)actual.getMap());
        Assert.assertEquals(HashMap.class, actual.getMap().getClass());
    }

    @Test
    public void arguments() throws Exception {
        StatelessServer server = new StatelessServer();
        server.publish((StatelessServiceBase)new ServiceImpl(), Service.class);
        StatelessClient client = new StatelessClient();
        Service i = (Service)client.getService(Service.class);
        Assert.assertEquals((Object)true, (Object)i.pBoolean(client.getContext(), true));
        Assert.assertEquals((Object)TEST_O_BOOLEAN, (Object)i.oBoolean(client.getContext(), TEST_O_BOOLEAN));
        Assert.assertTrue((boolean)ArrayUtils.isEquals((Object)TEST_PARR_BOOLEAN, (Object)i.pArrBoolean(client.getContext(), TEST_PARR_BOOLEAN)));
        Assert.assertTrue((boolean)ArrayUtils.isEquals((Object)TEST_OARR_BOOLEAN, (Object)i.oArrBoolean(client.getContext(), TEST_OARR_BOOLEAN)));
        TypeTest.assertColEquals(TEST_COL_BOOLEAN, i.colBoolean(client.getContext(), TEST_COL_BOOLEAN));
        TypeTest.assertColEquals(TEST_LST_BOOLEAN, i.colBoolean(client.getContext(), TEST_LST_BOOLEAN));
        TypeTest.assertColEquals(TEST_LLST_BOOLEAN, i.colBoolean(client.getContext(), TEST_LLST_BOOLEAN));
        TypeTest.assertSetEquals(TEST_SET_BOOLEAN, i.setBoolean(client.getContext(), TEST_SET_BOOLEAN));
        TypeTest.assertSetEquals(TEST_HSET_BOOLEAN, i.setBoolean(client.getContext(), TEST_HSET_BOOLEAN));
        TypeTest.assertSetEquals(TEST_TSET_BOOLEAN, i.setBoolean(client.getContext(), TEST_TSET_BOOLEAN));
        TypeTest.assertMapEquals(TEST_WMAP_BOOLEAN, i.mapBoolean(client.getContext(), TEST_WMAP_BOOLEAN));
        TypeTest.assertMapEquals(TEST_WHMAP_BOOLEAN, i.mapBoolean(client.getContext(), TEST_WHMAP_BOOLEAN));
        TypeTest.assertMapEquals(TEST_WTMAP_BOOLEAN, i.mapBoolean(client.getContext(), TEST_WTMAP_BOOLEAN));
        Assert.assertEquals((Object)TEST_HLD_BOOLEAN, (Object)i.hldBoolean(client.getContext(), TEST_HLD_BOOLEAN));
        Assert.assertEquals((long)-128L, (long)i.pByte(client.getContext(), (byte)-128));
        Assert.assertEquals((Object)TEST_O_BYTE, (Object)i.oByte(client.getContext(), TEST_O_BYTE));
        Assert.assertArrayEquals((byte[])TEST_PARR_BYTE, (byte[])i.pArrByte(client.getContext(), TEST_PARR_BYTE));
        Assert.assertArrayEquals((Object[])TEST_OARR_BYTE, (Object[])i.oArrByte(client.getContext(), TEST_OARR_BYTE));
        TypeTest.assertColEquals(TEST_COL_BYTE, i.colByte(client.getContext(), TEST_COL_BYTE));
        TypeTest.assertColEquals(TEST_LST_BYTE, i.colByte(client.getContext(), TEST_LST_BYTE));
        TypeTest.assertColEquals(TEST_LLST_BYTE, i.colByte(client.getContext(), TEST_LLST_BYTE));
        TypeTest.assertSetEquals(TEST_SET_BYTE, i.setByte(client.getContext(), TEST_SET_BYTE));
        TypeTest.assertSetEquals(TEST_HSET_BYTE, i.setByte(client.getContext(), TEST_HSET_BYTE));
        TypeTest.assertSetEquals(TEST_TSET_BYTE, i.setByte(client.getContext(), TEST_TSET_BYTE));
        TypeTest.assertMapEquals(TEST_WMAP_BYTE, i.mapByte(client.getContext(), TEST_WMAP_BYTE));
        TypeTest.assertMapEquals(TEST_WHMAP_BYTE, i.mapByte(client.getContext(), TEST_WHMAP_BYTE));
        TypeTest.assertMapEquals(TEST_WTMAP_BYTE, i.mapByte(client.getContext(), TEST_WTMAP_BYTE));
        Assert.assertEquals((Object)TEST_HLD_BYTE, (Object)i.hldByte(client.getContext(), TEST_HLD_BYTE));
        Assert.assertEquals((long)1L, (long)i.pChar(client.getContext(), '\u0001'));
        Assert.assertEquals((Object)TEST_O_CHAR, (Object)i.oChar(client.getContext(), TEST_O_CHAR));
        Assert.assertArrayEquals((char[])TEST_PARR_CHAR, (char[])i.pArrChar(client.getContext(), TEST_PARR_CHAR));
        Assert.assertArrayEquals((Object[])TEST_OARR_CHAR, (Object[])i.oArrChar(client.getContext(), TEST_OARR_CHAR));
        TypeTest.assertColEquals(TEST_COL_CHAR, i.colChar(client.getContext(), TEST_COL_CHAR));
        TypeTest.assertColEquals(TEST_LST_CHAR, i.colChar(client.getContext(), TEST_LST_CHAR));
        TypeTest.assertColEquals(TEST_LLST_CHAR, i.colChar(client.getContext(), TEST_LLST_CHAR));
        TypeTest.assertSetEquals(TEST_SET_CHAR, i.setChar(client.getContext(), TEST_SET_CHAR));
        TypeTest.assertSetEquals(TEST_HSET_CHAR, i.setChar(client.getContext(), TEST_HSET_CHAR));
        TypeTest.assertSetEquals(TEST_TSET_CHAR, i.setChar(client.getContext(), TEST_TSET_CHAR));
        Assert.assertEquals((Object)TEST_HLD_CHAR, (Object)i.hldChar(client.getContext(), TEST_HLD_CHAR));
        Assert.assertEquals((double)Double.MIN_VALUE, (double)i.pDouble(client.getContext(), Double.MIN_VALUE), (double)1.0E-4);
        Assert.assertEquals((double)TEST_O_DOUBLE, (double)i.oDouble(client.getContext(), TEST_O_DOUBLE), (double)1.0E-4);
        Assert.assertTrue((boolean)ArrayUtils.isEquals((Object)TEST_PARR_DOUBLE, (Object)i.pArrDouble(client.getContext(), TEST_PARR_DOUBLE)));
        Assert.assertTrue((boolean)ArrayUtils.isEquals((Object)TEST_OARR_DOUBLE, (Object)i.oArrDouble(client.getContext(), TEST_OARR_DOUBLE)));
        TypeTest.assertColEquals(TEST_COL_DOUBLE, i.colDouble(client.getContext(), TEST_COL_DOUBLE));
        TypeTest.assertColEquals(TEST_LST_DOUBLE, i.colDouble(client.getContext(), TEST_LST_DOUBLE));
        TypeTest.assertColEquals(TEST_LLST_DOUBLE, i.colDouble(client.getContext(), TEST_LLST_DOUBLE));
        TypeTest.assertSetEquals(TEST_SET_DOUBLE, i.setDouble(client.getContext(), TEST_SET_DOUBLE));
        TypeTest.assertSetEquals(TEST_HSET_DOUBLE, i.setDouble(client.getContext(), TEST_HSET_DOUBLE));
        TypeTest.assertSetEquals(TEST_TSET_DOUBLE, i.setDouble(client.getContext(), TEST_TSET_DOUBLE));
        TypeTest.assertMapEquals(TEST_WMAP_DOUBLE, i.mapDouble(client.getContext(), TEST_WMAP_DOUBLE));
        TypeTest.assertMapEquals(TEST_WHMAP_DOUBLE, i.mapDouble(client.getContext(), TEST_WHMAP_DOUBLE));
        TypeTest.assertMapEquals(TEST_WTMAP_DOUBLE, i.mapDouble(client.getContext(), TEST_WTMAP_DOUBLE));
        Assert.assertEquals((Object)TEST_HLD_DOUBLE, (Object)i.hldDouble(client.getContext(), TEST_HLD_DOUBLE));
        Assert.assertEquals((double)1.4E-45f, (double)i.pFloat(client.getContext(), Float.MIN_VALUE), (double)1.0E-4f);
        Assert.assertEquals((double)TEST_O_FLOAT.floatValue(), (double)i.oFloat(client.getContext(), TEST_O_FLOAT).floatValue(), (double)1.0E-4f);
        Assert.assertTrue((boolean)ArrayUtils.isEquals((Object)TEST_PARR_FLOAT, (Object)i.pArrFloat(client.getContext(), TEST_PARR_FLOAT)));
        Assert.assertTrue((boolean)ArrayUtils.isEquals((Object)TEST_OARR_FLOAT, (Object)i.oArrFloat(client.getContext(), TEST_OARR_FLOAT)));
        TypeTest.assertColEquals(TEST_COL_FLOAT, i.colFloat(client.getContext(), TEST_COL_FLOAT));
        TypeTest.assertColEquals(TEST_LST_FLOAT, i.colFloat(client.getContext(), TEST_LST_FLOAT));
        TypeTest.assertColEquals(TEST_LLST_FLOAT, i.colFloat(client.getContext(), TEST_LLST_FLOAT));
        TypeTest.assertSetEquals(TEST_SET_FLOAT, i.setFloat(client.getContext(), TEST_SET_FLOAT));
        TypeTest.assertSetEquals(TEST_HSET_FLOAT, i.setFloat(client.getContext(), TEST_HSET_FLOAT));
        TypeTest.assertSetEquals(TEST_TSET_FLOAT, i.setFloat(client.getContext(), TEST_TSET_FLOAT));
        TypeTest.assertMapEquals(TEST_WMAP_FLOAT, i.mapFloat(client.getContext(), TEST_WMAP_FLOAT));
        TypeTest.assertMapEquals(TEST_WHMAP_FLOAT, i.mapFloat(client.getContext(), TEST_WHMAP_FLOAT));
        TypeTest.assertMapEquals(TEST_WTMAP_FLOAT, i.mapFloat(client.getContext(), TEST_WTMAP_FLOAT));
        Assert.assertEquals((Object)TEST_HLD_FLOAT, (Object)i.hldFloat(client.getContext(), TEST_HLD_FLOAT));
        Assert.assertEquals((long)Integer.MIN_VALUE, (long)i.pInt(client.getContext(), Integer.MIN_VALUE));
        Assert.assertEquals((Object)TEST_O_INT, (Object)i.oInt(client.getContext(), TEST_O_INT));
        Assert.assertArrayEquals((int[])TEST_PARR_INT, (int[])i.pArrInt(client.getContext(), TEST_PARR_INT));
        Assert.assertArrayEquals((Object[])TEST_OARR_INT, (Object[])i.oArrInt(client.getContext(), TEST_OARR_INT));
        TypeTest.assertColEquals(TEST_COL_INT, i.colInt(client.getContext(), TEST_COL_INT));
        TypeTest.assertColEquals(TEST_LST_INT, i.colInt(client.getContext(), TEST_LST_INT));
        TypeTest.assertColEquals(TEST_LLST_INT, i.colInt(client.getContext(), TEST_LLST_INT));
        TypeTest.assertSetEquals(TEST_SET_INT, i.setInt(client.getContext(), TEST_SET_INT));
        TypeTest.assertSetEquals(TEST_HSET_INT, i.setInt(client.getContext(), TEST_HSET_INT));
        TypeTest.assertSetEquals(TEST_TSET_INT, i.setInt(client.getContext(), TEST_TSET_INT));
        TypeTest.assertMapEquals(TEST_WMAP_INT, i.mapInt(client.getContext(), TEST_WMAP_INT));
        TypeTest.assertMapEquals(TEST_WHMAP_INT, i.mapInt(client.getContext(), TEST_WHMAP_INT));
        TypeTest.assertMapEquals(TEST_WTMAP_INT, i.mapInt(client.getContext(), TEST_WTMAP_INT));
        Assert.assertEquals((Object)TEST_HLD_INT, (Object)i.hldInt(client.getContext(), TEST_HLD_INT));
        Assert.assertEquals((long)Long.MIN_VALUE, (long)i.pLong(client.getContext(), Long.MIN_VALUE));
        Assert.assertEquals((Object)TEST_O_LONG, (Object)i.oLong(client.getContext(), TEST_O_LONG));
        Assert.assertArrayEquals((long[])TEST_PARR_LONG, (long[])i.pArrLong(client.getContext(), TEST_PARR_LONG));
        Assert.assertArrayEquals((Object[])TEST_OARR_LONG, (Object[])i.oArrLong(client.getContext(), TEST_OARR_LONG));
        TypeTest.assertColEquals(TEST_COL_LONG, i.colLong(client.getContext(), TEST_COL_LONG));
        TypeTest.assertColEquals(TEST_LST_LONG, i.colLong(client.getContext(), TEST_LST_LONG));
        TypeTest.assertColEquals(TEST_LLST_LONG, i.colLong(client.getContext(), TEST_LLST_LONG));
        TypeTest.assertSetEquals(TEST_SET_LONG, i.setLong(client.getContext(), TEST_SET_LONG));
        TypeTest.assertSetEquals(TEST_HSET_LONG, i.setLong(client.getContext(), TEST_HSET_LONG));
        TypeTest.assertSetEquals(TEST_TSET_LONG, i.setLong(client.getContext(), TEST_TSET_LONG));
        TypeTest.assertMapEquals(TEST_WMAP_LONG, i.mapLong(client.getContext(), TEST_WMAP_LONG));
        TypeTest.assertMapEquals(TEST_WHMAP_LONG, i.mapLong(client.getContext(), TEST_WHMAP_LONG));
        TypeTest.assertMapEquals(TEST_WTMAP_LONG, i.mapLong(client.getContext(), TEST_WTMAP_LONG));
        Assert.assertEquals((Object)TEST_HLD_LONG, (Object)i.hldLong(client.getContext(), TEST_HLD_LONG));
        Assert.assertEquals((long)-32768L, (long)i.pShort(client.getContext(), (short)Short.MIN_VALUE));
        Assert.assertEquals((Object)TEST_O_SHORT, (Object)i.oShort(client.getContext(), TEST_O_SHORT));
        Assert.assertArrayEquals((short[])TEST_PARR_SHORT, (short[])i.pArrShort(client.getContext(), TEST_PARR_SHORT));
        Assert.assertArrayEquals((Object[])TEST_OARR_SHORT, (Object[])i.oArrShort(client.getContext(), TEST_OARR_SHORT));
        TypeTest.assertColEquals(TEST_COL_SHORT, i.colShort(client.getContext(), TEST_COL_SHORT));
        TypeTest.assertColEquals(TEST_LST_SHORT, i.colShort(client.getContext(), TEST_LST_SHORT));
        TypeTest.assertColEquals(TEST_LLST_SHORT, i.colShort(client.getContext(), TEST_LLST_SHORT));
        TypeTest.assertSetEquals(TEST_SET_SHORT, i.setShort(client.getContext(), TEST_SET_SHORT));
        TypeTest.assertSetEquals(TEST_HSET_SHORT, i.setShort(client.getContext(), TEST_HSET_SHORT));
        TypeTest.assertSetEquals(TEST_TSET_SHORT, i.setShort(client.getContext(), TEST_TSET_SHORT));
        TypeTest.assertMapEquals(TEST_WMAP_SHORT, i.mapShort(client.getContext(), TEST_WMAP_SHORT));
        TypeTest.assertMapEquals(TEST_WHMAP_SHORT, i.mapShort(client.getContext(), TEST_WHMAP_SHORT));
        TypeTest.assertMapEquals(TEST_WTMAP_SHORT, i.mapShort(client.getContext(), TEST_WTMAP_SHORT));
        Assert.assertEquals((Object)TEST_HLD_SHORT, (Object)i.hldShort(client.getContext(), TEST_HLD_SHORT));
        Assert.assertEquals((Object)TEST_STR, (Object)i.str(client.getContext(), TEST_STR));
        Assert.assertArrayEquals((Object[])TEST_ARR_STR, (Object[])i.arrStr(client.getContext(), TEST_ARR_STR));
        TypeTest.assertColEquals(TEST_COL_STR, i.colStr(client.getContext(), TEST_COL_STR));
        TypeTest.assertColEquals(TEST_LST_STR, i.colStr(client.getContext(), TEST_LST_STR));
        TypeTest.assertColEquals(TEST_LLST_STR, i.colStr(client.getContext(), TEST_LLST_STR));
        TypeTest.assertSetEquals(TEST_SET_STR, i.setStr(client.getContext(), TEST_SET_STR));
        TypeTest.assertSetEquals(TEST_HSET_STR, i.setStr(client.getContext(), TEST_HSET_STR));
        TypeTest.assertSetEquals(TEST_TSET_STR, i.setStr(client.getContext(), TEST_TSET_STR));
        TypeTest.assertMapEquals(TEST_WMAP_STR, i.mapStr(client.getContext(), TEST_WMAP_STR));
        TypeTest.assertMapEquals(TEST_WHMAP_STR, i.mapStr(client.getContext(), TEST_WHMAP_STR));
        TypeTest.assertMapEquals(TEST_WTMAP_STR, i.mapStr(client.getContext(), TEST_WTMAP_STR));
        Assert.assertEquals((Object)TEST_HLD_STR, (Object)i.hldStr(client.getContext(), TEST_HLD_STR));
        Assert.assertEquals((Object)TEST_BD, (Object)i.bd(client.getContext(), TEST_BD));
        Assert.assertArrayEquals((Object[])TEST_ARR_BD, (Object[])i.arrBd(client.getContext(), TEST_ARR_BD));
        TypeTest.assertColEquals(TEST_COL_BD, i.colBd(client.getContext(), TEST_COL_BD));
        TypeTest.assertColEquals(TEST_LST_BD, i.colBd(client.getContext(), TEST_LST_BD));
        TypeTest.assertColEquals(TEST_LLST_BD, i.colBd(client.getContext(), TEST_LLST_BD));
        TypeTest.assertSetEquals(TEST_SET_BD, i.setBd(client.getContext(), TEST_SET_BD));
        TypeTest.assertSetEquals(TEST_HSET_BD, i.setBd(client.getContext(), TEST_HSET_BD));
        TypeTest.assertSetEquals(TEST_TSET_BD, i.setBd(client.getContext(), TEST_TSET_BD));
        TypeTest.assertMapEquals(TEST_WMAP_BD, i.mapBd(client.getContext(), TEST_WMAP_BD));
        TypeTest.assertMapEquals(TEST_WHMAP_BD, i.mapBd(client.getContext(), TEST_WHMAP_BD));
        TypeTest.assertMapEquals(TEST_WTMAP_BD, i.mapBd(client.getContext(), TEST_WTMAP_BD));
        Assert.assertEquals((Object)TEST_HLD_BD, (Object)i.hldBd(client.getContext(), TEST_HLD_BD));
        Assert.assertEquals((Object)TEST_BI, (Object)i.bi(client.getContext(), TEST_BI));
        Assert.assertArrayEquals((Object[])TEST_ARR_BI, (Object[])i.arrBi(client.getContext(), TEST_ARR_BI));
        TypeTest.assertColEquals(TEST_COL_BI, i.colBi(client.getContext(), TEST_COL_BI));
        TypeTest.assertColEquals(TEST_LST_BI, i.colBi(client.getContext(), TEST_LST_BI));
        TypeTest.assertColEquals(TEST_LLST_BI, i.colBi(client.getContext(), TEST_LLST_BI));
        TypeTest.assertSetEquals(TEST_SET_BI, i.setBi(client.getContext(), TEST_SET_BI));
        TypeTest.assertSetEquals(TEST_HSET_BI, i.setBi(client.getContext(), TEST_HSET_BI));
        TypeTest.assertSetEquals(TEST_TSET_BI, i.setBi(client.getContext(), TEST_TSET_BI));
        TypeTest.assertMapEquals(TEST_WMAP_BI, i.mapBi(client.getContext(), TEST_WMAP_BI));
        TypeTest.assertMapEquals(TEST_WHMAP_BI, i.mapBi(client.getContext(), TEST_WHMAP_BI));
        TypeTest.assertMapEquals(TEST_WTMAP_BI, i.mapBi(client.getContext(), TEST_WTMAP_BI));
        Assert.assertEquals((Object)TEST_HLD_BI, (Object)i.hldBi(client.getContext(), TEST_HLD_BI));
        Assert.assertEquals((Object)TEST_IO, (Object)i.io(client.getContext(), TEST_IO));
        Assert.assertArrayEquals((Object[])TEST_ARR_IO, (Object[])i.arrIo(client.getContext(), TEST_ARR_IO));
        TypeTest.assertColEquals(TEST_COL_IO, i.colIo(client.getContext(), TEST_COL_IO));
        TypeTest.assertColEquals(TEST_LST_IO, i.colIo(client.getContext(), TEST_LST_IO));
        TypeTest.assertColEquals(TEST_LLST_IO, i.colIo(client.getContext(), TEST_LLST_IO));
        TypeTest.assertSetEquals(TEST_SET_IO, i.setIo(client.getContext(), TEST_SET_IO));
        TypeTest.assertSetEquals(TEST_HSET_IO, i.setIo(client.getContext(), TEST_HSET_IO));
        TypeTest.assertSetEquals(TEST_TSET_IO, i.setIo(client.getContext(), TEST_TSET_IO));
        TypeTest.assertMapEquals(TEST_WMAP_IO, i.mapIo(client.getContext(), TEST_WMAP_IO));
        TypeTest.assertMapEquals(TEST_WHMAP_IO, i.mapIo(client.getContext(), TEST_WHMAP_IO));
        TypeTest.assertMapEquals(TEST_WTMAP_IO, i.mapIo(client.getContext(), TEST_WTMAP_IO));
        Assert.assertEquals((Object)TEST_HLD_IO, (Object)i.hldIo(client.getContext(), TEST_HLD_IO));
        Assert.assertEquals((Object)((Object)TEST_EO), (Object)((Object)i.eo(client.getContext(), TEST_EO)));
        Assert.assertArrayEquals((Object[])TEST_ARR_EO, (Object[])i.arrEo(client.getContext(), TEST_ARR_EO));
        TypeTest.assertColEquals(TEST_COL_EO, i.colEo(client.getContext(), TEST_COL_EO));
        TypeTest.assertColEquals(TEST_LST_EO, i.colEo(client.getContext(), TEST_LST_EO));
        TypeTest.assertColEquals(TEST_LLST_EO, i.colEo(client.getContext(), TEST_LLST_EO));
        TypeTest.assertSetEquals(TEST_SET_EO, i.setEo(client.getContext(), TEST_SET_EO));
        TypeTest.assertSetEquals(TEST_HSET_EO, i.setEo(client.getContext(), TEST_HSET_EO));
        TypeTest.assertSetEquals(TEST_TSET_EO, i.setEo(client.getContext(), TEST_TSET_EO));
        TypeTest.assertMapEquals(TEST_WMAP_EO, i.mapEo(client.getContext(), TEST_WMAP_EO));
        TypeTest.assertMapEquals(TEST_WHMAP_EO, i.mapEo(client.getContext(), TEST_WHMAP_EO));
        TypeTest.assertMapEquals(TEST_WTMAP_EO, i.mapEo(client.getContext(), TEST_WTMAP_EO));
        Assert.assertEquals((Object)TEST_HLD_EO, (Object)i.hldEo(client.getContext(), TEST_HLD_EO));
        Assert.assertEquals((Object)TEST_DW, (Object)i.dw(client.getContext(), TEST_DW));
        Assert.assertArrayEquals((Object[])TEST_ARR_DW, (Object[])i.arrDw(client.getContext(), TEST_ARR_DW));
        TypeTest.assertColEquals(TEST_COL_DW, i.colDw(client.getContext(), TEST_COL_DW));
        TypeTest.assertColEquals(TEST_LST_DW, i.colDw(client.getContext(), TEST_LST_DW));
        TypeTest.assertColEquals(TEST_LLST_DW, i.colDw(client.getContext(), TEST_LLST_DW));
        TypeTest.assertSetEquals(TEST_SET_DW, i.setDw(client.getContext(), TEST_SET_DW));
        TypeTest.assertSetEquals(TEST_HSET_DW, i.setDw(client.getContext(), TEST_HSET_DW));
        TypeTest.assertSetEquals(TEST_TSET_DW, i.setDw(client.getContext(), TEST_TSET_DW));
        TypeTest.assertMapEquals(TEST_WMAP_DW, i.mapDw(client.getContext(), TEST_WMAP_DW));
        TypeTest.assertMapEquals(TEST_WHMAP_DW, i.mapDw(client.getContext(), TEST_WHMAP_DW));
        TypeTest.assertMapEquals(TEST_WTMAP_DW, i.mapDw(client.getContext(), TEST_WTMAP_DW));
        Assert.assertEquals((Object)TEST_HLD_DW, (Object)i.hldDw(client.getContext(), TEST_HLD_DW));
        Assert.assertEquals((Object)TEST_LWRP, (Object)i.lwrp(client.getContext(), TEST_LWRP));
        Assert.assertArrayEquals((Object[])TEST_ARR_LWRP, (Object[])i.arrLwrp(client.getContext(), TEST_ARR_LWRP));
        TypeTest.assertColEquals(TEST_COL_LWRP, i.colLwrp(client.getContext(), TEST_COL_LWRP));
        TypeTest.assertColEquals(TEST_LST_LWRP, i.colLwrp(client.getContext(), TEST_LST_LWRP));
        TypeTest.assertColEquals(TEST_LLST_LWRP, i.colLwrp(client.getContext(), TEST_LLST_LWRP));
        TypeTest.assertSetEquals(TEST_SET_LWRP, i.setLwrp(client.getContext(), TEST_SET_LWRP));
        TypeTest.assertSetEquals(TEST_HSET_LWRP, i.setLwrp(client.getContext(), TEST_HSET_LWRP));
        TypeTest.assertMapEquals(TEST_WMAP_LWRP, i.mapLwrp(client.getContext(), TEST_WMAP_LWRP));
        TypeTest.assertMapEquals(TEST_WHMAP_LWRP, i.mapLwrp(client.getContext(), TEST_WHMAP_LWRP));
        Assert.assertEquals((Object)TEST_HLD_LWRP, (Object)i.hldLwrp(client.getContext(), TEST_HLD_LWRP));
        Assert.assertEquals(TEST_SWRP, i.swrp(client.getContext(), TEST_SWRP));
        Assert.assertArrayEquals((Object[])TEST_ARR_SWRP, (Object[])i.arrSwrp(client.getContext(), TEST_ARR_SWRP));
        TypeTest.assertColEquals(TEST_COL_SWRP, i.colSwrp(client.getContext(), TEST_COL_SWRP));
        TypeTest.assertColEquals(TEST_LST_SWRP, i.colSwrp(client.getContext(), TEST_LST_SWRP));
        TypeTest.assertColEquals(TEST_LLST_SWRP, i.colSwrp(client.getContext(), TEST_LLST_SWRP));
        TypeTest.assertSetEquals(TEST_SET_SWRP, i.setSwrp(client.getContext(), TEST_SET_SWRP));
        TypeTest.assertSetEquals(TEST_HSET_SWRP, i.setSwrp(client.getContext(), TEST_HSET_SWRP));
        TypeTest.assertSetEquals(TEST_TSET_SWRP, i.setSwrp(client.getContext(), TEST_TSET_SWRP));
        TypeTest.assertMapEquals(TEST_WMAP_SWRP, i.mapSwrp(client.getContext(), TEST_WMAP_SWRP));
        TypeTest.assertMapEquals(TEST_WHMAP_SWRP, i.mapSwrp(client.getContext(), TEST_WHMAP_SWRP));
        TypeTest.assertMapEquals(TEST_WTMAP_SWRP, i.mapSwrp(client.getContext(), TEST_WTMAP_SWRP));
        Assert.assertEquals((Object)TEST_HLD_SWRP, (Object)i.hldSwrp(client.getContext(), TEST_HLD_SWRP));
        Assert.assertEquals(TEST_CWRP, i.cwrp(client.getContext(), TEST_CWRP));
        Assert.assertArrayEquals((Object[])TEST_ARR_CWRP, (Object[])i.arrCwrp(client.getContext(), TEST_ARR_CWRP));
        TypeTest.assertColEquals(TEST_COL_CWRP, i.colCwrp(client.getContext(), TEST_COL_CWRP));
        TypeTest.assertColEquals(TEST_LST_CWRP, i.colCwrp(client.getContext(), TEST_LST_CWRP));
        TypeTest.assertColEquals(TEST_LLST_CWRP, i.colCwrp(client.getContext(), TEST_LLST_CWRP));
        TypeTest.assertSetEquals(TEST_SET_CWRP, i.setCwrp(client.getContext(), TEST_SET_CWRP));
        TypeTest.assertSetEquals(TEST_HSET_CWRP, i.setCwrp(client.getContext(), TEST_HSET_CWRP));
        TypeTest.assertSetEquals(TEST_TSET_CWRP, i.setCwrp(client.getContext(), TEST_TSET_CWRP));
        TypeTest.assertMapEquals(TEST_WMAP_CWRP, i.mapCwrp(client.getContext(), TEST_WMAP_CWRP));
        TypeTest.assertMapEquals(TEST_WHMAP_CWRP, i.mapCwrp(client.getContext(), TEST_WHMAP_CWRP));
        TypeTest.assertMapEquals(TEST_WTMAP_CWRP, i.mapCwrp(client.getContext(), TEST_WTMAP_CWRP));
        Assert.assertEquals((Object)TEST_HLD_CWRP, (Object)i.hldCwrp(client.getContext(), TEST_HLD_CWRP));
        try {
            i.checkedException(client.getContext(), TEST_MSG);
            Assert.fail();
        }
        catch (RemoteException ex) {
            Assert.assertTrue((String)ex.getCause().getClass().getName(), (boolean)(ex.getCause() instanceof Service.CustomCheckedException));
            Assert.assertEquals((Object)TEST_MSG, (Object)ex.getCause().getMessage());
        }
        try {
            i.runtimeException(client.getContext(), TEST_MSG);
            Assert.fail();
        }
        catch (RemoteException ex) {
            Assert.assertTrue((String)ex.getCause().getClass().getName(), (boolean)(ex.getCause() instanceof Service.CustomRuntimeException));
            Assert.assertEquals((Object)TEST_MSG, (Object)ex.getCause().getMessage());
        }
        try {
            i.error(client.getContext(), TEST_MSG);
            Assert.fail();
        }
        catch (RemoteException ex) {
            Assert.assertTrue((String)ex.getCause().getClass().getName(), (boolean)(ex.getCause() instanceof Service.CustomError));
            Assert.assertEquals((Object)TEST_MSG, (Object)ex.getCause().getMessage());
        }
    }

    private static class SerWrapperComparator
    implements Comparator<SerWrapper> {
        private SerWrapperComparator() {
        }

        @Override
        public int compare(SerWrapper o1, SerWrapper o2) {
            return ((WrappableObject)o1.getRaw()).compareTo((WrappableObject)o2.getRaw());
        }

        public int hashCode() {
            return 0;
        }

        @Override
        public boolean equals(Object other) {
            return other != null && this.getClass().equals(other.getClass());
        }
    }
}

