/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.auth;

import java.io.PrintStream;
import java.util.HashSet;
import java.util.LinkedList;
import org.marketcetera.util.auth.Context;
import org.marketcetera.util.auth.Holder;
import org.marketcetera.util.auth.Messages;
import org.marketcetera.util.auth.Setter;
import org.marketcetera.util.except.ExceptUtils;
import org.marketcetera.util.except.I18NException;
import org.marketcetera.util.misc.ClassVersion;

@ClassVersion(value="$Id: AuthenticationSystem.java 16154 2012-07-14 16:34:05Z colin $")
public class AuthenticationSystem {
    private LinkedList<Context<?>> mContexts = new LinkedList();

    public void add(Context<?> context) {
        this.mContexts.add(context);
    }

    public void printUsage(PrintStream stream) {
        for (Context context : this.mContexts) {
            context.printUsage(stream);
            stream.println();
        }
    }

    public boolean setValues() {
        HashSet holders = new HashSet();
        for (Context context : this.mContexts) {
            boolean needProcess = false;
            for (Setter setter : context.getSetters()) {
                holders.add(setter.getHolder());
                needProcess = needProcess || context.shouldProcess(setter);
            }
            if (!needProcess) continue;
            try {
                context.setValues();
            }
            catch (I18NException ex) {
                ExceptUtils.swallow(ex, this, Messages.CONTEXT_FAILED);
            }
        }
        boolean allSet = true;
        for (Holder holder : holders) {
            if (holder.isSet() || holder.getMessage() == null) continue;
            holder.getMessage().error(this);
            allSet = false;
        }
        return allSet;
    }
}

