/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.auth;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.marketcetera.util.auth.CliSetter;
import org.marketcetera.util.auth.Context;
import org.marketcetera.util.auth.Messages;
import org.marketcetera.util.auth.OptionsProvider;
import org.marketcetera.util.except.ExceptUtils;
import org.marketcetera.util.except.I18NException;
import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.misc.ClassVersion;

@ClassVersion(value="$Id: CliContext.java 16154 2012-07-14 16:34:05Z colin $")
public class CliContext
extends Context<CliSetter<?>> {
    private String[] mArgs;
    private CommandLine mCommandLine;
    private OptionsProvider mOptionsProvider;
    private ParseException mParseException;

    public CliContext(I18NBoundMessage name, boolean override, String[] args) {
        super(name, override);
        this.mArgs = args;
    }

    public CliContext(boolean override, String[] args) {
        this(Messages.CLI_NAME, override, args);
    }

    public String[] getArgs() {
        return this.mArgs;
    }

    public CommandLine getCommandLine() {
        return this.mCommandLine;
    }

    @Override
    public void setValues() throws I18NException {
        Options options = new Options();
        for (CliSetter setter : this.getSetters()) {
            setter.addOption(options);
        }
        if (this.getOptionsProvider() != null) {
            this.getOptionsProvider().addOptions(options);
        }
        try {
            this.mCommandLine = new GnuParser().parse(options, this.getArgs());
        }
        catch (ParseException ex) {
            this.setParseException(ex);
            throw ExceptUtils.wrap(ex, Messages.PARSING_FAILED);
        }
        for (CliSetter setter : this.getSetters()) {
            if (!this.shouldProcess(setter)) continue;
            setter.setValue(this.getCommandLine());
        }
    }

    public void setOptionsProvider(OptionsProvider optionsProvider) {
        this.mOptionsProvider = optionsProvider;
    }

    public OptionsProvider getOptionsProvider() {
        return this.mOptionsProvider;
    }

    private void setParseException(ParseException parseException) {
        this.mParseException = parseException;
    }

    public ParseException getParseException() {
        return this.mParseException;
    }
}

