/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.auth;

import java.io.PrintStream;
import java.util.LinkedList;
import org.marketcetera.util.auth.Holder;
import org.marketcetera.util.auth.Messages;
import org.marketcetera.util.auth.Setter;
import org.marketcetera.util.except.I18NException;
import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.misc.ClassVersion;

@ClassVersion(value="$Id: Context.java 16154 2012-07-14 16:34:05Z colin $")
public abstract class Context<T extends Setter<?>> {
    private I18NBoundMessage mName;
    private boolean mOverride;
    private LinkedList<T> mSetters;

    public Context(I18NBoundMessage name, boolean override) {
        this.mName = name;
        this.mOverride = override;
        this.mSetters = new LinkedList();
    }

    public Context(boolean override) {
        this(null, override);
    }

    public boolean shouldProcess(Setter<?> setter) {
        return this.getOverride() || !((Holder)setter.getHolder()).isSet();
    }

    public void add(T setter) {
        this.mSetters.add(setter);
    }

    public Iterable<T> getSetters() {
        return this.mSetters;
    }

    public I18NBoundMessage getName() {
        return this.mName;
    }

    public void printUsage(PrintStream stream) {
        if (this.getName() != null) {
            stream.print(this.getName().getText());
        } else {
            stream.print(Messages.CONTEXT_ANONYMOUS.getText());
        }
        if (this.getOverride()) {
            stream.print(' ');
            stream.print(Messages.CONTEXT_OVERRIDES.getText());
        }
        stream.println();
        for (Setter setter : this.getSetters()) {
            stream.print(' ');
            stream.println(setter.getUsage().getText());
        }
    }

    public boolean getOverride() {
        return this.mOverride;
    }

    public abstract void setValues() throws I18NException;
}

