/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.auth;

import java.util.Properties;
import org.marketcetera.util.auth.Context;
import org.marketcetera.util.auth.Messages;
import org.marketcetera.util.auth.SpringSetter;
import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.misc.ClassVersion;
import org.marketcetera.util.spring.SpringUtils;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;
import org.springframework.context.support.GenericApplicationContext;

@ClassVersion(value="$Id: SpringContext.java 16154 2012-07-14 16:34:05Z colin $")
public class SpringContext
extends Context<SpringSetter<?>> {
    private static final String CONFIGURER_BEAN_NAME = SpringContext.class.getName() + ".configurer";
    private String mConfigLocation;
    private String mPropertiesFilesBean;

    public SpringContext(I18NBoundMessage name, boolean override, String configLocation, String propertiesFilesBean) {
        super(name, override);
        this.mConfigLocation = configLocation;
        this.mPropertiesFilesBean = propertiesFilesBean;
    }

    public SpringContext(boolean override, String configLocation, String propertiesFilesBean) {
        this(Messages.SPRING_NAME, override, configLocation, propertiesFilesBean);
    }

    public String getConfigLocation() {
        return this.mConfigLocation;
    }

    public String getPropertiesFilesBean() {
        return this.mPropertiesFilesBean;
    }

    @Override
    public void setValues() {
        GenericApplicationContext context = new GenericApplicationContext((ApplicationContext)new FileSystemXmlApplicationContext(this.getConfigLocation()));
        SpringUtils.addPropertiesConfigurer(context, CONFIGURER_BEAN_NAME, this.getPropertiesFilesBean());
        Properties properties = new Properties();
        int index = 0;
        for (SpringSetter setter : this.getSetters()) {
            if (!this.shouldProcess(setter)) continue;
            setter.setup(context, properties, index++);
        }
        ((PropertyPlaceholderConfigurer)context.getBean(CONFIGURER_BEAN_NAME)).setProperties(properties);
        context.refresh();
        for (SpringSetter setter : this.getSetters()) {
            if (!this.shouldProcess(setter)) continue;
            setter.setValue(context);
        }
    }
}

