/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.auth;

import java.util.Properties;
import org.marketcetera.util.auth.Holder;
import org.marketcetera.util.auth.Setter;
import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.misc.ClassVersion;
import org.marketcetera.util.spring.SpringUtils;
import org.springframework.context.support.GenericApplicationContext;

@ClassVersion(value="$Id: SpringSetter.java 16154 2012-07-14 16:34:05Z colin $")
public abstract class SpringSetter<T extends Holder<?>>
extends Setter<T> {
    private static final String PROPERTY_PROXY_BEAN_NAME_PREFIX = SpringSetter.class.getName() + ".propertyProxy";
    private String mPropertyName;
    private String mBeanName;

    public SpringSetter(T holder, I18NBoundMessage usage, String propertyName) {
        super(holder, usage);
        this.mPropertyName = propertyName;
    }

    public String getPropertyName() {
        return this.mPropertyName;
    }

    public Object getPropertyValue(GenericApplicationContext context) {
        return context.getBean(this.mBeanName);
    }

    public void setup(GenericApplicationContext context, Properties properties, int index) {
        this.mBeanName = PROPERTY_PROXY_BEAN_NAME_PREFIX + index;
        SpringUtils.addStringBean(context, this.mBeanName, "${" + this.getPropertyName() + "}");
        properties.put(this.getPropertyName(), "");
    }

    public abstract void setValue(GenericApplicationContext var1);
}

