/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.auth;

import java.io.PrintStream;
import java.io.Serializable;
import org.marketcetera.util.auth.AuthenticationSystem;
import org.marketcetera.util.auth.CliContext;
import org.marketcetera.util.auth.CliSetterCharArray;
import org.marketcetera.util.auth.CliSetterString;
import org.marketcetera.util.auth.ConsoleContext;
import org.marketcetera.util.auth.ConsoleSetterCharArray;
import org.marketcetera.util.auth.ConsoleSetterString;
import org.marketcetera.util.auth.Holder;
import org.marketcetera.util.auth.HolderCharArray;
import org.marketcetera.util.auth.Messages;
import org.marketcetera.util.auth.SpringContext;
import org.marketcetera.util.auth.SpringSetterCharArray;
import org.marketcetera.util.auth.SpringSetterString;
import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.log.I18NBoundMessage1P;
import org.marketcetera.util.log.I18NBoundMessage2P;
import org.marketcetera.util.misc.ClassVersion;

@ClassVersion(value="$Id: StandardAuthentication.java 16154 2012-07-14 16:34:05Z colin $")
public class StandardAuthentication {
    public static final String PROPERTIES_FILE_BEAN = "propertiesFiles";
    public static final String USER_PROP = "metc.amq.user";
    public static final String PASSWORD_PROP = "metc.amq.password";
    public static final String USER_SHORT = "u";
    public static final String USER_LONG = "user";
    public static final String PASSWORD_SHORT = "p";
    public static final String PASSWORD_LONG = "password";
    private Holder<String> mUserHolder;
    private HolderCharArray mPasswordHolder;
    private AuthenticationSystem mSystem = new AuthenticationSystem();
    private CliContext mCliContext;

    public StandardAuthentication(String configLocation, String propertiesFilesBean, String userPropertyName, String passwordPropertyName, String userShort, String userLong, String passwordShort, String passwordLong, String[] cliArgs) {
        this.mUserHolder = new Holder(Messages.NO_USER);
        this.mPasswordHolder = new HolderCharArray(Messages.NO_PASSWORD);
        SpringContext springContext = new SpringContext(true, configLocation, propertiesFilesBean);
        springContext.add(new SpringSetterString(this.mUserHolder, (I18NBoundMessage)new I18NBoundMessage1P(Messages.USER_SPRING_USAGE, (Serializable)((Object)userPropertyName)), userPropertyName));
        springContext.add(new SpringSetterCharArray(this.mPasswordHolder, (I18NBoundMessage)new I18NBoundMessage1P(Messages.PASSWORD_SPRING_USAGE, (Serializable)((Object)passwordPropertyName)), passwordPropertyName));
        this.mSystem.add(springContext);
        this.mCliContext = new CliContext(true, cliArgs);
        this.mCliContext.add(new CliSetterString(this.mUserHolder, (I18NBoundMessage)new I18NBoundMessage2P(Messages.USER_CLI_USAGE, (Serializable)((Object)userShort), (Serializable)((Object)userLong)), userShort, userLong, (I18NBoundMessage)Messages.USER_DESCRIPTION));
        this.mCliContext.add(new CliSetterCharArray(this.mPasswordHolder, (I18NBoundMessage)new I18NBoundMessage2P(Messages.PASSWORD_CLI_USAGE, (Serializable)((Object)passwordShort), (Serializable)((Object)passwordLong)), passwordShort, passwordLong, (I18NBoundMessage)Messages.PASSWORD_DESCRIPTION));
        this.mSystem.add(this.mCliContext);
        ConsoleContext consoleContext = new ConsoleContext(false);
        consoleContext.add(new ConsoleSetterString(this.mUserHolder, (I18NBoundMessage)Messages.USER_CONSOLE_USAGE, (I18NBoundMessage)Messages.USER_PROMPT));
        consoleContext.add(new ConsoleSetterCharArray(this.mPasswordHolder, (I18NBoundMessage)Messages.PASSWORD_CONSOLE_USAGE, (I18NBoundMessage)Messages.PASSWORD_PROMPT));
        this.mSystem.add(consoleContext);
    }

    public StandardAuthentication(String configLocation, String[] cliArgs) {
        this(configLocation, PROPERTIES_FILE_BEAN, USER_PROP, PASSWORD_PROP, USER_SHORT, USER_LONG, PASSWORD_SHORT, PASSWORD_LONG, cliArgs);
    }

    public boolean setValues() {
        return this.mSystem.setValues();
    }

    public CliContext getCliContext() {
        return this.mCliContext;
    }

    public void printUsage(PrintStream stream) {
        this.mSystem.printUsage(stream);
    }

    public String[] getOtherArgs() {
        return this.mCliContext.getCommandLine().getArgs();
    }

    public String getUser() {
        return this.mUserHolder.getValue();
    }

    public char[] getPassword() {
        return (char[])this.mPasswordHolder.getValue();
    }

    public String getPasswordAsString() {
        return this.mPasswordHolder.getValueAsString();
    }

    public void clearPassword() {
        this.mPasswordHolder.clear();
    }
}

