/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.file;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.marketcetera.util.except.ExceptUtils;
import org.marketcetera.util.except.I18NException;
import org.marketcetera.util.file.CloseableRegistry;
import org.marketcetera.util.file.Messages;
import org.marketcetera.util.file.ReaderWrapper;
import org.marketcetera.util.file.WriterWrapper;
import org.marketcetera.util.log.I18NBoundMessage1P;
import org.marketcetera.util.log.I18NBoundMessage2P;
import org.marketcetera.util.misc.ClassVersion;
import org.marketcetera.util.unicode.DecodingStrategy;
import org.marketcetera.util.unicode.SignatureCharset;
import org.marketcetera.util.unicode.UnicodeInputStreamReader;

@ClassVersion(value="$Id: CopyCharsUnicodeUtils.java 16154 2012-07-14 16:34:05Z colin $")
public final class CopyCharsUnicodeUtils {
    public static long copy(String in, DecodingStrategy decodingStrategy, String out) throws I18NException {
        CloseableRegistry registry = new CloseableRegistry();
        try {
            ReaderWrapper inW = new ReaderWrapper(in, decodingStrategy);
            registry.register(inW);
            Reader reader = inW.getReader();
            SignatureCharset sc = null;
            if (reader instanceof UnicodeInputStreamReader) {
                sc = ((UnicodeInputStreamReader)reader).getSignatureCharset();
            }
            WriterWrapper outW = new WriterWrapper(out, sc);
            registry.register(outW);
            long l = IOUtils.copyLarge((Reader)inW.getReader(), (Writer)outW.getWriter());
            return l;
        }
        catch (IOException ex) {
            throw ExceptUtils.wrap(ex, new I18NBoundMessage2P(Messages.CANNOT_COPY_FILES, (Serializable)((Object)in), (Serializable)((Object)out)));
        }
        finally {
            registry.close();
        }
    }

    public static long copy(Reader in, boolean skipClose, String out) throws I18NException {
        CloseableRegistry registry = new CloseableRegistry();
        try {
            ReaderWrapper inW = new ReaderWrapper(in, skipClose);
            registry.register(inW);
            SignatureCharset sc = null;
            if (in instanceof UnicodeInputStreamReader) {
                sc = ((UnicodeInputStreamReader)in).getSignatureCharset();
            }
            WriterWrapper outW = new WriterWrapper(out, sc);
            registry.register(outW);
            long l = IOUtils.copyLarge((Reader)inW.getReader(), (Writer)outW.getWriter());
            return l;
        }
        catch (IOException ex) {
            throw ExceptUtils.wrap(ex, new I18NBoundMessage1P(Messages.CANNOT_COPY_READER, (Serializable)((Object)out)));
        }
        finally {
            registry.close();
        }
    }

    public static long copy(String in, DecodingStrategy decodingStrategy, Writer out, boolean skipClose) throws I18NException {
        CloseableRegistry registry = new CloseableRegistry();
        try {
            ReaderWrapper inW = new ReaderWrapper(in, decodingStrategy);
            registry.register(inW);
            WriterWrapper outW = new WriterWrapper(out, skipClose);
            registry.register(outW);
            long l = IOUtils.copyLarge((Reader)inW.getReader(), (Writer)outW.getWriter());
            return l;
        }
        catch (IOException ex) {
            throw ExceptUtils.wrap(ex, new I18NBoundMessage1P(Messages.CANNOT_COPY_WRITER, (Serializable)((Object)in)));
        }
        finally {
            registry.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static char[] copy(String name, DecodingStrategy decodingStrategy) throws I18NException {
        char[] cArray;
        ReaderWrapper inW = new ReaderWrapper(name, decodingStrategy);
        try {
            cArray = IOUtils.toCharArray((Reader)inW.getReader());
        }
        catch (Throwable throwable) {
            try {
                inW.close();
                throw throwable;
            }
            catch (IOException ex) {
                throw ExceptUtils.wrap(ex, new I18NBoundMessage1P(Messages.CANNOT_COPY_MEMORY_DST, (Serializable)((Object)name)));
            }
        }
        inW.close();
        return cArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(char[] data, String name, SignatureCharset requestedSignatureCharset) throws I18NException {
        try {
            WriterWrapper outW = new WriterWrapper(name, requestedSignatureCharset);
            try {
                outW.getWriter().write(data);
            }
            finally {
                outW.close();
            }
        }
        catch (IOException ex) {
            throw ExceptUtils.wrap(ex, new I18NBoundMessage1P(Messages.CANNOT_COPY_MEMORY_SRC, (Serializable)((Object)name)));
        }
    }

    private CopyCharsUnicodeUtils() {
    }
}

