/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.misc;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Set;
import org.marketcetera.util.except.ExceptUtils;
import org.marketcetera.util.misc.ClassVersion;

@ClassVersion(value="$Id: ReflectUtils.java 16154 2012-07-14 16:34:05Z colin $")
public final class ReflectUtils {
    private static void getAllClasses(Set<Class<?>> result, Class<?> c) {
        if (c == null) {
            return;
        }
        result.add(c);
        ReflectUtils.getAllClasses(result, c.getSuperclass());
        for (Class<?> i : c.getInterfaces()) {
            ReflectUtils.getAllClasses(result, i);
        }
    }

    public static Class<?>[] getAllClasses(Class<?> c) {
        HashSet result = new HashSet();
        ReflectUtils.getAllClasses(result, c);
        return result.toArray(new Class[0]);
    }

    public static Field[] getAllFields(Class<?> c) {
        HashSet<Field> result = new HashSet<Field>();
        for (Class<?> s : ReflectUtils.getAllClasses(c)) {
            for (Field f : s.getDeclaredFields()) {
                result.add(f);
            }
        }
        return result.toArray(new Field[0]);
    }

    public static Object getInstance(String cName, Class<?>[] paramTypes, Object[] paramValues) throws ClassNotFoundException, IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        try {
            return Class.forName(cName).getConstructor(paramTypes).newInstance(paramValues);
        }
        catch (InvocationTargetException ex) {
            ExceptUtils.interrupt(ex.getCause());
            throw ex;
        }
    }

    private ReflectUtils() {
    }
}

