/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.spring;

import org.marketcetera.util.misc.ClassVersion;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.support.GenericApplicationContext;

@ClassVersion(value="$Id: SpringUtils.java 16154 2012-07-14 16:34:05Z colin $")
public final class SpringUtils {
    public static void addStringBean(GenericApplicationContext context, String name, String value) {
        RootBeanDefinition bean = new RootBeanDefinition(String.class);
        bean.setResourceDescription(SpringUtils.class.getName());
        ConstructorArgumentValues values = new ConstructorArgumentValues();
        values.addGenericArgumentValue((Object)value);
        bean.setConstructorArgumentValues(values);
        context.registerBeanDefinition(name, (BeanDefinition)bean);
    }

    public static void addPropertiesConfigurer(GenericApplicationContext context, String configurerName, String locationRef) {
        RootBeanDefinition bean = new RootBeanDefinition(PropertyPlaceholderConfigurer.class);
        bean.setResourceDescription(SpringUtils.class.getName());
        MutablePropertyValues values = new MutablePropertyValues();
        values.addPropertyValue("locations", (Object)new RuntimeBeanReference(locationRef));
        bean.setPropertyValues(values);
        context.registerBeanDefinition(configurerName, (BeanDefinition)bean);
    }

    private SpringUtils() {
    }
}

