/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.ws.stateful;

import org.marketcetera.util.misc.ClassVersion;
import org.marketcetera.util.ws.stateful.AuthService;
import org.marketcetera.util.ws.stateful.AuthServiceImpl;
import org.marketcetera.util.ws.stateful.Authenticator;
import org.marketcetera.util.ws.stateful.SessionManager;
import org.marketcetera.util.ws.stateless.ServiceInterface;
import org.marketcetera.util.ws.stateless.StatelessServer;

@ClassVersion(value="$Id: Server.java 16154 2012-07-14 16:34:05Z colin $")
public class Server<T>
extends StatelessServer {
    private final Authenticator mAuthenticator;
    private final SessionManager<T> mSessionManager;
    private final ServiceInterface mAuthService;

    public Server(String host, int port, Authenticator authenticator, SessionManager<T> sessionManager) {
        this(host, port, authenticator, sessionManager, (Class[])null);
    }

    public Server(String inHost, int inPort, Authenticator inAuthenticator, SessionManager<T> inSessionManager, Class<?> ... inContextClasses) {
        super(inHost, inPort, inContextClasses);
        this.mAuthenticator = inAuthenticator;
        this.mSessionManager = inSessionManager;
        if (this.getSessionManager() != null) {
            this.getSessionManager().setServerId(this.getId());
        }
        this.mAuthService = this.getAuthenticator() == null ? null : this.publish(new AuthServiceImpl<T>(this.getAuthenticator(), this.getSessionManager()), AuthService.class);
    }

    public Server(Authenticator authenticator, SessionManager<T> sessionManager) {
        this("localhost", 9000, authenticator, sessionManager);
    }

    public Server() {
        this(null, null);
    }

    public Authenticator getAuthenticator() {
        return this.mAuthenticator;
    }

    public SessionManager<T> getSessionManager() {
        return this.mSessionManager;
    }

    private ServiceInterface getAuthService() {
        return this.mAuthService;
    }

    @Override
    public void stop() {
        super.stop();
        if (this.getAuthService() != null) {
            this.getAuthService().stop();
        }
    }
}

