/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.ws.stateless;

import org.marketcetera.util.misc.ClassVersion;
import org.marketcetera.util.ws.tags.NodeId;

@ClassVersion(value="$Id: Node.java 16154 2012-07-14 16:34:05Z colin $")
public class Node {
    public static final int DEFAULT_PORT = 9000;
    public static final String DEFAULT_HOST = "localhost";
    private String mHost;
    private int mPort;
    private final NodeId mId = NodeId.generate();

    protected Node(String host, int port) {
        this.mHost = host;
        this.mPort = port;
    }

    protected Node() {
        this(DEFAULT_HOST, 9000);
    }

    public void setHost(String host) {
        this.mHost = host;
    }

    public String getHost() {
        return this.mHost;
    }

    public int getPort() {
        return this.mPort;
    }

    public NodeId getId() {
        return this.mId;
    }

    protected String getConnectionUrl(Class<?> iface) {
        StringBuilder builder = new StringBuilder();
        builder.append("http://");
        builder.append(this.getHost());
        builder.append(':');
        builder.append(this.getPort());
        builder.append('/');
        builder.append(iface.getName().replace('.', '_').replace('$', '_'));
        return builder.toString();
    }
}

