/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.ws.stateless;

import java.util.Arrays;
import java.util.HashMap;
import org.apache.cxf.jaxws.JaxWsServerFactoryBean;
import org.marketcetera.util.log.SLF4JLoggerProxy;
import org.marketcetera.util.misc.ClassVersion;
import org.marketcetera.util.ws.stateless.Node;
import org.marketcetera.util.ws.stateless.ServiceInterface;
import org.marketcetera.util.ws.stateless.StatelessServiceBase;

@ClassVersion(value="$Id: StatelessServer.java 16154 2012-07-14 16:34:05Z colin $")
public class StatelessServer
extends Node {
    private final Class<?>[] contextClasses;

    public StatelessServer(String inHost, int inPort, Class<?> ... inContextClasses) {
        super(inHost, inPort);
        this.contextClasses = inContextClasses;
    }

    public StatelessServer(String host, int port) {
        this(host, port, null);
    }

    public StatelessServer() {
        this("localhost", 9000);
    }

    public <T extends StatelessServiceBase> ServiceInterface publish(T impl, Class<T> iface) {
        JaxWsServerFactoryBean f = new JaxWsServerFactoryBean();
        HashMap<String, Class<?>[]> props = f.getProperties();
        if (props == null) {
            props = new HashMap<String, Class<?>[]>();
        }
        if (this.contextClasses != null) {
            SLF4JLoggerProxy.debug((Object)this, "Using additional context: {}", Arrays.toString(this.contextClasses));
            props.put("jaxb.additionalContextClasses", this.contextClasses);
        }
        f.setProperties(props);
        f.setServiceClass(iface);
        f.setAddress(this.getConnectionUrl(iface));
        f.setServiceBean(impl);
        return new ServiceInterface(f.create());
    }

    public void stop() {
    }
}

