/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.ws.wrappers;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.commons.lang.ObjectUtils;
import org.marketcetera.util.misc.ClassVersion;
import org.marketcetera.util.ws.wrappers.Messages;
import org.marketcetera.util.ws.wrappers.RemoteProperties;

@ClassVersion(value="$Id: RemoteException.java 16154 2012-07-14 16:34:05Z colin $")
public class RemoteException
extends Exception
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private RemoteProperties mProperties;

    public RemoteException(Throwable t) {
        this();
        if (t == null) {
            return;
        }
        this.setProperties(new RemoteProperties(t));
    }

    public RemoteException() {
        super(Messages.REMOTE_EXCEPTION.getText());
    }

    public void setProperties(RemoteProperties properties) {
        this.mProperties = properties;
        if (properties == null) {
            return;
        }
        this.initCause(this.getProperties().getThrowable());
    }

    public RemoteProperties getProperties() {
        return this.mProperties;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.getProperties());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.setProperties((RemoteProperties)in.readObject());
    }

    public int hashCode() {
        if (this.getCause() == null) {
            return 0;
        }
        return ObjectUtils.hashCode((Object)new RemoteProperties(this.getCause()));
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !this.getClass().equals(other.getClass())) {
            return false;
        }
        RemoteException o = (RemoteException)other;
        if (this.getCause() == null) {
            return o.getCause() == null;
        }
        if (o.getCause() == null) {
            return false;
        }
        return ObjectUtils.equals((Object)new RemoteProperties(this.getCause()), (Object)new RemoteProperties(o.getCause()));
    }
}

