/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.except;

import java.io.Serializable;
import org.junit.Test;
import org.marketcetera.util.except.I18NError;
import org.marketcetera.util.except.I18NRuntimeException;
import org.marketcetera.util.except.I18NThrowable;
import org.marketcetera.util.except.I18NThrowableTestBase;
import org.marketcetera.util.except.TestMessages;
import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.log.I18NBoundMessage1P;

public class I18NRuntimeExceptionTest
extends I18NThrowableTestBase {
    private static final I18NThrowable[] ALL = new I18NThrowable[]{new I18NRuntimeException(), new I18NRuntimeException((Throwable)new ArrayStoreException()), new I18NRuntimeException((Throwable)new ArrayStoreException("Test message 1 (expected)")), new I18NRuntimeException((Throwable)new I18NRuntimeException((I18NBoundMessage)new I18NBoundMessage1P(TestMessages.MID_EXCEPTION, (Serializable)((Object)"a")))), new I18NRuntimeException((I18NBoundMessage)new I18NBoundMessage1P(TestMessages.MID_EXCEPTION, (Serializable)((Object)"a"))), new I18NRuntimeException((Throwable)new ArrayStoreException(), (I18NBoundMessage)new I18NBoundMessage1P(TestMessages.MID_EXCEPTION, (Serializable)((Object)"a"))), new I18NRuntimeException((Throwable)new ArrayStoreException("Test message 2 (expected)"), (I18NBoundMessage)new I18NBoundMessage1P(TestMessages.MID_EXCEPTION, (Serializable)((Object)"a"))), new I18NRuntimeException((Throwable)new I18NRuntimeException((I18NBoundMessage)TestMessages.BOT_EXCEPTION), (I18NBoundMessage)new I18NBoundMessage1P(TestMessages.MID_EXCEPTION, (Serializable)((Object)"a"))), new I18NError(), null};

    @Test
    public void empty() {
        I18NRuntimeExceptionTest.empty(new RuntimeException(), (I18NThrowable)new I18NRuntimeException(), ALL, 0);
    }

    @Test
    public void causeWithoutMessage() {
        ArrayStoreException nested = new ArrayStoreException();
        I18NRuntimeExceptionTest.causeWithoutMessage(nested, new RuntimeException(nested), (I18NThrowable)new I18NRuntimeException((Throwable)nested), ALL, 1);
    }

    @Test
    public void causeWithMessage() {
        ArrayStoreException nested = new ArrayStoreException("Test message 1 (expected)");
        I18NRuntimeExceptionTest.causeWithMessage(nested, new RuntimeException(nested), (I18NThrowable)new I18NRuntimeException((Throwable)nested), ALL, 2);
    }

    @Test
    public void causeWithI18NMessage() {
        I18NRuntimeException nested = new I18NRuntimeException((I18NBoundMessage)new I18NBoundMessage1P(TestMessages.MID_EXCEPTION, (Serializable)((Object)"a")));
        I18NRuntimeExceptionTest.causeWithI18NMessage((I18NThrowable)nested, new RuntimeException((Throwable)nested), (I18NThrowable)new I18NRuntimeException((Throwable)nested), ALL, 3);
    }

    @Test
    public void myMessage() {
        I18NRuntimeExceptionTest.myMessage(new RuntimeException("Test message 1 (expected)"), (I18NThrowable)new I18NRuntimeException((I18NBoundMessage)new I18NBoundMessage1P(TestMessages.MID_EXCEPTION, (Serializable)((Object)"a"))), ALL, 4);
    }

    @Test
    public void myMessageAndCauseWithoutMessage() {
        ArrayStoreException nested = new ArrayStoreException();
        I18NRuntimeExceptionTest.myMessageAndCauseWithoutMessage(nested, new RuntimeException("Test message 1 (expected)", nested), (I18NThrowable)new I18NRuntimeException((Throwable)nested, (I18NBoundMessage)new I18NBoundMessage1P(TestMessages.MID_EXCEPTION, (Serializable)((Object)"a"))), ALL, 5);
    }

    @Test
    public void myMessageAndCauseWithMessage() {
        ArrayStoreException nested = new ArrayStoreException("Test message 2 (expected)");
        I18NRuntimeExceptionTest.myMessageAndCauseWithMessage(nested, new RuntimeException("Test message 1 (expected)", nested), (I18NThrowable)new I18NRuntimeException((Throwable)nested, (I18NBoundMessage)new I18NBoundMessage1P(TestMessages.MID_EXCEPTION, (Serializable)((Object)"a"))), ALL, 6);
    }

    @Test
    public void myMessageAndCauseWithI18NMessage() {
        I18NRuntimeException nested = new I18NRuntimeException((I18NBoundMessage)TestMessages.BOT_EXCEPTION);
        I18NRuntimeExceptionTest.myMessageAndCauseWithI18NMessage((I18NThrowable)nested, new RuntimeException("Test message 1 (expected)", (Throwable)nested), (I18NThrowable)new I18NRuntimeException((Throwable)nested, (I18NBoundMessage)new I18NBoundMessage1P(TestMessages.MID_EXCEPTION, (Serializable)((Object)"a"))), ALL, 7);
    }

    @Test
    public void nesting() {
        I18NRuntimeException exBot = new I18NRuntimeException((I18NBoundMessage)TestMessages.BOT_EXCEPTION);
        I18NRuntimeException exMid = new I18NRuntimeException((Throwable)exBot, (I18NBoundMessage)new I18NBoundMessage1P(TestMessages.MID_EXCEPTION, (Serializable)((Object)"a")));
        I18NRuntimeException exTop = new I18NRuntimeException((Throwable)exMid, (I18NBoundMessage)TestMessages.TOP_EXCEPTION);
        I18NRuntimeExceptionTest.nesting((I18NThrowable)exBot, (I18NThrowable)exMid, (I18NThrowable)exTop);
    }
}

