/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.exec;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Locale;
import org.apache.commons.lang.ArrayUtils;
import org.apache.log4j.Level;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.marketcetera.util.except.I18NException;
import org.marketcetera.util.except.I18NInterruptedException;
import org.marketcetera.util.exec.Disposition;
import org.marketcetera.util.exec.Exec;
import org.marketcetera.util.exec.ExecResult;
import org.marketcetera.util.exec.InputThread;
import org.marketcetera.util.exec.Messages;
import org.marketcetera.util.file.CloseableRegistry;
import org.marketcetera.util.log.ActiveLocale;
import org.marketcetera.util.log.I18NBoundMessage1P;
import org.marketcetera.util.misc.OperatingSystem;
import org.marketcetera.util.test.RegExAssert;
import org.marketcetera.util.test.TestCaseBase;

public class ExecTest
extends TestCaseBase {
    private static final String TEST_CATEGORY = InputThread.class.getName();
    private static final String TEST_OUT = "out";
    private static final String TEST_ERR = "err";
    private static final int TEST_EXIT_CODE = 3;
    private static final byte[] TEST_OUTPUT = "outerr".getBytes();
    private static final String TEST_NONEXISTENT_FILE = DIR_ROOT + File.separator + "nonexistent";
    private static final int SLEEP_DURATION = 1000;

    private static String getJava() {
        if (OperatingSystem.LOCAL.isUnix()) {
            return "java";
        }
        if (OperatingSystem.LOCAL.isWin32()) {
            return "java.exe";
        }
        throw new AssertionError((Object)"Unknown platform");
    }

    private static ExecResult run(File directory, Disposition disposition, String subclass) throws I18NException {
        return Exec.run((File)directory, (Disposition)disposition, (String[])new String[]{ExecTest.getJava(), "-classpath", new File(DIR_TEST_CLASSES).getAbsolutePath() + File.pathSeparator + System.getProperty("java.class.path"), ExecTest.class.getName() + "$" + subclass});
    }

    private static ExecResult run(String directory, Disposition disposition, String subclass) throws I18NException {
        return Exec.run((String)directory, (Disposition)disposition, (String[])new String[]{ExecTest.getJava(), "-classpath", new File(DIR_TEST_CLASSES).getAbsolutePath() + File.pathSeparator + System.getProperty("java.class.path"), ExecTest.class.getName() + "$" + subclass});
    }

    @Before
    public void setupExecTest() {
        ActiveLocale.setProcessLocale((Locale)Locale.ROOT);
        ExecTest.setLevel((String)TEST_CATEGORY, (Level)Level.TRACE);
    }

    @Test
    public void stdOutDisposition() throws Exception {
        Redirector result = Redirector.get(Disposition.STDOUT);
        Assert.assertEquals((long)3L, (long)result.getExitCode());
        Assert.assertArrayEquals((byte[])TEST_OUTPUT, (byte[])result.getStdOut());
        Assert.assertArrayEquals((byte[])ArrayUtils.EMPTY_BYTE_ARRAY, (byte[])result.getStdErr());
        Assert.assertNull((Object)result.getOutput());
    }

    @Test
    public void stdErrDisposition() throws Exception {
        Redirector result = Redirector.get(Disposition.STDERR);
        Assert.assertEquals((long)3L, (long)result.getExitCode());
        Assert.assertArrayEquals((byte[])ArrayUtils.EMPTY_BYTE_ARRAY, (byte[])result.getStdOut());
        Assert.assertArrayEquals((byte[])TEST_OUTPUT, (byte[])result.getStdErr());
        Assert.assertNull((Object)result.getOutput());
    }

    @Test
    public void memoryDisposition() throws Exception {
        Redirector result = Redirector.get(Disposition.MEMORY);
        Assert.assertEquals((long)3L, (long)result.getExitCode());
        Assert.assertArrayEquals((byte[])ArrayUtils.EMPTY_BYTE_ARRAY, (byte[])result.getStdOut());
        Assert.assertArrayEquals((byte[])ArrayUtils.EMPTY_BYTE_ARRAY, (byte[])result.getStdErr());
        Assert.assertArrayEquals((byte[])TEST_OUTPUT, (byte[])result.getOutput());
    }

    @Test
    public void defaultWorkingDirFile() throws Exception {
        ExecResult result = ExecTest.run((File)null, Disposition.MEMORY, "CommandCwd");
        RegExAssert.assertMatches((String)(".*\\" + File.separator + "util"), (String)new String(result.getOutput()));
        Assert.assertEquals((long)0L, (long)result.getExitCode());
    }

    @Test
    public void defaultWorkingDirString() throws Exception {
        ExecResult result = ExecTest.run((String)null, Disposition.MEMORY, "CommandCwd");
        RegExAssert.assertMatches((String)(".*\\" + File.separator + "util"), (String)new String(result.getOutput()));
        Assert.assertEquals((long)0L, (long)result.getExitCode());
    }

    @Test
    public void customWorkingDir() throws Exception {
        ExecResult result = ExecTest.run(DIR_ROOT, Disposition.MEMORY, "CommandCwd");
        Assert.assertEquals((Object)new File(DIR_ROOT).getAbsolutePath(), (Object)new String(result.getOutput()));
        Assert.assertEquals((long)0L, (long)result.getExitCode());
    }

    @Test
    public void nonexistentCommand() {
        try {
            Exec.run((File)null, (Disposition)Disposition.MEMORY, (String[])new String[]{TEST_NONEXISTENT_FILE});
            Assert.fail();
        }
        catch (I18NException ex) {
            Assert.assertFalse((boolean)(ex instanceof I18NInterruptedException));
            Assert.assertEquals((String)ex.getDetail(), (Object)new I18NBoundMessage1P(Messages.CANNOT_EXECUTE, (Serializable)((Object)TEST_NONEXISTENT_FILE)), (Object)ex.getI18NBoundMessage());
        }
    }

    @Test
    public void nonexistentWorkingDir() {
        try {
            ExecTest.run(TEST_NONEXISTENT_FILE, Disposition.MEMORY, DIR_ROOT);
            Assert.fail();
        }
        catch (I18NException ex) {
            Assert.assertFalse((boolean)(ex instanceof I18NInterruptedException));
            Assert.assertEquals((String)ex.getDetail(), (Object)new I18NBoundMessage1P(Messages.CANNOT_EXECUTE, (Serializable)((Object)ExecTest.getJava())), (Object)ex.getI18NBoundMessage());
        }
    }

    @Test
    public void unexpectedTerminationAndProcessKilled() throws Exception {
        ChildExec child = new ChildExec("CommandSleep");
        child.start();
        Thread.sleep(1000L);
        child.interrupt();
        Thread.sleep(1000L);
        I18NException ex = child.getException();
        Assert.assertTrue((boolean)(ex instanceof I18NInterruptedException));
        Assert.assertEquals((String)ex.getDetail(), (Object)new I18NBoundMessage1P(Messages.UNEXPECTED_TERMINATION, (Serializable)((Object)ExecTest.getJava())), (Object)ex.getI18NBoundMessage());
    }

    private static final class Redirector
    extends ExecResult {
        private byte[] mStdOut;
        private byte[] mStdErr;

        Redirector(int exitCode, byte[] stdOut, byte[] stdErr, byte[] memory) {
            super(exitCode, memory);
            this.mStdOut = stdOut;
            this.mStdErr = stdErr;
        }

        byte[] getStdOut() {
            return this.mStdOut;
        }

        byte[] getStdErr() {
            return this.mStdErr;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static Redirector get(Disposition disposition) throws Exception {
            ExecResult result;
            ByteArrayOutputStream stdErrByteArray;
            ByteArrayOutputStream stdOutByteArray;
            PrintStream stdOutSave = System.out;
            PrintStream stdErrSave = System.err;
            CloseableRegistry r = new CloseableRegistry();
            try {
                stdOutByteArray = new ByteArrayOutputStream();
                r.register((Closeable)stdOutByteArray);
                PrintStream stdOutNew = new PrintStream(stdOutByteArray);
                r.register((Closeable)stdOutNew);
                stdErrByteArray = new ByteArrayOutputStream();
                r.register((Closeable)stdErrByteArray);
                PrintStream stdErrNew = new PrintStream(stdErrByteArray);
                r.register((Closeable)stdErrNew);
                System.setOut(stdOutNew);
                System.setErr(stdErrNew);
                result = ExecTest.run(null, disposition, "CommandStreams");
            }
            finally {
                System.setErr(stdErrSave);
                System.setOut(stdOutSave);
                r.close();
            }
            return new Redirector(result.getExitCode(), stdOutByteArray.toByteArray(), stdErrByteArray.toByteArray(), result.getOutput());
        }
    }

    private static final class ChildExec
    extends Thread {
        private String mCommand;
        private I18NException mException;

        ChildExec(String command) {
            this.mCommand = command;
        }

        I18NException getException() {
            return this.mException;
        }

        @Override
        public void run() {
            try {
                ExecTest.run(null, Disposition.MEMORY, this.mCommand);
            }
            catch (I18NException ex) {
                this.mException = ex;
            }
        }
    }

    public static final class CommandSleep {
        public static void main(String[] args) throws Exception {
            for (int i = 0; i < 5; ++i) {
                System.err.println(i);
                Thread.sleep(1000L);
            }
        }
    }

    public static final class CommandCwd {
        public static void main(String[] args) {
            System.out.print(System.getProperty("user.dir"));
        }
    }

    public static final class CommandStreams {
        public static void main(String[] args) {
            System.out.print(ExecTest.TEST_OUT);
            System.err.print(ExecTest.TEST_ERR);
            System.exit(3);
        }
    }
}

