/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.log;

import java.io.Serializable;
import java.util.Locale;
import org.apache.log4j.Level;
import org.junit.Assert;
import org.junit.Test;
import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.log.I18NBoundMessage5P;
import org.marketcetera.util.log.I18NMessage;
import org.marketcetera.util.log.I18NMessage0P;
import org.marketcetera.util.log.I18NMessage5P;
import org.marketcetera.util.log.I18NMessageTestBase;
import org.marketcetera.util.log.TestMessages;

public class TI18NMessage5PTest
extends I18NMessageTestBase {
    private static final String TEST_MSG_EN = "P5 msg (expected) en 1 2 3 4 5";
    private static final String TEST_TTL_EN = "P5 ttl (expected) en 1 2 3 4 5";
    private static final String TEST_MSG_FR = "P5 msg (expected) fr 1 2 3 4 5";
    private static final String TEST_TTL_FR = "P5 ttl (expected) fr 1 2 3 4 5";
    private static final String TEST_LOCATION = TI18NMessage5PTest.class.getName();

    private static void castOverride(I18NMessage5P m) {
    }

    @Test
    public void basic() {
        TI18NMessage5PTest.unboundTests(5, (I18NMessage)new I18NMessage5P(TestMessages.LOGGER, "base", "ttl"), (I18NMessage)new I18NMessage5P(TestMessages.LOGGER, "base", "ttl"), new I18NMessage[]{new I18NMessage5P(TEST_LOGGER_D, "base", "ttl"), new I18NMessage5P(TestMessages.LOGGER, "baseD", "ttl"), new I18NMessage5P(TestMessages.LOGGER, "base", "ttlD"), new I18NMessage0P(TestMessages.LOGGER, "base", "ttl")}, (I18NMessage)new I18NMessage5P(TestMessages.LOGGER, "base"));
    }

    @Test
    public void messageProvider() {
        Assert.assertEquals((Object)TEST_MSG_EN, (Object)TestMessages.P5_MSG.getText((Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
        Assert.assertEquals((Object)TEST_TTL_EN, (Object)TestMessages.P5_TTL.getText((Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
        Assert.assertEquals((Object)TEST_MSG_FR, (Object)TestMessages.P5_MSG.getText(Locale.FRENCH, (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
        Assert.assertEquals((Object)TEST_TTL_FR, (Object)TestMessages.P5_TTL.getText(Locale.FRENCH, (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
    }

    @Test
    public void loggerProxy() {
        TestMessages.P5_MSG.error((Object)"TestCategory", (Throwable)TEST_THROWABLE, (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5");
        this.assertSingleEvent(Level.ERROR, "TestCategory", TEST_MSG_EN, TEST_LOCATION);
        TestMessages.P5_MSG.error((Object)"TestCategory", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5");
        this.assertSingleEvent(Level.ERROR, "TestCategory", TEST_MSG_EN, TEST_LOCATION);
        TestMessages.P5_TTL.error((Object)"TestCategory", (Throwable)TEST_THROWABLE, (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5");
        this.assertSingleEvent(Level.ERROR, "TestCategory", TEST_TTL_EN, TEST_LOCATION);
        TestMessages.P5_TTL.error((Object)"TestCategory", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5");
        this.assertSingleEvent(Level.ERROR, "TestCategory", TEST_TTL_EN, TEST_LOCATION);
        TestMessages.P5_MSG.warn((Object)"TestCategory", (Throwable)TEST_THROWABLE, (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5");
        this.assertSingleEvent(Level.WARN, "TestCategory", TEST_MSG_EN, TEST_LOCATION);
        TestMessages.P5_MSG.warn((Object)"TestCategory", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5");
        this.assertSingleEvent(Level.WARN, "TestCategory", TEST_MSG_EN, TEST_LOCATION);
        TestMessages.P5_TTL.warn((Object)"TestCategory", (Throwable)TEST_THROWABLE, (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5");
        this.assertSingleEvent(Level.WARN, "TestCategory", TEST_TTL_EN, TEST_LOCATION);
        TestMessages.P5_TTL.warn((Object)"TestCategory", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5");
        this.assertSingleEvent(Level.WARN, "TestCategory", TEST_TTL_EN, TEST_LOCATION);
        TestMessages.P5_MSG.info((Object)"TestCategory", (Throwable)TEST_THROWABLE, (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5");
        this.assertSingleEvent(Level.INFO, "TestCategory", TEST_MSG_EN, TEST_LOCATION);
        TestMessages.P5_MSG.info((Object)"TestCategory", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5");
        this.assertSingleEvent(Level.INFO, "TestCategory", TEST_MSG_EN, TEST_LOCATION);
        TestMessages.P5_TTL.info((Object)"TestCategory", (Throwable)TEST_THROWABLE, (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5");
        this.assertSingleEvent(Level.INFO, "TestCategory", TEST_TTL_EN, TEST_LOCATION);
        TestMessages.P5_TTL.info((Object)"TestCategory", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5");
        this.assertSingleEvent(Level.INFO, "TestCategory", TEST_TTL_EN, TEST_LOCATION);
        TestMessages.P5_MSG.debug((Object)"TestCategory", (Throwable)TEST_THROWABLE, (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5");
        this.assertSingleEvent(Level.DEBUG, "TestCategory", TEST_MSG_EN, TEST_LOCATION);
        TestMessages.P5_MSG.debug((Object)"TestCategory", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5");
        this.assertSingleEvent(Level.DEBUG, "TestCategory", TEST_MSG_EN, TEST_LOCATION);
        TestMessages.P5_TTL.debug((Object)"TestCategory", (Throwable)TEST_THROWABLE, (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5");
        this.assertSingleEvent(Level.DEBUG, "TestCategory", TEST_TTL_EN, TEST_LOCATION);
        TestMessages.P5_TTL.debug((Object)"TestCategory", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5");
        this.assertSingleEvent(Level.DEBUG, "TestCategory", TEST_TTL_EN, TEST_LOCATION);
        TestMessages.P5_MSG.trace((Object)"TestCategory", (Throwable)TEST_THROWABLE, (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5");
        this.assertSingleEvent(Level.TRACE, "TestCategory", TEST_MSG_EN, TEST_LOCATION);
        TestMessages.P5_MSG.trace((Object)"TestCategory", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5");
        this.assertSingleEvent(Level.TRACE, "TestCategory", TEST_MSG_EN, TEST_LOCATION);
        TestMessages.P5_TTL.trace((Object)"TestCategory", (Throwable)TEST_THROWABLE, (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5");
        this.assertSingleEvent(Level.TRACE, "TestCategory", TEST_TTL_EN, TEST_LOCATION);
        TestMessages.P5_TTL.trace((Object)"TestCategory", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5");
        this.assertSingleEvent(Level.TRACE, "TestCategory", TEST_TTL_EN, TEST_LOCATION);
    }

    @Test
    public void bound() {
        Serializable[] params = new Serializable[]{"1", "2", "3", "4", "5"};
        I18NBoundMessage5P m = new I18NBoundMessage5P(TestMessages.P5_MSG, (Serializable)((Object)"1"), (Serializable)((Object)"2"), (Serializable)((Object)"3"), (Serializable)((Object)"4"), (Serializable)((Object)"5"));
        this.boundTests((I18NBoundMessage)m, (I18NBoundMessage)new I18NBoundMessage5P(TestMessages.P5_MSG, (Serializable)((Object)"1"), (Serializable)((Object)"2"), (Serializable)((Object)"3"), (Serializable)((Object)"4"), (Serializable)((Object)"5")), new I18NBoundMessage[]{new I18NBoundMessage5P(TestMessages.P5_MSG, (Serializable)((Object)"1"), (Serializable)((Object)"2"), (Serializable)((Object)"3"), (Serializable)((Object)"4"), (Serializable)((Object)"1")), new I18NBoundMessage5P(TestMessages.P5_TTL, (Serializable)((Object)"1"), (Serializable)((Object)"2"), (Serializable)((Object)"3"), (Serializable)((Object)"4"), (Serializable)((Object)"5")), TestMessages.P0_MSG}, params, (I18NMessage)TestMessages.P5_MSG, TEST_MSG_EN, TEST_MSG_FR);
        TI18NMessage5PTest.castOverride((I18NMessage5P)m.getMessage());
        this.boundTests((I18NBoundMessage)new I18NBoundMessage5P(TestMessages.P5_TTL, (Serializable)((Object)"1"), (Serializable)((Object)"2"), (Serializable)((Object)"3"), (Serializable)((Object)"4"), (Serializable)((Object)"5")), (I18NBoundMessage)new I18NBoundMessage5P(TestMessages.P5_TTL, (Serializable)((Object)"1"), (Serializable)((Object)"2"), (Serializable)((Object)"3"), (Serializable)((Object)"4"), (Serializable)((Object)"5")), new I18NBoundMessage[]{new I18NBoundMessage5P(TestMessages.P5_TTL, (Serializable)((Object)"1"), (Serializable)((Object)"2"), (Serializable)((Object)"3"), (Serializable)((Object)"4"), (Serializable)((Object)"1")), new I18NBoundMessage5P(TestMessages.P5_MSG, (Serializable)((Object)"1"), (Serializable)((Object)"2"), (Serializable)((Object)"3"), (Serializable)((Object)"4"), (Serializable)((Object)"5")), TestMessages.P0_TTL}, params, (I18NMessage)TestMessages.P5_TTL, TEST_TTL_EN, TEST_TTL_FR);
        Assert.assertEquals((Object)"1", (Object)m.getParam1());
        Assert.assertEquals((Object)"2", (Object)m.getParam2());
        Assert.assertEquals((Object)"3", (Object)m.getParam3());
        Assert.assertEquals((Object)"4", (Object)m.getParam4());
        Assert.assertEquals((Object)"5", (Object)m.getParam5());
    }
}

