/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.log;

import java.io.Serializable;
import java.util.Locale;
import org.apache.log4j.Level;
import org.junit.Assert;
import org.junit.Test;
import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.log.I18NBoundMessage6P;
import org.marketcetera.util.log.I18NMessage;
import org.marketcetera.util.log.I18NMessage0P;
import org.marketcetera.util.log.I18NMessage6P;
import org.marketcetera.util.log.I18NMessageTestBase;
import org.marketcetera.util.log.TestMessages;

public class TI18NMessage6PTest
extends I18NMessageTestBase {
    private static final String TEST_MSG_EN = "P6 msg (expected) en 1 2 3 4 5 6";
    private static final String TEST_TTL_EN = "P6 ttl (expected) en 1 2 3 4 5 6";
    private static final String TEST_MSG_FR = "P6 msg (expected) fr 1 2 3 4 5 6";
    private static final String TEST_TTL_FR = "P6 ttl (expected) fr 1 2 3 4 5 6";
    private static final String TEST_LOCATION = TI18NMessage6PTest.class.getName();

    private static void castOverride(I18NMessage6P m) {
    }

    @Test
    public void basic() {
        TI18NMessage6PTest.unboundTests(6, (I18NMessage)new I18NMessage6P(TestMessages.LOGGER, "base", "ttl"), (I18NMessage)new I18NMessage6P(TestMessages.LOGGER, "base", "ttl"), new I18NMessage[]{new I18NMessage6P(TEST_LOGGER_D, "base", "ttl"), new I18NMessage6P(TestMessages.LOGGER, "baseD", "ttl"), new I18NMessage6P(TestMessages.LOGGER, "base", "ttlD"), new I18NMessage0P(TestMessages.LOGGER, "base", "ttl")}, (I18NMessage)new I18NMessage6P(TestMessages.LOGGER, "base"));
    }

    @Test
    public void messageProvider() {
        Assert.assertEquals((Object)TEST_MSG_EN, (Object)TestMessages.P6_MSG.getText((Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6"));
        Assert.assertEquals((Object)TEST_TTL_EN, (Object)TestMessages.P6_TTL.getText((Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6"));
        Assert.assertEquals((Object)TEST_MSG_FR, (Object)TestMessages.P6_MSG.getText(Locale.FRENCH, (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6"));
        Assert.assertEquals((Object)TEST_TTL_FR, (Object)TestMessages.P6_TTL.getText(Locale.FRENCH, (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6"));
    }

    @Test
    public void loggerProxy() {
        TestMessages.P6_MSG.error((Object)"TestCategory", (Throwable)TEST_THROWABLE, (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6");
        this.assertSingleEvent(Level.ERROR, "TestCategory", TEST_MSG_EN, TEST_LOCATION);
        TestMessages.P6_MSG.error((Object)"TestCategory", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6");
        this.assertSingleEvent(Level.ERROR, "TestCategory", TEST_MSG_EN, TEST_LOCATION);
        TestMessages.P6_TTL.error((Object)"TestCategory", (Throwable)TEST_THROWABLE, (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6");
        this.assertSingleEvent(Level.ERROR, "TestCategory", TEST_TTL_EN, TEST_LOCATION);
        TestMessages.P6_TTL.error((Object)"TestCategory", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6");
        this.assertSingleEvent(Level.ERROR, "TestCategory", TEST_TTL_EN, TEST_LOCATION);
        TestMessages.P6_MSG.warn((Object)"TestCategory", (Throwable)TEST_THROWABLE, (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6");
        this.assertSingleEvent(Level.WARN, "TestCategory", TEST_MSG_EN, TEST_LOCATION);
        TestMessages.P6_MSG.warn((Object)"TestCategory", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6");
        this.assertSingleEvent(Level.WARN, "TestCategory", TEST_MSG_EN, TEST_LOCATION);
        TestMessages.P6_TTL.warn((Object)"TestCategory", (Throwable)TEST_THROWABLE, (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6");
        this.assertSingleEvent(Level.WARN, "TestCategory", TEST_TTL_EN, TEST_LOCATION);
        TestMessages.P6_TTL.warn((Object)"TestCategory", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6");
        this.assertSingleEvent(Level.WARN, "TestCategory", TEST_TTL_EN, TEST_LOCATION);
        TestMessages.P6_MSG.info((Object)"TestCategory", (Throwable)TEST_THROWABLE, (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6");
        this.assertSingleEvent(Level.INFO, "TestCategory", TEST_MSG_EN, TEST_LOCATION);
        TestMessages.P6_MSG.info((Object)"TestCategory", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6");
        this.assertSingleEvent(Level.INFO, "TestCategory", TEST_MSG_EN, TEST_LOCATION);
        TestMessages.P6_TTL.info((Object)"TestCategory", (Throwable)TEST_THROWABLE, (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6");
        this.assertSingleEvent(Level.INFO, "TestCategory", TEST_TTL_EN, TEST_LOCATION);
        TestMessages.P6_TTL.info((Object)"TestCategory", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6");
        this.assertSingleEvent(Level.INFO, "TestCategory", TEST_TTL_EN, TEST_LOCATION);
        TestMessages.P6_MSG.debug((Object)"TestCategory", (Throwable)TEST_THROWABLE, (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6");
        this.assertSingleEvent(Level.DEBUG, "TestCategory", TEST_MSG_EN, TEST_LOCATION);
        TestMessages.P6_MSG.debug((Object)"TestCategory", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6");
        this.assertSingleEvent(Level.DEBUG, "TestCategory", TEST_MSG_EN, TEST_LOCATION);
        TestMessages.P6_TTL.debug((Object)"TestCategory", (Throwable)TEST_THROWABLE, (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6");
        this.assertSingleEvent(Level.DEBUG, "TestCategory", TEST_TTL_EN, TEST_LOCATION);
        TestMessages.P6_TTL.debug((Object)"TestCategory", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6");
        this.assertSingleEvent(Level.DEBUG, "TestCategory", TEST_TTL_EN, TEST_LOCATION);
        TestMessages.P6_MSG.trace((Object)"TestCategory", (Throwable)TEST_THROWABLE, (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6");
        this.assertSingleEvent(Level.TRACE, "TestCategory", TEST_MSG_EN, TEST_LOCATION);
        TestMessages.P6_MSG.trace((Object)"TestCategory", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6");
        this.assertSingleEvent(Level.TRACE, "TestCategory", TEST_MSG_EN, TEST_LOCATION);
        TestMessages.P6_TTL.trace((Object)"TestCategory", (Throwable)TEST_THROWABLE, (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6");
        this.assertSingleEvent(Level.TRACE, "TestCategory", TEST_TTL_EN, TEST_LOCATION);
        TestMessages.P6_TTL.trace((Object)"TestCategory", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6");
        this.assertSingleEvent(Level.TRACE, "TestCategory", TEST_TTL_EN, TEST_LOCATION);
    }

    @Test
    public void bound() {
        Serializable[] params = new Serializable[]{"1", "2", "3", "4", "5", "6"};
        I18NBoundMessage6P m = new I18NBoundMessage6P(TestMessages.P6_MSG, (Serializable)((Object)"1"), (Serializable)((Object)"2"), (Serializable)((Object)"3"), (Serializable)((Object)"4"), (Serializable)((Object)"5"), (Serializable)((Object)"6"));
        this.boundTests((I18NBoundMessage)m, (I18NBoundMessage)new I18NBoundMessage6P(TestMessages.P6_MSG, (Serializable)((Object)"1"), (Serializable)((Object)"2"), (Serializable)((Object)"3"), (Serializable)((Object)"4"), (Serializable)((Object)"5"), (Serializable)((Object)"6")), new I18NBoundMessage[]{new I18NBoundMessage6P(TestMessages.P6_MSG, (Serializable)((Object)"1"), (Serializable)((Object)"2"), (Serializable)((Object)"3"), (Serializable)((Object)"4"), (Serializable)((Object)"5"), (Serializable)((Object)"1")), new I18NBoundMessage6P(TestMessages.P6_TTL, (Serializable)((Object)"1"), (Serializable)((Object)"2"), (Serializable)((Object)"3"), (Serializable)((Object)"4"), (Serializable)((Object)"5"), (Serializable)((Object)"6")), TestMessages.P0_MSG}, params, (I18NMessage)TestMessages.P6_MSG, TEST_MSG_EN, TEST_MSG_FR);
        TI18NMessage6PTest.castOverride((I18NMessage6P)m.getMessage());
        this.boundTests((I18NBoundMessage)new I18NBoundMessage6P(TestMessages.P6_TTL, (Serializable)((Object)"1"), (Serializable)((Object)"2"), (Serializable)((Object)"3"), (Serializable)((Object)"4"), (Serializable)((Object)"5"), (Serializable)((Object)"6")), (I18NBoundMessage)new I18NBoundMessage6P(TestMessages.P6_TTL, (Serializable)((Object)"1"), (Serializable)((Object)"2"), (Serializable)((Object)"3"), (Serializable)((Object)"4"), (Serializable)((Object)"5"), (Serializable)((Object)"6")), new I18NBoundMessage[]{new I18NBoundMessage6P(TestMessages.P6_TTL, (Serializable)((Object)"1"), (Serializable)((Object)"2"), (Serializable)((Object)"3"), (Serializable)((Object)"4"), (Serializable)((Object)"5"), (Serializable)((Object)"1")), new I18NBoundMessage6P(TestMessages.P6_MSG, (Serializable)((Object)"1"), (Serializable)((Object)"2"), (Serializable)((Object)"3"), (Serializable)((Object)"4"), (Serializable)((Object)"5"), (Serializable)((Object)"6")), TestMessages.P0_TTL}, params, (I18NMessage)TestMessages.P6_TTL, TEST_TTL_EN, TEST_TTL_FR);
        Assert.assertEquals((Object)"1", (Object)m.getParam1());
        Assert.assertEquals((Object)"2", (Object)m.getParam2());
        Assert.assertEquals((Object)"3", (Object)m.getParam3());
        Assert.assertEquals((Object)"4", (Object)m.getParam4());
        Assert.assertEquals((Object)"5", (Object)m.getParam5());
        Assert.assertEquals((Object)"6", (Object)m.getParam6());
    }
}

