/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.log;

import java.io.Serializable;
import java.util.Locale;
import org.apache.log4j.Level;
import org.junit.Assert;
import org.junit.Test;
import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.log.I18NBoundMessageNP;
import org.marketcetera.util.log.I18NMessage;
import org.marketcetera.util.log.I18NMessage0P;
import org.marketcetera.util.log.I18NMessageNP;
import org.marketcetera.util.log.I18NMessageTestBase;
import org.marketcetera.util.log.TestMessages;

public class TI18NMessageNPTest
extends I18NMessageTestBase {
    private static final String TEST_MSG_EN = "PN msg (expected) en 1 2 3 4 5 6 7";
    private static final String TEST_TTL_EN = "PN ttl (expected) en 1 2 3 4 5 6 7";
    private static final String TEST_MSG_FR = "PN msg (expected) fr 1 2 3 4 5 6 7";
    private static final String TEST_TTL_FR = "PN ttl (expected) fr 1 2 3 4 5 6 7";
    private static final String TEST_MSG_MISMATCH_EN = "PN msg (expected) en 1 2 3 4 5 6 {6}";
    private static final String TEST_MSG_EN_NULL = "PN msg (expected) en null null null null null null null";
    private static final String TEST_TTL_EN_NULL = "PN ttl (expected) en null null null null null null null";
    private static final String TEST_MSG_FR_NULL = "PN msg (expected) fr null null null null null null null";
    private static final String TEST_TTL_FR_NULL = "PN ttl (expected) fr null null null null null null null";
    private static final String TEST_MSG_EN_NOSUB = "PN msg (expected) en {0} {1} {2} {3} {4} {5} {6}";
    private static final String TEST_TTL_EN_NOSUB = "PN ttl (expected) en {0} {1} {2} {3} {4} {5} {6}";
    private static final String TEST_MSG_FR_NOSUB = "PN msg (expected) fr {0} {1} {2} {3} {4} {5} {6}";
    private static final String TEST_TTL_FR_NOSUB = "PN ttl (expected) fr {0} {1} {2} {3} {4} {5} {6}";
    private static final String TEST_LOCATION = TI18NMessageNPTest.class.getName();

    private static void castOverride(I18NMessageNP m) {
    }

    @Test
    public void basic() {
        TI18NMessageNPTest.unboundTests(-1, (I18NMessage)new I18NMessageNP(TestMessages.LOGGER, "base", "ttl"), (I18NMessage)new I18NMessageNP(TestMessages.LOGGER, "base", "ttl"), new I18NMessage[]{new I18NMessageNP(TEST_LOGGER_D, "base", "ttl"), new I18NMessageNP(TestMessages.LOGGER, "baseD", "ttl"), new I18NMessageNP(TestMessages.LOGGER, "base", "ttlD"), new I18NMessage0P(TestMessages.LOGGER, "base", "ttl")}, (I18NMessage)new I18NMessageNP(TestMessages.LOGGER, "base"));
    }

    @Test
    public void messageProvider() {
        Assert.assertEquals((Object)TEST_MSG_EN, (Object)TestMessages.PN_MSG.getText(new Object[]{"1", "2", "3", "4", "5", "6", "7"}));
        Assert.assertEquals((Object)TEST_TTL_EN, (Object)TestMessages.PN_TTL.getText(new Object[]{"1", "2", "3", "4", "5", "6", "7"}));
        Assert.assertEquals((Object)TEST_MSG_FR, (Object)TestMessages.PN_MSG.getText(Locale.FRENCH, new Object[]{"1", "2", "3", "4", "5", "6", "7"}));
        Assert.assertEquals((Object)TEST_TTL_FR, (Object)TestMessages.PN_TTL.getText(Locale.FRENCH, new Object[]{"1", "2", "3", "4", "5", "6", "7"}));
    }

    @Test
    public void loggerProxy() {
        TestMessages.PN_MSG.error((Object)"TestCategory", (Throwable)TEST_THROWABLE, new Object[]{"1", "2", "3", "4", "5", "6", "7"});
        this.assertSingleEvent(Level.ERROR, "TestCategory", TEST_MSG_EN, TEST_LOCATION);
        TestMessages.PN_MSG.error((Object)"TestCategory", new Object[]{"1", "2", "3", "4", "5", "6", "7"});
        this.assertSingleEvent(Level.ERROR, "TestCategory", TEST_MSG_EN, TEST_LOCATION);
        TestMessages.PN_TTL.error((Object)"TestCategory", (Throwable)TEST_THROWABLE, new Object[]{"1", "2", "3", "4", "5", "6", "7"});
        this.assertSingleEvent(Level.ERROR, "TestCategory", TEST_TTL_EN, TEST_LOCATION);
        TestMessages.PN_TTL.error((Object)"TestCategory", new Object[]{"1", "2", "3", "4", "5", "6", "7"});
        this.assertSingleEvent(Level.ERROR, "TestCategory", TEST_TTL_EN, TEST_LOCATION);
        TestMessages.PN_MSG.warn((Object)"TestCategory", (Throwable)TEST_THROWABLE, new Object[]{"1", "2", "3", "4", "5", "6", "7"});
        this.assertSingleEvent(Level.WARN, "TestCategory", TEST_MSG_EN, TEST_LOCATION);
        TestMessages.PN_MSG.warn((Object)"TestCategory", new Object[]{"1", "2", "3", "4", "5", "6", "7"});
        this.assertSingleEvent(Level.WARN, "TestCategory", TEST_MSG_EN, TEST_LOCATION);
        TestMessages.PN_TTL.warn((Object)"TestCategory", (Throwable)TEST_THROWABLE, new Object[]{"1", "2", "3", "4", "5", "6", "7"});
        this.assertSingleEvent(Level.WARN, "TestCategory", TEST_TTL_EN, TEST_LOCATION);
        TestMessages.PN_TTL.warn((Object)"TestCategory", new Object[]{"1", "2", "3", "4", "5", "6", "7"});
        this.assertSingleEvent(Level.WARN, "TestCategory", TEST_TTL_EN, TEST_LOCATION);
        TestMessages.PN_MSG.info((Object)"TestCategory", (Throwable)TEST_THROWABLE, new Object[]{"1", "2", "3", "4", "5", "6", "7"});
        this.assertSingleEvent(Level.INFO, "TestCategory", TEST_MSG_EN, TEST_LOCATION);
        TestMessages.PN_MSG.info((Object)"TestCategory", new Object[]{"1", "2", "3", "4", "5", "6", "7"});
        this.assertSingleEvent(Level.INFO, "TestCategory", TEST_MSG_EN, TEST_LOCATION);
        TestMessages.PN_TTL.info((Object)"TestCategory", (Throwable)TEST_THROWABLE, new Object[]{"1", "2", "3", "4", "5", "6", "7"});
        this.assertSingleEvent(Level.INFO, "TestCategory", TEST_TTL_EN, TEST_LOCATION);
        TestMessages.PN_TTL.info((Object)"TestCategory", new Object[]{"1", "2", "3", "4", "5", "6", "7"});
        this.assertSingleEvent(Level.INFO, "TestCategory", TEST_TTL_EN, TEST_LOCATION);
        TestMessages.PN_MSG.debug((Object)"TestCategory", (Throwable)TEST_THROWABLE, new Object[]{"1", "2", "3", "4", "5", "6", "7"});
        this.assertSingleEvent(Level.DEBUG, "TestCategory", TEST_MSG_EN, TEST_LOCATION);
        TestMessages.PN_MSG.debug((Object)"TestCategory", new Object[]{"1", "2", "3", "4", "5", "6", "7"});
        this.assertSingleEvent(Level.DEBUG, "TestCategory", TEST_MSG_EN, TEST_LOCATION);
        TestMessages.PN_TTL.debug((Object)"TestCategory", (Throwable)TEST_THROWABLE, new Object[]{"1", "2", "3", "4", "5", "6", "7"});
        this.assertSingleEvent(Level.DEBUG, "TestCategory", TEST_TTL_EN, TEST_LOCATION);
        TestMessages.PN_TTL.debug((Object)"TestCategory", new Object[]{"1", "2", "3", "4", "5", "6", "7"});
        this.assertSingleEvent(Level.DEBUG, "TestCategory", TEST_TTL_EN, TEST_LOCATION);
        TestMessages.PN_MSG.trace((Object)"TestCategory", (Throwable)TEST_THROWABLE, new Object[]{"1", "2", "3", "4", "5", "6", "7"});
        this.assertSingleEvent(Level.TRACE, "TestCategory", TEST_MSG_EN, TEST_LOCATION);
        TestMessages.PN_MSG.trace((Object)"TestCategory", new Object[]{"1", "2", "3", "4", "5", "6", "7"});
        this.assertSingleEvent(Level.TRACE, "TestCategory", TEST_MSG_EN, TEST_LOCATION);
        TestMessages.PN_TTL.trace((Object)"TestCategory", (Throwable)TEST_THROWABLE, new Object[]{"1", "2", "3", "4", "5", "6", "7"});
        this.assertSingleEvent(Level.TRACE, "TestCategory", TEST_TTL_EN, TEST_LOCATION);
        TestMessages.PN_TTL.trace((Object)"TestCategory", new Object[]{"1", "2", "3", "4", "5", "6", "7"});
        this.assertSingleEvent(Level.TRACE, "TestCategory", TEST_TTL_EN, TEST_LOCATION);
    }

    @Test
    public void countMismatch() {
        TestMessages.PN_MSG.error((Object)"TestCategory", (Throwable)TEST_THROWABLE, new Object[]{"1", "2", "3", "4", "5", "6"});
        this.assertSingleEvent(Level.ERROR, "TestCategory", TEST_MSG_MISMATCH_EN, TEST_LOCATION);
        TestMessages.PN_MSG.error((Object)"TestCategory", new Object[]{"1", "2", "3", "4", "5", "6"});
        this.assertSingleEvent(Level.ERROR, "TestCategory", TEST_MSG_MISMATCH_EN, TEST_LOCATION);
        TestMessages.PN_MSG.error((Object)"TestCategory", (Throwable)TEST_THROWABLE, new Object[]{"1", "2", "3", "4", "5", "6", "7", "7"});
        this.assertSingleEvent(Level.ERROR, "TestCategory", TEST_MSG_EN, TEST_LOCATION);
        TestMessages.PN_MSG.error((Object)"TestCategory", new Object[]{"1", "2", "3", "4", "5", "6", "7", "7"});
        this.assertSingleEvent(Level.ERROR, "TestCategory", TEST_MSG_EN, TEST_LOCATION);
    }

    @Test
    public void bound() {
        Serializable[] params = new Serializable[]{"1", "2", "3", "4", "5", "6", "7"};
        I18NBoundMessageNP m = new I18NBoundMessageNP(TestMessages.PN_MSG, new Serializable[]{"1", "2", "3", "4", "5", "6", "7"});
        this.boundTests((I18NBoundMessage)m, (I18NBoundMessage)new I18NBoundMessageNP(TestMessages.PN_MSG, new Serializable[]{"1", "2", "3", "4", "5", "6", "7"}), new I18NBoundMessage[]{new I18NBoundMessageNP(TestMessages.PN_MSG, new Serializable[]{"1", "2", "3", "4", "5", "6", "1"}), new I18NBoundMessageNP(TestMessages.PN_MSG, new Serializable[]{"1", "2", "3", "4", "5", "6"}), new I18NBoundMessageNP(TestMessages.PN_MSG, new Serializable[]{"1", "2", "3", "4", "5", "6", "7", "1"}), new I18NBoundMessageNP(TestMessages.PN_TTL, new Serializable[]{"1", "2", "3", "4", "5", "6", "7"}), TestMessages.P0_MSG}, params, (I18NMessage)TestMessages.PN_MSG, TEST_MSG_EN, TEST_MSG_FR);
        TI18NMessageNPTest.castOverride((I18NMessageNP)m.getMessage());
        this.boundTests((I18NBoundMessage)new I18NBoundMessageNP(TestMessages.PN_TTL, new Serializable[]{"1", "2", "3", "4", "5", "6", "7"}), (I18NBoundMessage)new I18NBoundMessageNP(TestMessages.PN_TTL, new Serializable[]{"1", "2", "3", "4", "5", "6", "7"}), new I18NBoundMessage[]{new I18NBoundMessageNP(TestMessages.PN_TTL, new Serializable[]{"1", "2", "3", "4", "5", "6", "1"}), new I18NBoundMessageNP(TestMessages.PN_TTL, new Serializable[]{"1", "2", "3", "4", "5", "6"}), new I18NBoundMessageNP(TestMessages.PN_TTL, new Serializable[]{"1", "2", "3", "4", "5", "6", "7", "1"}), new I18NBoundMessageNP(TestMessages.PN_MSG, new Serializable[]{"1", "2", "3", "4", "5", "6", "7"}), TestMessages.P0_TTL}, params, (I18NMessage)TestMessages.PN_TTL, TEST_TTL_EN, TEST_TTL_FR);
        params = new Serializable[]{null, null, null, null, null, null, null};
        this.boundTests((I18NBoundMessage)new I18NBoundMessageNP(TestMessages.PN_MSG, new Serializable[]{null, null, null, null, null, null, null}), (I18NBoundMessage)new I18NBoundMessageNP(TestMessages.PN_MSG, new Serializable[]{null, null, null, null, null, null, null}), new I18NBoundMessage[]{new I18NBoundMessageNP(TestMessages.PN_MSG, new Serializable[]{null, null, null, null, null, null, "1"}), new I18NBoundMessageNP(TestMessages.PN_MSG, new Serializable[]{null, null, null, null, null, null}), new I18NBoundMessageNP(TestMessages.PN_MSG, new Serializable[]{null, null, null, null, null, null, null, "1"}), new I18NBoundMessageNP(TestMessages.PN_TTL, new Serializable[]{null, null, null, null, null, null, null}), TestMessages.P0_MSG}, params, (I18NMessage)TestMessages.PN_MSG, TEST_MSG_EN_NULL, TEST_MSG_FR_NULL);
        this.boundTests((I18NBoundMessage)new I18NBoundMessageNP(TestMessages.PN_TTL, new Serializable[]{null, null, null, null, null, null, null}), (I18NBoundMessage)new I18NBoundMessageNP(TestMessages.PN_TTL, new Serializable[]{null, null, null, null, null, null, null}), new I18NBoundMessage[]{new I18NBoundMessageNP(TestMessages.PN_TTL, new Serializable[]{null, null, null, null, null, null, "1"}), new I18NBoundMessageNP(TestMessages.PN_TTL, new Serializable[]{null, null, null, null, null, null}), new I18NBoundMessageNP(TestMessages.PN_TTL, new Serializable[]{null, null, null, null, null, null, null, "1"}), new I18NBoundMessageNP(TestMessages.PN_MSG, new Serializable[]{null, null, null, null, null, null, null}), TestMessages.P0_TTL}, params, (I18NMessage)TestMessages.PN_TTL, TEST_TTL_EN_NULL, TEST_TTL_FR_NULL);
        this.boundTests((I18NBoundMessage)new I18NBoundMessageNP(TestMessages.PN_MSG, (Serializable[])null), (I18NBoundMessage)new I18NBoundMessageNP(TestMessages.PN_MSG, I18NBoundMessage.EMPTY_PARAMS), new I18NBoundMessage[]{new I18NBoundMessageNP(TestMessages.PN_MSG, new Serializable[]{"1"}), new I18NBoundMessageNP(TestMessages.PN_TTL, (Serializable[])null), TestMessages.P0_MSG}, I18NBoundMessage.EMPTY_PARAMS, (I18NMessage)TestMessages.PN_MSG, TEST_MSG_EN_NOSUB, TEST_MSG_FR_NOSUB);
        this.boundTests((I18NBoundMessage)new I18NBoundMessageNP(TestMessages.PN_TTL, (Serializable[])null), (I18NBoundMessage)new I18NBoundMessageNP(TestMessages.PN_TTL, I18NBoundMessage.EMPTY_PARAMS), new I18NBoundMessage[]{new I18NBoundMessageNP(TestMessages.PN_TTL, new Serializable[]{"1"}), new I18NBoundMessageNP(TestMessages.PN_MSG, (Serializable[])null), TestMessages.P0_TTL}, I18NBoundMessage.EMPTY_PARAMS, (I18NMessage)TestMessages.PN_TTL, TEST_TTL_EN_NOSUB, TEST_TTL_FR_NOSUB);
    }
}

