/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.log;

import org.apache.log4j.Level;
import org.junit.Assert;
import org.junit.Test;
import org.marketcetera.util.log.SLF4JLoggerProxy;
import org.marketcetera.util.test.TestCaseBase;

public class TSLF4JLoggerProxyTest
extends TestCaseBase {
    private static final String TEST_CATEGORY = "TestCategory";
    private static final String TEST_MESSAGE = "Test message (expected)";
    private static final Exception TEST_THROWABLE = new IllegalArgumentException("Test exception (expected)");
    private static final String TEST_LOCATION = TSLF4JLoggerProxyTest.class.getName();

    @Test
    public void categories() {
        TSLF4JLoggerProxyTest.setLevel((String)TEST_CATEGORY, (Level)Level.ERROR);
        SLF4JLoggerProxy.error(null, (String)TEST_MESSAGE);
        this.assertSingleEvent(Level.ERROR, "UNKNOWN", TEST_MESSAGE, TEST_LOCATION);
        SLF4JLoggerProxy.error((Object)TEST_CATEGORY, (String)TEST_MESSAGE);
        this.assertSingleEvent(Level.ERROR, TEST_CATEGORY, TEST_MESSAGE, TEST_LOCATION);
        SLF4JLoggerProxy.error(((Object)((Object)this)).getClass(), (String)TEST_MESSAGE);
        this.assertSingleEvent(Level.ERROR, ((Object)((Object)this)).getClass().getName(), TEST_MESSAGE, TEST_LOCATION);
        SLF4JLoggerProxy.error((Object)((Object)this), (String)TEST_MESSAGE);
        this.assertSingleEvent(Level.ERROR, ((Object)((Object)this)).getClass().getName(), TEST_MESSAGE, TEST_LOCATION);
    }

    @Test
    public void messages() {
        TSLF4JLoggerProxyTest.setLevel((String)TEST_CATEGORY, (Level)Level.OFF);
        Assert.assertFalse((boolean)SLF4JLoggerProxy.isErrorEnabled((Object)TEST_CATEGORY));
        SLF4JLoggerProxy.error((Object)TEST_CATEGORY, (String)TEST_MESSAGE);
        SLF4JLoggerProxy.error((Object)TEST_CATEGORY, (Throwable)TEST_THROWABLE);
        SLF4JLoggerProxy.error((Object)TEST_CATEGORY, (String)TEST_MESSAGE, (Throwable)TEST_THROWABLE);
        SLF4JLoggerProxy.error((Object)TEST_CATEGORY, (String)"Test message (expected) {} {}", (Object[])new Object[]{"a"});
        SLF4JLoggerProxy.error((Object)TEST_CATEGORY, (Throwable)TEST_THROWABLE, (String)"Test message (expected) {}", (Object[])new Object[]{"a"});
        this.assertNoEvents();
        TSLF4JLoggerProxyTest.setLevel((String)TEST_CATEGORY, (Level)Level.ERROR);
        Assert.assertTrue((boolean)SLF4JLoggerProxy.isErrorEnabled((Object)TEST_CATEGORY));
        SLF4JLoggerProxy.error((Object)TEST_CATEGORY, (String)TEST_MESSAGE);
        this.assertSingleEvent(Level.ERROR, TEST_CATEGORY, TEST_MESSAGE, TEST_LOCATION);
        SLF4JLoggerProxy.error((Object)TEST_CATEGORY, (Throwable)TEST_THROWABLE);
        this.assertSingleEvent(Level.ERROR, TEST_CATEGORY, "Unknown Message", TEST_LOCATION);
        SLF4JLoggerProxy.error((Object)TEST_CATEGORY, (String)TEST_MESSAGE, (Throwable)TEST_THROWABLE);
        this.assertSingleEvent(Level.ERROR, TEST_CATEGORY, TEST_MESSAGE, TEST_LOCATION);
        SLF4JLoggerProxy.error((Object)TEST_CATEGORY, (String)"Test message (expected) {} {}", (Object[])new Object[]{"a"});
        this.assertSingleEvent(Level.ERROR, TEST_CATEGORY, "Test message (expected) a {}", TEST_LOCATION);
        SLF4JLoggerProxy.error((Object)TEST_CATEGORY, (String)TEST_MESSAGE, (Object[])new Object[]{"a"});
        this.assertSingleEvent(Level.ERROR, TEST_CATEGORY, TEST_MESSAGE, TEST_LOCATION);
        SLF4JLoggerProxy.error((Object)TEST_CATEGORY, (Throwable)TEST_THROWABLE, (String)"Test message (expected) {}", (Object[])new Object[]{"a"});
        this.assertSingleEvent(Level.ERROR, TEST_CATEGORY, "Test message (expected) a", TEST_LOCATION);
        this.getAppender().clear();
        Assert.assertFalse((boolean)SLF4JLoggerProxy.isWarnEnabled((Object)TEST_CATEGORY));
        SLF4JLoggerProxy.warn((Object)TEST_CATEGORY, (String)TEST_MESSAGE);
        SLF4JLoggerProxy.warn((Object)TEST_CATEGORY, (Throwable)TEST_THROWABLE);
        SLF4JLoggerProxy.warn((Object)TEST_CATEGORY, (String)TEST_MESSAGE, (Throwable)TEST_THROWABLE);
        SLF4JLoggerProxy.warn((Object)TEST_CATEGORY, (String)"Test message (expected) {} {}", (Object[])new Object[]{"a"});
        SLF4JLoggerProxy.warn((Object)TEST_CATEGORY, (Throwable)TEST_THROWABLE, (String)"Test message (expected) {}", (Object[])new Object[]{"a"});
        this.assertNoEvents();
        TSLF4JLoggerProxyTest.setLevel((String)TEST_CATEGORY, (Level)Level.WARN);
        Assert.assertTrue((boolean)SLF4JLoggerProxy.isWarnEnabled((Object)TEST_CATEGORY));
        SLF4JLoggerProxy.warn((Object)TEST_CATEGORY, (String)TEST_MESSAGE);
        this.assertSingleEvent(Level.WARN, TEST_CATEGORY, TEST_MESSAGE, TEST_LOCATION);
        SLF4JLoggerProxy.warn((Object)TEST_CATEGORY, (Throwable)TEST_THROWABLE);
        this.assertSingleEvent(Level.WARN, TEST_CATEGORY, "Unknown Message", TEST_LOCATION);
        SLF4JLoggerProxy.warn((Object)TEST_CATEGORY, (String)TEST_MESSAGE, (Throwable)TEST_THROWABLE);
        this.assertSingleEvent(Level.WARN, TEST_CATEGORY, TEST_MESSAGE, TEST_LOCATION);
        SLF4JLoggerProxy.warn((Object)TEST_CATEGORY, (String)"Test message (expected) {} {}", (Object[])new Object[]{"a"});
        this.assertSingleEvent(Level.WARN, TEST_CATEGORY, "Test message (expected) a {}", TEST_LOCATION);
        SLF4JLoggerProxy.warn((Object)TEST_CATEGORY, (String)TEST_MESSAGE, (Object[])new Object[]{"a"});
        this.assertSingleEvent(Level.WARN, TEST_CATEGORY, TEST_MESSAGE, TEST_LOCATION);
        SLF4JLoggerProxy.warn((Object)TEST_CATEGORY, (Throwable)TEST_THROWABLE, (String)"Test message (expected) {}", (Object[])new Object[]{"a"});
        this.assertSingleEvent(Level.WARN, TEST_CATEGORY, "Test message (expected) a", TEST_LOCATION);
        this.getAppender().clear();
        Assert.assertFalse((boolean)SLF4JLoggerProxy.isInfoEnabled((Object)TEST_CATEGORY));
        SLF4JLoggerProxy.info((Object)TEST_CATEGORY, (String)TEST_MESSAGE);
        SLF4JLoggerProxy.info((Object)TEST_CATEGORY, (Throwable)TEST_THROWABLE);
        SLF4JLoggerProxy.info((Object)TEST_CATEGORY, (String)TEST_MESSAGE, (Throwable)TEST_THROWABLE);
        SLF4JLoggerProxy.info((Object)TEST_CATEGORY, (String)"Test message (expected) {} {}", (Object[])new Object[]{"a"});
        SLF4JLoggerProxy.info((Object)TEST_CATEGORY, (Throwable)TEST_THROWABLE, (String)"Test message (expected) {}", (Object[])new Object[]{"a"});
        this.assertNoEvents();
        TSLF4JLoggerProxyTest.setLevel((String)TEST_CATEGORY, (Level)Level.INFO);
        Assert.assertTrue((boolean)SLF4JLoggerProxy.isInfoEnabled((Object)TEST_CATEGORY));
        SLF4JLoggerProxy.info((Object)TEST_CATEGORY, (String)TEST_MESSAGE);
        this.assertSingleEvent(Level.INFO, TEST_CATEGORY, TEST_MESSAGE, TEST_LOCATION);
        SLF4JLoggerProxy.info((Object)TEST_CATEGORY, (Throwable)TEST_THROWABLE);
        this.assertSingleEvent(Level.INFO, TEST_CATEGORY, "Unknown Message", TEST_LOCATION);
        SLF4JLoggerProxy.info((Object)TEST_CATEGORY, (String)TEST_MESSAGE, (Throwable)TEST_THROWABLE);
        this.assertSingleEvent(Level.INFO, TEST_CATEGORY, TEST_MESSAGE, TEST_LOCATION);
        SLF4JLoggerProxy.info((Object)TEST_CATEGORY, (String)"Test message (expected) {} {}", (Object[])new Object[]{"a"});
        this.assertSingleEvent(Level.INFO, TEST_CATEGORY, "Test message (expected) a {}", TEST_LOCATION);
        SLF4JLoggerProxy.info((Object)TEST_CATEGORY, (String)TEST_MESSAGE, (Object[])new Object[]{"a"});
        this.assertSingleEvent(Level.INFO, TEST_CATEGORY, TEST_MESSAGE, TEST_LOCATION);
        SLF4JLoggerProxy.info((Object)TEST_CATEGORY, (Throwable)TEST_THROWABLE, (String)"Test message (expected) {}", (Object[])new Object[]{"a"});
        this.assertSingleEvent(Level.INFO, TEST_CATEGORY, "Test message (expected) a", TEST_LOCATION);
        this.getAppender().clear();
        Assert.assertFalse((boolean)SLF4JLoggerProxy.isDebugEnabled((Object)TEST_CATEGORY));
        SLF4JLoggerProxy.debug((Object)TEST_CATEGORY, (String)TEST_MESSAGE);
        SLF4JLoggerProxy.debug((Object)TEST_CATEGORY, (Throwable)TEST_THROWABLE);
        SLF4JLoggerProxy.debug((Object)TEST_CATEGORY, (String)TEST_MESSAGE, (Throwable)TEST_THROWABLE);
        SLF4JLoggerProxy.debug((Object)TEST_CATEGORY, (String)"Test message (expected) {} {}", (Object[])new Object[]{"a"});
        SLF4JLoggerProxy.debug((Object)TEST_CATEGORY, (Throwable)TEST_THROWABLE, (String)"Test message (expected) {}", (Object[])new Object[]{"a"});
        this.assertNoEvents();
        TSLF4JLoggerProxyTest.setLevel((String)TEST_CATEGORY, (Level)Level.DEBUG);
        Assert.assertTrue((boolean)SLF4JLoggerProxy.isDebugEnabled((Object)TEST_CATEGORY));
        SLF4JLoggerProxy.debug((Object)TEST_CATEGORY, (String)TEST_MESSAGE);
        this.assertSingleEvent(Level.DEBUG, TEST_CATEGORY, TEST_MESSAGE, TEST_LOCATION);
        SLF4JLoggerProxy.debug((Object)TEST_CATEGORY, (Throwable)TEST_THROWABLE);
        this.assertSingleEvent(Level.DEBUG, TEST_CATEGORY, "Unknown Message", TEST_LOCATION);
        SLF4JLoggerProxy.debug((Object)TEST_CATEGORY, (String)TEST_MESSAGE, (Throwable)TEST_THROWABLE);
        this.assertSingleEvent(Level.DEBUG, TEST_CATEGORY, TEST_MESSAGE, TEST_LOCATION);
        SLF4JLoggerProxy.debug((Object)TEST_CATEGORY, (String)"Test message (expected) {} {}", (Object[])new Object[]{"a"});
        this.assertSingleEvent(Level.DEBUG, TEST_CATEGORY, "Test message (expected) a {}", TEST_LOCATION);
        SLF4JLoggerProxy.debug((Object)TEST_CATEGORY, (String)TEST_MESSAGE, (Object[])new Object[]{"a"});
        this.assertSingleEvent(Level.DEBUG, TEST_CATEGORY, TEST_MESSAGE, TEST_LOCATION);
        SLF4JLoggerProxy.debug((Object)TEST_CATEGORY, (Throwable)TEST_THROWABLE, (String)"Test message (expected) {}", (Object[])new Object[]{"a"});
        this.assertSingleEvent(Level.DEBUG, TEST_CATEGORY, "Test message (expected) a", TEST_LOCATION);
        this.getAppender().clear();
        Assert.assertFalse((boolean)SLF4JLoggerProxy.isTraceEnabled((Object)TEST_CATEGORY));
        SLF4JLoggerProxy.trace((Object)TEST_CATEGORY, (String)TEST_MESSAGE);
        SLF4JLoggerProxy.trace((Object)TEST_CATEGORY, (Throwable)TEST_THROWABLE);
        SLF4JLoggerProxy.trace((Object)TEST_CATEGORY, (String)TEST_MESSAGE, (Throwable)TEST_THROWABLE);
        SLF4JLoggerProxy.trace((Object)TEST_CATEGORY, (String)"Test message (expected) {} {}", (Object[])new Object[]{"a"});
        SLF4JLoggerProxy.trace((Object)TEST_CATEGORY, (Throwable)TEST_THROWABLE, (String)"Test message (expected) {}", (Object[])new Object[]{"a"});
        this.assertNoEvents();
        TSLF4JLoggerProxyTest.setLevel((String)TEST_CATEGORY, (Level)Level.TRACE);
        Assert.assertTrue((boolean)SLF4JLoggerProxy.isTraceEnabled((Object)TEST_CATEGORY));
        SLF4JLoggerProxy.trace((Object)TEST_CATEGORY, (String)TEST_MESSAGE);
        this.assertSingleEvent(Level.TRACE, TEST_CATEGORY, TEST_MESSAGE, TEST_LOCATION);
        SLF4JLoggerProxy.trace((Object)TEST_CATEGORY, (Throwable)TEST_THROWABLE);
        this.assertSingleEvent(Level.TRACE, TEST_CATEGORY, "Unknown Message", TEST_LOCATION);
        SLF4JLoggerProxy.trace((Object)TEST_CATEGORY, (String)TEST_MESSAGE, (Throwable)TEST_THROWABLE);
        this.assertSingleEvent(Level.TRACE, TEST_CATEGORY, TEST_MESSAGE, TEST_LOCATION);
        SLF4JLoggerProxy.trace((Object)TEST_CATEGORY, (String)"Test message (expected) {} {}", (Object[])new Object[]{"a"});
        this.assertSingleEvent(Level.TRACE, TEST_CATEGORY, "Test message (expected) a {}", TEST_LOCATION);
        SLF4JLoggerProxy.trace((Object)TEST_CATEGORY, (String)TEST_MESSAGE, (Object[])new Object[]{"a"});
        this.assertSingleEvent(Level.TRACE, TEST_CATEGORY, TEST_MESSAGE, TEST_LOCATION);
        SLF4JLoggerProxy.trace((Object)TEST_CATEGORY, (Throwable)TEST_THROWABLE, (String)"Test message (expected) {}", (Object[])new Object[]{"a"});
        this.assertSingleEvent(Level.TRACE, TEST_CATEGORY, "Test message (expected) a", TEST_LOCATION);
        this.getAppender().clear();
    }
}

