/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.misc;

import org.junit.Assert;
import org.junit.Test;
import org.marketcetera.util.misc.OperatingSystem;
import org.marketcetera.util.test.TestCaseBase;

public class OperatingSystemTest
extends TestCaseBase {
    private static void single(OperatingSystem os, boolean isWin32, boolean isUnix, String string) {
        Assert.assertEquals((Object)os, (Object)OperatingSystem.get((String)os.getJavaName()));
        Assert.assertEquals((Object)isWin32, (Object)os.isWin32());
        Assert.assertEquals((Object)isUnix, (Object)os.isUnix());
        Assert.assertEquals((Object)string, (Object)os.toString());
    }

    @Test
    public void all() {
        OperatingSystemTest.single(OperatingSystem.WINDOWS_2000, true, false, "WINDOWS_2000,Windows 2000,win32");
        OperatingSystemTest.single(OperatingSystem.WINDOWS_2003, true, false, "WINDOWS_2003,Windows 2003,win32");
        OperatingSystemTest.single(OperatingSystem.WINDOWS_XP, true, false, "WINDOWS_XP,Windows XP,win32");
        OperatingSystemTest.single(OperatingSystem.WINDOWS_CE, true, false, "WINDOWS_CE,Windows CE,win32");
        OperatingSystemTest.single(OperatingSystem.WINDOWS_VISTA, true, false, "WINDOWS_VISTA,Windows Vista,win32");
        OperatingSystemTest.single(OperatingSystem.WINDOWS_7, true, false, "WINDOWS_7,Windows 7,win32");
        OperatingSystemTest.single(OperatingSystem.DARWIN, false, true, "DARWIN,Darwin,unix");
        OperatingSystemTest.single(OperatingSystem.MAC_OS_X, false, true, "MAC_OS_X,Mac OS X,unix");
        OperatingSystemTest.single(OperatingSystem.FREEBSD, false, true, "FREEBSD,FreeBSD,unix");
        OperatingSystemTest.single(OperatingSystem.LINUX, false, true, "LINUX,Linux,unix");
        OperatingSystemTest.single(OperatingSystem.SOLARIS, false, true, "SOLARIS,SunOS,unix");
        OperatingSystemTest.single(OperatingSystem.AIX, false, true, "AIX,AIX,unix");
        OperatingSystemTest.single(OperatingSystem.HPUX, false, true, "HPUX,HP-UX,unix");
        OperatingSystemTest.single(OperatingSystem.UNKNOWN, false, false, "UNKNOWN");
        Assert.assertEquals((Object)OperatingSystem.UNKNOWN, (Object)OperatingSystem.get((String)"nonexistent"));
        Assert.assertEquals((Object)OperatingSystem.UNKNOWN, (Object)OperatingSystem.get(null));
    }

    @Test
    public void runningOnKnownOpearatingSystem() {
        Assert.assertNotSame((Object)OperatingSystem.UNKNOWN, (Object)OperatingSystem.LOCAL);
    }
}

