/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.unicode;

import java.io.Reader;
import org.apache.commons.lang.ArrayUtils;
import org.junit.Assert;
import org.marketcetera.util.file.CopyBytesUtils;
import org.marketcetera.util.file.Deleter;
import org.marketcetera.util.unicode.FileEncoderTestBase;
import org.marketcetera.util.unicode.IOTestBase;
import org.marketcetera.util.unicode.SignatureCharset;
import org.marketcetera.util.unicode.UnicodeFileWriter;

public class FileEncoderStringTest
extends FileEncoderTestBase {
    @Override
    protected byte[] encode(String string) throws Exception {
        return this.encode(new FileEncoderTestBase.WriterCreator(){

            @Override
            public UnicodeFileWriter create() throws Exception {
                return new UnicodeFileWriter(IOTestBase.TEST_FILE);
            }
        }, null, null, string);
    }

    @Override
    protected byte[] encode(final SignatureCharset sc, String string) throws Exception {
        return this.encode(new FileEncoderTestBase.WriterCreator(){

            @Override
            public UnicodeFileWriter create() throws Exception {
                return new UnicodeFileWriter(IOTestBase.TEST_FILE, sc);
            }
        }, sc, sc, string);
    }

    @Override
    protected byte[] encode(final Reader reader, SignatureCharset sc, String string) throws Exception {
        return this.encode(new FileEncoderTestBase.WriterCreator(){

            @Override
            public UnicodeFileWriter create() throws Exception {
                return new UnicodeFileWriter(IOTestBase.TEST_FILE, reader);
            }
        }, sc, sc, string);
    }

    @Override
    protected void testEncode(byte[] bytes, String string) throws Exception {
        super.testEncode(bytes, string);
        int halfLength = string.length() / 2;
        String firstPart = string.substring(0, halfLength);
        String secondPart = string.substring(halfLength);
        this.encode(new FileEncoderTestBase.WriterCreator(){

            @Override
            public UnicodeFileWriter create() throws Exception {
                return new UnicodeFileWriter(IOTestBase.TEST_FILE, false);
            }
        }, null, null, firstPart);
        Assert.assertArrayEquals((byte[])bytes, (byte[])this.encode(new FileEncoderTestBase.WriterCreator(){

            @Override
            public UnicodeFileWriter create() throws Exception {
                return new UnicodeFileWriter(IOTestBase.TEST_FILE, true);
            }
        }, null, null, secondPart));
        Deleter.apply((String)TEST_FILE);
        CopyBytesUtils.copy((byte[])ArrayUtils.EMPTY_BYTE_ARRAY, (String)TEST_FILE);
        Assert.assertArrayEquals((byte[])bytes, (byte[])this.encode(new FileEncoderTestBase.WriterCreator(){

            @Override
            public UnicodeFileWriter create() throws Exception {
                return new UnicodeFileWriter(IOTestBase.TEST_FILE, true);
            }
        }, null, null, string));
    }

    @Override
    protected void testEncode(final SignatureCharset sc, byte[] bytes, String string) throws Exception {
        super.testEncode(sc, bytes, string);
        int halfLength = string.length() / 2;
        String firstPart = string.substring(0, halfLength);
        String secondPart = string.substring(halfLength);
        this.encode(new FileEncoderTestBase.WriterCreator(){

            @Override
            public UnicodeFileWriter create() throws Exception {
                return new UnicodeFileWriter(IOTestBase.TEST_FILE, false, sc);
            }
        }, sc, sc, firstPart);
        Assert.assertArrayEquals((byte[])bytes, (byte[])this.encode(new FileEncoderTestBase.WriterCreator(){

            @Override
            public UnicodeFileWriter create() throws Exception {
                return new UnicodeFileWriter(IOTestBase.TEST_FILE, true, sc);
            }
        }, sc, sc, secondPart));
        Deleter.apply((String)TEST_FILE);
        CopyBytesUtils.copy((byte[])ArrayUtils.EMPTY_BYTE_ARRAY, (String)TEST_FILE);
        Assert.assertArrayEquals((byte[])bytes, (byte[])this.encode(new FileEncoderTestBase.WriterCreator(){

            @Override
            public UnicodeFileWriter create() throws Exception {
                return new UnicodeFileWriter(IOTestBase.TEST_FILE, true, sc);
            }
        }, sc, sc, string));
    }

    @Override
    protected void testEncode(final Reader reader, SignatureCharset sc, byte[] bytes, String string) throws Exception {
        super.testEncode(reader, sc, bytes, string);
        int halfLength = string.length() / 2;
        String firstPart = string.substring(0, halfLength);
        String secondPart = string.substring(halfLength);
        this.encode(new FileEncoderTestBase.WriterCreator(){

            @Override
            public UnicodeFileWriter create() throws Exception {
                return new UnicodeFileWriter(IOTestBase.TEST_FILE, false, reader);
            }
        }, sc, sc, firstPart);
        Assert.assertArrayEquals((byte[])bytes, (byte[])this.encode(new FileEncoderTestBase.WriterCreator(){

            @Override
            public UnicodeFileWriter create() throws Exception {
                return new UnicodeFileWriter(IOTestBase.TEST_FILE, true, reader);
            }
        }, sc, sc, secondPart));
        Deleter.apply((String)TEST_FILE);
        CopyBytesUtils.copy((byte[])ArrayUtils.EMPTY_BYTE_ARRAY, (String)TEST_FILE);
        Assert.assertArrayEquals((byte[])bytes, (byte[])this.encode(new FileEncoderTestBase.WriterCreator(){

            @Override
            public UnicodeFileWriter create() throws Exception {
                return new UnicodeFileWriter(IOTestBase.TEST_FILE, true, reader);
            }
        }, sc, sc, string));
    }
}

