/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.unicode;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.apache.commons.lang.ArrayUtils;
import org.junit.Assert;
import org.junit.Test;
import org.marketcetera.util.file.CloseableRegistry;
import org.marketcetera.util.file.OutputStreamWrapper;
import org.marketcetera.util.file.WriterWrapper;
import org.marketcetera.util.test.TestCaseBase;
import org.marketcetera.util.unicode.UnicodeOutputStreamWriter;

public class WriterTest
extends TestCaseBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void writer() throws Exception {
        try (CloseableRegistry r = new CloseableRegistry();){
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            r.register((Closeable)new OutputStreamWrapper((OutputStream)os));
            UnicodeOutputStreamWriter writer = new UnicodeOutputStreamWriter((OutputStream)os);
            r.register((Closeable)new WriterWrapper((Writer)writer));
            Assert.assertNull((Object)writer.getRequestedSignatureCharset());
            Assert.assertNull((Object)writer.getSignatureCharset());
            Assert.assertArrayEquals((byte[])ArrayUtils.EMPTY_BYTE_ARRAY, (byte[])os.toByteArray());
            writer.write(97);
            writer.flush();
            Assert.assertEquals((Object)"a", (Object)new String(os.toByteArray()));
            writer.write(new char[]{'b', 'c'});
            writer.flush();
            Assert.assertEquals((Object)"abc", (Object)new String(os.toByteArray()));
            writer.write(new char[]{'b', 'd', 'e', 'f'}, 1, 2);
            writer.flush();
            Assert.assertEquals((Object)"abcde", (Object)new String(os.toByteArray()));
            writer.write("fg");
            writer.flush();
            Assert.assertEquals((Object)"abcdefg", (Object)new String(os.toByteArray()));
            writer.write("ghij", 1, 2);
            writer.flush();
            Assert.assertEquals((Object)"abcdefghi", (Object)new String(os.toByteArray()));
            writer.append((CharSequence)"jk");
            writer.flush();
            Assert.assertEquals((Object)"abcdefghijk", (Object)new String(os.toByteArray()));
            writer.append((CharSequence)"klmn", 1, 3);
            writer.flush();
            Assert.assertEquals((Object)"abcdefghijklm", (Object)new String(os.toByteArray()));
            writer.append('n');
            writer.flush();
            Assert.assertEquals((Object)"abcdefghijklmn", (Object)new String(os.toByteArray()));
            writer.close();
            writer.close();
            try {
                writer.write(97);
                Assert.fail();
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
    }
}

