/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.ws.stateful;

import org.apache.commons.lang.math.NumberUtils;
import org.junit.Assert;
import org.junit.Test;
import org.marketcetera.util.test.TestCaseBase;
import org.marketcetera.util.ws.stateful.SessionHolder;
import org.marketcetera.util.ws.stateless.StatelessClientContext;

public class SessionHolderTest
extends TestCaseBase {
    private static final String TEST_USER = "metc";
    private static final StatelessClientContext TEST_CONTEXT = new StatelessClientContext();
    private static final Object TEST_SESSION = NumberUtils.INTEGER_ONE;

    @Test
    public void all() throws Exception {
        SessionHolder holder = new SessionHolder(TEST_USER, TEST_CONTEXT);
        Assert.assertEquals((Object)TEST_USER, (Object)holder.getUser());
        Assert.assertEquals((Object)TEST_CONTEXT, (Object)holder.getCreationContext());
        Assert.assertEquals((long)0L, (long)holder.getLastAccess());
        Assert.assertNull((Object)holder.getSession());
        holder.setSession(TEST_SESSION);
        Assert.assertEquals((Object)TEST_SESSION, (Object)holder.getSession());
        holder.setSession(null);
        Assert.assertNull((Object)holder.getSession());
        holder.markAccess();
        long time = holder.getLastAccess();
        Assert.assertTrue((time > 0L ? 1 : 0) != 0);
        Thread.sleep(100L);
        holder.markAccess();
        Assert.assertTrue((holder.getLastAccess() > time ? 1 : 0) != 0);
    }
}

