/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.ws.wrappers;

import javax.jws.WebService;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.marketcetera.util.test.EqualityAssert;
import org.marketcetera.util.ws.stateless.StatelessClient;
import org.marketcetera.util.ws.stateless.StatelessServer;
import org.marketcetera.util.ws.stateless.StatelessServiceBase;
import org.marketcetera.util.ws.stateless.StatelessServiceBaseImpl;
import org.marketcetera.util.ws.wrappers.RemoteException;
import org.marketcetera.util.ws.wrappers.RemoteProperties;
import org.marketcetera.util.ws.wrappers.WrapperTestBase;

public class RemoteExceptionTest
extends WrapperTestBase {
    public static final String EXPECTED_MESSAGE = "Remote exception; see cause for details";
    private static final String LOCAL_PROXY_SOURCE = RemoteExceptionTest.class.getName();
    private static final String JAVA_PROXY_SOURCE = "sun.reflect.NativeConstructorAccessorImpl";
    private static ThrowerImpl sThrower;
    private static StatelessServer sServer;
    private static Thrower sClient;

    @BeforeClass
    public static void setupRemoteExceptionTest() {
        sThrower = new ThrowerImpl();
        sServer = new StatelessServer();
        sServer.publish((StatelessServiceBase)sThrower, Thrower.class);
        sClient = (Thrower)new StatelessClient().getService(Thrower.class);
    }

    @AfterClass
    public static void tearDownRemoteExceptionTest() {
        sServer.stop();
    }

    private RemoteException assertRoundTripJAXBEx(RemoteException exception) {
        RemoteException result = null;
        sThrower.setException(exception);
        this.prepareSerWrapperFailure();
        try {
            sClient.throwException();
        }
        catch (RemoteException ex) {
            result = ex;
        }
        Assert.assertEquals((Object)((Object)exception), (Object)((Object)result));
        return result;
    }

    private void singleBase(RemoteException ex, RemoteProperties properties, boolean wrapperSerFailure, boolean wrapperDeSerFailure, String source, Throwable cause, boolean proxyUsed) {
        Assert.assertEquals((Object)EXPECTED_MESSAGE, (Object)ex.getMessage());
        Assert.assertEquals((Object)properties, (Object)ex.getProperties());
        if (wrapperSerFailure) {
            this.assertSerWrapperSerFailure(ex.getProperties().getWrapper());
        } else if (ex.getProperties() != null) {
            Assert.assertNull((Object)((Object)ex.getProperties().getWrapper().getSerializationException()));
        }
        if (wrapperDeSerFailure) {
            this.assertSerWrapperDeSerFailure(ex.getProperties().getWrapper());
        } else if (ex.getProperties() != null) {
            Assert.assertNull((Object)((Object)ex.getProperties().getWrapper().getDeserializationException()));
        }
        Assert.assertEquals((Object)source, (Object)ex.getStackTrace()[0].getClassName());
        RemoteExceptionTest.assertThrowable(cause, ex.getCause(), proxyUsed);
    }

    private void singleNonSerializable(RemoteException server, RemoteException client, String source) {
        this.singleBase(client, server.getProperties(), false, false, source, server.getCause(), true);
    }

    private void singleNonDeserializable(RemoteException server, RemoteException client, String source) {
        this.singleBase(client, server.getProperties(), false, true, source, server.getCause(), true);
    }

    private void single(RemoteException server, RemoteProperties properties, Throwable cause) throws Exception {
        this.singleBase(server, properties, false, false, LOCAL_PROXY_SOURCE, cause, false);
        this.singleBase(this.assertRoundTripJAXBEx(server), properties, false, false, JAVA_PROXY_SOURCE, cause, false);
        this.singleBase(this.assertRoundTripJava(server), properties, false, false, JAVA_PROXY_SOURCE, cause, false);
    }

    @Test
    public void basics() throws Exception {
        EqualityAssert.assertEquality((Object)((Object)new RemoteException()), (Object)((Object)new RemoteException()), (Object[])new Object[]{new RemoteException(TEST_THROWABLE), new RemoteException((Throwable)TEST_I18N_THROWABLE)});
        this.single(new RemoteException(), null, null);
        EqualityAssert.assertEquality((Object)((Object)new RemoteException(null)), (Object)((Object)new RemoteException(null)), (Object[])new Object[]{new RemoteException(TEST_THROWABLE), new RemoteException((Throwable)TEST_I18N_THROWABLE)});
        this.single(new RemoteException(null), null, null);
        Assert.assertEquals((Object)((Object)new RemoteException()), (Object)((Object)new RemoteException(null)));
        EqualityAssert.assertEquality((Object)((Object)new RemoteException(TEST_THROWABLE)), (Object)((Object)new RemoteException(TEST_THROWABLE)), (Object[])new Object[]{new RemoteException(), new RemoteException(null), new RemoteException((Throwable)TEST_I18N_THROWABLE)});
        this.single(new RemoteException(TEST_THROWABLE), new RemoteProperties(TEST_THROWABLE), TEST_THROWABLE);
        EqualityAssert.assertEquality((Object)((Object)new RemoteException((Throwable)TEST_I18N_THROWABLE)), (Object)((Object)new RemoteException((Throwable)TEST_I18N_THROWABLE)), (Object[])new Object[]{new RemoteException(), new RemoteException(null), new RemoteException(TEST_THROWABLE)});
        this.single(new RemoteException((Throwable)TEST_I18N_THROWABLE), new RemoteProperties((Throwable)TEST_I18N_THROWABLE), TEST_I18N_THROWABLE);
    }

    @Test
    public void setters() {
        RemoteException ex = new RemoteException();
        RemoteProperties p = new RemoteProperties();
        ex.setProperties(p);
        Assert.assertEquals((Object)p, (Object)ex.getProperties());
        ex.setProperties(null);
        Assert.assertNull((Object)ex.getProperties());
    }

    @Test
    public void nonSerializableThrowable() throws Exception {
        this.prepareSerWrapperFailure();
        RemoteException server = new RemoteException(TEST_NONSER_THROWABLE);
        EqualityAssert.assertEquality((Object)((Object)server), (Object)((Object)new RemoteException(TEST_NONSER_THROWABLE)), (Object[])new Object[]{new RemoteException(), new RemoteException(null), new RemoteException(TEST_THROWABLE), new RemoteException((Throwable)TEST_I18N_THROWABLE)});
        this.singleBase(server, new RemoteProperties(TEST_NONSER_THROWABLE), true, false, LOCAL_PROXY_SOURCE, TEST_NONSER_THROWABLE, false);
        this.singleNonSerializable(server, this.assertRoundTripJAXBEx(server), JAVA_PROXY_SOURCE);
        this.singleNonSerializable(server, this.assertRoundTripJava(server), JAVA_PROXY_SOURCE);
    }

    @Test
    public void nonDeserializableThrowable() throws Exception {
        RemoteException server = new RemoteException((Throwable)TEST_NONDESER_THROWABLE);
        EqualityAssert.assertEquality((Object)((Object)server), (Object)((Object)new RemoteException((Throwable)TEST_NONDESER_THROWABLE)), (Object[])new Object[]{new RemoteException(), new RemoteException(null), new RemoteException(TEST_THROWABLE), new RemoteException((Throwable)TEST_I18N_THROWABLE), new RemoteException(TEST_NONSER_THROWABLE)});
        this.singleBase(server, new RemoteProperties((Throwable)TEST_NONDESER_THROWABLE), false, false, LOCAL_PROXY_SOURCE, TEST_NONDESER_THROWABLE, false);
        this.singleNonDeserializable(server, this.assertRoundTripJAXBEx(server), JAVA_PROXY_SOURCE);
        this.singleNonDeserializable(server, this.assertRoundTripJava(server), JAVA_PROXY_SOURCE);
    }

    public static class ThrowerImpl
    extends StatelessServiceBaseImpl
    implements Thrower {
        private RemoteException mException;

        public void setException(RemoteException exception) {
            this.mException = exception;
        }

        @Override
        public void throwException() throws RemoteException {
            throw this.mException;
        }
    }

    @WebService
    public static interface Thrower
    extends StatelessServiceBase {
        public void throwException() throws RemoteException;
    }
}

