/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.file;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.marketcetera.util.misc.ClassVersion;

@ClassVersion(value="$Id: OutputStreamWrapper.java 16154 2012-07-14 16:34:05Z colin $")
public class OutputStreamWrapper
implements Closeable {
    private OutputStream mStream;
    private boolean mSkipClose;

    public OutputStreamWrapper(String name) throws FileNotFoundException {
        if (name.equals(":stdout:")) {
            this.mStream = System.out;
            this.mSkipClose = true;
            return;
        }
        if (name.equals(":stderr:")) {
            this.mStream = System.err;
            this.mSkipClose = true;
            return;
        }
        if (!name.startsWith(":append:")) {
            this.mStream = new FileOutputStream(name);
            return;
        }
        this.mStream = new FileOutputStream(name.substring(":append:".length()), true);
    }

    public OutputStreamWrapper(File file) throws FileNotFoundException {
        this.mStream = new FileOutputStream(file);
    }

    public OutputStreamWrapper(OutputStream stream, boolean skipClose) {
        this.mStream = stream;
        this.mSkipClose = skipClose;
    }

    public OutputStreamWrapper(OutputStream stream) {
        this(stream, false);
    }

    @Override
    public void close() throws IOException {
        if (this.getStream() == null) {
            return;
        }
        this.getStream().flush();
        if (this.getSkipClose()) {
            return;
        }
        this.getStream().close();
        this.mStream = null;
    }

    public OutputStream getStream() {
        return this.mStream;
    }

    public boolean getSkipClose() {
        return this.mSkipClose;
    }
}

