/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.rpc;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.protobuf.BlockingService;
import com.googlecode.protobuf.pro.duplex.PeerInfo;
import com.googlecode.protobuf.pro.duplex.execute.RpcServerCallExecutor;
import com.googlecode.protobuf.pro.duplex.execute.ThreadPoolCallExecutor;
import com.googlecode.protobuf.pro.duplex.server.DuplexTcpServerPipelineFactory;
import com.googlecode.protobuf.pro.duplex.util.RenamingThreadFactoryProxy;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.lang.Validate;
import org.marketcetera.util.log.SLF4JLoggerProxy;
import org.marketcetera.util.misc.ClassVersion;
import org.marketcetera.util.rpc.Messages;
import org.marketcetera.util.rpc.RpcCredentials;
import org.marketcetera.util.rpc.RpcServerServices;
import org.marketcetera.util.rpc.RpcServiceSpec;
import org.marketcetera.util.ws.ContextClassProvider;
import org.marketcetera.util.ws.stateful.Authenticator;
import org.marketcetera.util.ws.stateful.SessionHolder;
import org.marketcetera.util.ws.stateful.SessionManager;
import org.marketcetera.util.ws.stateless.StatelessClientContext;
import org.marketcetera.util.ws.tags.AppId;
import org.marketcetera.util.ws.tags.NodeId;
import org.marketcetera.util.ws.tags.SessionId;
import org.marketcetera.util.ws.tags.VersionId;
import org.marketcetera.util.ws.wrappers.LocaleWrapper;
import org.springframework.context.Lifecycle;

@ClassVersion(value="$Id$")
public class RpcServer<SessionClazz>
implements Lifecycle,
RpcServerServices<SessionClazz> {
    private SessionManager<SessionClazz> sessionManager;
    private Authenticator authenticator;
    private final AtomicBoolean running = new AtomicBoolean(false);
    private RpcServerCallExecutor executor;
    private ChannelFuture channelToken;
    private final Map<SessionId, String> rpcSessions = Maps.newConcurrentMap();
    private String hostname;
    private int port;
    private int sendBufferSize = 0x100000;
    private int receiveBufferSize = 0x100000;
    private boolean noDelay = true;
    private int threadPoolCore = 10;
    private int threadPoolMax = 200;
    private ContextClassProvider contextClassProvider;
    private JAXBContext reportContext;
    private Marshaller marshaller;
    private Unmarshaller unmarshaller;
    private final List<RpcServiceSpec<SessionClazz>> serviceSpecs = Lists.newArrayList();

    public boolean isRunning() {
        return this.running.get();
    }

    @PostConstruct
    public synchronized void start() {
        Validate.notNull((Object)this.hostname);
        Validate.isTrue((this.port > 0 && this.port < 65536 ? 1 : 0) != 0);
        Validate.notNull(this.sessionManager);
        Validate.notNull((Object)this.authenticator);
        Validate.isTrue((this.threadPoolCore > 0 ? 1 : 0) != 0);
        Validate.isTrue((this.threadPoolMax > 0 ? 1 : 0) != 0);
        Validate.isTrue((this.threadPoolMax >= this.threadPoolCore ? 1 : 0) != 0);
        Validate.isTrue((this.sendBufferSize > 0 ? 1 : 0) != 0);
        Validate.isTrue((this.receiveBufferSize > 0 ? 1 : 0) != 0);
        Validate.notEmpty(this.serviceSpecs);
        Messages.SERVER_STARTING.info(this, this.hostname, this.port);
        if (this.isRunning()) {
            this.stop();
        }
        try {
            this.reportContext = JAXBContext.newInstance((Class[])(this.contextClassProvider == null ? new Class[]{} : this.contextClassProvider.getContextClasses()));
            this.marshaller = this.reportContext.createMarshaller();
            this.unmarshaller = this.reportContext.createUnmarshaller();
        }
        catch (JAXBException e) {
            SLF4JLoggerProxy.error((Object)this, e);
            throw new RuntimeException(e);
        }
        PeerInfo serverInfo = new PeerInfo(this.getRpcHostname(), this.getRpcPort());
        this.executor = new ThreadPoolCallExecutor(this.threadPoolCore, this.threadPoolMax);
        DuplexTcpServerPipelineFactory serverFactory = new DuplexTcpServerPipelineFactory(serverInfo);
        serverFactory.setRpcServerCallExecutor(this.executor);
        ServerBootstrap bootstrap = new ServerBootstrap();
        bootstrap.group((EventLoopGroup)new NioEventLoopGroup(0, (ThreadFactory)new RenamingThreadFactoryProxy("boss", Executors.defaultThreadFactory())), (EventLoopGroup)new NioEventLoopGroup(0, (ThreadFactory)new RenamingThreadFactoryProxy("worker", Executors.defaultThreadFactory())));
        bootstrap.channel(NioServerSocketChannel.class);
        bootstrap.childHandler((ChannelHandler)serverFactory);
        bootstrap.localAddress(serverInfo.getPort());
        bootstrap.option(ChannelOption.SO_SNDBUF, (Object)this.sendBufferSize);
        bootstrap.option(ChannelOption.SO_RCVBUF, (Object)this.receiveBufferSize);
        bootstrap.childOption(ChannelOption.SO_RCVBUF, (Object)this.receiveBufferSize);
        bootstrap.childOption(ChannelOption.SO_SNDBUF, (Object)this.sendBufferSize);
        bootstrap.option(ChannelOption.TCP_NODELAY, (Object)this.noDelay);
        for (RpcServiceSpec<SessionClazz> serviceSpec : this.serviceSpecs) {
            serviceSpec.setRpcServerServices(this);
            BlockingService activeService = serviceSpec.generateService();
            serverFactory.getRpcServiceRegistry().registerService(activeService);
            Messages.SERVICE_STARTING.info(this, serviceSpec.getDescription());
        }
        this.channelToken = bootstrap.bind();
        while (!this.channelToken.isDone()) {
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        this.running.set(this.channelToken.isSuccess());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PreDestroy
    public synchronized void stop() {
        Messages.SERVER_STOPPING.info(this);
        try {
            try {
                if (this.executor != null) {
                    this.executor.shutdownNow();
                }
            }
            catch (Exception ignored) {
                // empty catch block
            }
            try {
                if (this.channelToken != null && this.channelToken.channel() != null) {
                    this.channelToken.channel().close();
                }
            }
            catch (Exception ignored) {
                // empty catch block
            }
            for (SessionId session : this.rpcSessions.keySet()) {
                try {
                    this.sessionManager.remove(session);
                }
                catch (Exception exception) {}
            }
        }
        finally {
            this.rpcSessions.clear();
            this.channelToken = null;
            this.executor = null;
            this.reportContext = null;
            this.marshaller = null;
            this.unmarshaller = null;
            this.running.set(false);
        }
    }

    public List<RpcServiceSpec<SessionClazz>> getServiceSpecs() {
        return this.serviceSpecs;
    }

    public void setServiceSpecs(List<RpcServiceSpec<SessionClazz>> inServiceSpecs) {
        this.serviceSpecs.clear();
        if (inServiceSpecs != null) {
            this.serviceSpecs.addAll(inServiceSpecs);
        }
    }

    public int getSendBufferSize() {
        return this.sendBufferSize;
    }

    public void setSendBufferSize(int inSendBufferSize) {
        this.sendBufferSize = inSendBufferSize;
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public void setReceiveBufferSize(int inReceiveBufferSize) {
        this.receiveBufferSize = inReceiveBufferSize;
    }

    public boolean getNoDelay() {
        return this.noDelay;
    }

    public void setNoDelay(boolean inNoDelay) {
        this.noDelay = inNoDelay;
    }

    public int getThreadPoolCore() {
        return this.threadPoolCore;
    }

    public void setThreadPoolCore(int inThreadPoolCore) {
        this.threadPoolCore = inThreadPoolCore;
    }

    public int getThreadPoolMax() {
        return this.threadPoolMax;
    }

    public void setThreadPoolMax(int inThreadPoolMax) {
        this.threadPoolMax = inThreadPoolMax;
    }

    public String getRpcHostname() {
        return this.hostname;
    }

    public void setHostname(String inRpcHostname) {
        this.hostname = inRpcHostname;
    }

    public int getRpcPort() {
        return this.port;
    }

    public void setPort(int inRpcPort) {
        this.port = inRpcPort;
    }

    public Authenticator getAuthenticator() {
        return this.authenticator;
    }

    public void setAuthenticator(Authenticator inAuthenticator) {
        this.authenticator = inAuthenticator;
    }

    public SessionManager<SessionClazz> getSessionManager() {
        return this.sessionManager;
    }

    public void setSessionManager(SessionManager<SessionClazz> inSessionManager) {
        this.sessionManager = inSessionManager;
    }

    public ContextClassProvider getContextClassProvider() {
        return this.contextClassProvider;
    }

    public void setContextClassProvider(ContextClassProvider inContextClassProvider) {
        this.contextClassProvider = inContextClassProvider;
    }

    @Override
    public SessionId login(RpcCredentials inCredentials) {
        StatelessClientContext context = new StatelessClientContext();
        context.setAppId(new AppId(inCredentials.getAppId()));
        context.setClientId(new NodeId(inCredentials.getClientId()));
        context.setVersionId(new VersionId(inCredentials.getVersionId()));
        LocaleWrapper locale = new LocaleWrapper(inCredentials.getLocale());
        context.setLocale(locale);
        this.authenticator.shouldAllow(context, inCredentials.getUsername(), inCredentials.getPassword().toCharArray());
        SessionId sessionId = SessionId.generate();
        SessionHolder sessionHolder = new SessionHolder(inCredentials.getUsername(), context);
        this.sessionManager.put(sessionId, sessionHolder);
        this.rpcSessions.put(sessionId, inCredentials.getUsername());
        return sessionId;
    }

    @Override
    public void logout(String inSessionIdValue) {
        SessionId session = new SessionId(inSessionIdValue);
        this.rpcSessions.remove(session);
        this.sessionManager.remove(session);
    }

    @Override
    public SessionHolder<SessionClazz> validateAndReturnSession(String inSessionIdValue) {
        SessionId session = new SessionId(inSessionIdValue);
        SessionHolder<SessionClazz> sessionInfo = this.sessionManager.get(session);
        if (sessionInfo == null) {
            throw new IllegalArgumentException("Invalid session: " + inSessionIdValue);
        }
        return sessionInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String marshal(Object inObject) throws JAXBException {
        StringWriter output = new StringWriter();
        Marshaller marshaller = this.marshaller;
        synchronized (marshaller) {
            this.marshaller.marshal(inObject, (Writer)output);
        }
        return output.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <Clazz> Clazz unmarshall(String inData) throws JAXBException {
        Unmarshaller unmarshaller = this.unmarshaller;
        synchronized (unmarshaller) {
            return (Clazz)this.unmarshaller.unmarshal((Reader)new StringReader(inData));
        }
    }
}

