/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.unicode;

import java.util.EnumSet;
import org.marketcetera.util.except.I18NException;
import org.marketcetera.util.misc.ClassVersion;
import org.marketcetera.util.unicode.Messages;
import org.marketcetera.util.unicode.Signature;
import org.marketcetera.util.unicode.SignatureCharset;

@ClassVersion(value="$Id: Serialization.java 16154 2012-07-14 16:34:05Z colin $")
public enum Serialization {
    UTF8(SignatureCharset.UTF8_UTF8),
    UTF8N(SignatureCharset.NONE_UTF8),
    UTF16(new SignatureCharset[]{SignatureCharset.NONE_UTF16BE, SignatureCharset.UTF16BE_UTF16BE, SignatureCharset.UTF16LE_UTF16LE}),
    UTF16BE(SignatureCharset.NONE_UTF16BE),
    UTF16LE(SignatureCharset.NONE_UTF16LE),
    UTF32(new SignatureCharset[]{SignatureCharset.NONE_UTF32BE, SignatureCharset.UTF32BE_UTF32BE, SignatureCharset.UTF32LE_UTF32LE}),
    UTF32BE(SignatureCharset.NONE_UTF32BE),
    UTF32LE(SignatureCharset.NONE_UTF32LE),
    UTF16BE_REQ(SignatureCharset.UTF16BE_UTF16BE),
    UTF16LE_REQ(SignatureCharset.UTF16LE_UTF16LE),
    UTF32BE_REQ(SignatureCharset.UTF32BE_UTF32BE),
    UTF32LE_REQ(SignatureCharset.UTF32LE_UTF32LE);

    private final SignatureCharset[] mSignatureCharsets;

    private Serialization(SignatureCharset signatureCharset) {
        this.mSignatureCharsets = new SignatureCharset[]{signatureCharset};
    }

    private Serialization(SignatureCharset[] signatureCharsets) {
        this.mSignatureCharsets = signatureCharsets;
    }

    public static SignatureCharset getPrefixMatch(Serialization[] candidates, byte[] data) {
        EnumSet<Signature> signatures = EnumSet.noneOf(Signature.class);
        for (Serialization serialization : candidates) {
            for (SignatureCharset sc : serialization.getSignatureCharsets()) {
                signatures.add(sc.getSignature());
            }
        }
        Signature match = Signature.getPrefixMatch(signatures.toArray(Signature.EMPTY_ARRAY), data);
        for (Serialization serialization : candidates) {
            for (SignatureCharset sc : serialization.getSignatureCharsets()) {
                if (sc.getSignature() != match) continue;
                return sc;
            }
        }
        return null;
    }

    public static String decode(Serialization[] candidates, byte[] data) throws I18NException {
        if (data == null) {
            return null;
        }
        SignatureCharset sc = Serialization.getPrefixMatch(candidates, data);
        if (sc == null) {
            throw new I18NException(Messages.NO_SIGNATURE_MATCHES);
        }
        return sc.decode(data);
    }

    public SignatureCharset[] getSignatureCharsets() {
        return this.mSignatureCharsets;
    }
}

