/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.except;

import java.io.Serializable;
import org.junit.Test;
import org.marketcetera.util.except.I18NError;
import org.marketcetera.util.except.I18NException;
import org.marketcetera.util.except.I18NThrowable;
import org.marketcetera.util.except.I18NThrowableTestBase;
import org.marketcetera.util.except.TestMessages;
import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.log.I18NBoundMessage1P;

public class I18NErrorTest
extends I18NThrowableTestBase {
    private static final I18NThrowable[] ALL = new I18NThrowable[]{new I18NError(), new I18NError((Throwable)((Object)new AssertionError())), new I18NError((Throwable)((Object)new AssertionError((Object)"Test message 1 (expected)"))), new I18NError((Throwable)new I18NError((I18NBoundMessage)new I18NBoundMessage1P(TestMessages.MID_EXCEPTION, (Serializable)((Object)"a")))), new I18NError((I18NBoundMessage)new I18NBoundMessage1P(TestMessages.MID_EXCEPTION, (Serializable)((Object)"a"))), new I18NError((Throwable)((Object)new AssertionError()), (I18NBoundMessage)new I18NBoundMessage1P(TestMessages.MID_EXCEPTION, (Serializable)((Object)"a"))), new I18NError((Throwable)((Object)new AssertionError((Object)"Test message 2 (expected)")), (I18NBoundMessage)new I18NBoundMessage1P(TestMessages.MID_EXCEPTION, (Serializable)((Object)"a"))), new I18NError((Throwable)new I18NError((I18NBoundMessage)TestMessages.BOT_EXCEPTION), (I18NBoundMessage)new I18NBoundMessage1P(TestMessages.MID_EXCEPTION, (Serializable)((Object)"a"))), new I18NException(), null};

    @Test
    public void empty() {
        I18NErrorTest.empty(new Error(), (I18NThrowable)new I18NError(), ALL, 0);
    }

    @Test
    public void causeWithoutMessage() {
        AssertionError nested = new AssertionError();
        I18NErrorTest.causeWithoutMessage((Throwable)((Object)nested), new Error((Throwable)((Object)nested)), (I18NThrowable)new I18NError((Throwable)((Object)nested)), ALL, 1);
    }

    @Test
    public void causeWithMessage() {
        AssertionError nested = new AssertionError((Object)"Test message 1 (expected)");
        I18NErrorTest.causeWithMessage((Throwable)((Object)nested), new Error((Throwable)((Object)nested)), (I18NThrowable)new I18NError((Throwable)((Object)nested)), ALL, 2);
    }

    @Test
    public void causeWithI18NMessage() {
        I18NError nested = new I18NError((I18NBoundMessage)new I18NBoundMessage1P(TestMessages.MID_EXCEPTION, (Serializable)((Object)"a")));
        I18NErrorTest.causeWithI18NMessage((I18NThrowable)nested, new Error((Throwable)nested), (I18NThrowable)new I18NError((Throwable)nested), ALL, 3);
    }

    @Test
    public void myMessage() {
        I18NErrorTest.myMessage(new Error("Test message 1 (expected)"), (I18NThrowable)new I18NError((I18NBoundMessage)new I18NBoundMessage1P(TestMessages.MID_EXCEPTION, (Serializable)((Object)"a"))), ALL, 4);
    }

    @Test
    public void myMessageAndCauseWithoutMessage() {
        AssertionError nested = new AssertionError();
        I18NErrorTest.myMessageAndCauseWithoutMessage((Throwable)((Object)nested), new Error("Test message 1 (expected)", (Throwable)((Object)nested)), (I18NThrowable)new I18NError((Throwable)((Object)nested), (I18NBoundMessage)new I18NBoundMessage1P(TestMessages.MID_EXCEPTION, (Serializable)((Object)"a"))), ALL, 5);
    }

    @Test
    public void myMessageAndCauseWithMessage() {
        AssertionError nested = new AssertionError((Object)"Test message 2 (expected)");
        I18NErrorTest.myMessageAndCauseWithMessage((Throwable)((Object)nested), new Error("Test message 1 (expected)", (Throwable)((Object)nested)), (I18NThrowable)new I18NError((Throwable)((Object)nested), (I18NBoundMessage)new I18NBoundMessage1P(TestMessages.MID_EXCEPTION, (Serializable)((Object)"a"))), ALL, 6);
    }

    @Test
    public void myMessageAndCauseWithI18NMessage() {
        I18NError nested = new I18NError((I18NBoundMessage)TestMessages.BOT_EXCEPTION);
        I18NErrorTest.myMessageAndCauseWithI18NMessage((I18NThrowable)nested, new Error("Test message 1 (expected)", (Throwable)nested), (I18NThrowable)new I18NError((Throwable)nested, (I18NBoundMessage)new I18NBoundMessage1P(TestMessages.MID_EXCEPTION, (Serializable)((Object)"a"))), ALL, 7);
    }

    @Test
    public void nesting() {
        I18NError exBot = new I18NError((I18NBoundMessage)TestMessages.BOT_EXCEPTION);
        I18NError exMid = new I18NError((Throwable)exBot, (I18NBoundMessage)new I18NBoundMessage1P(TestMessages.MID_EXCEPTION, (Serializable)((Object)"a")));
        I18NError exTop = new I18NError((Throwable)exMid, (I18NBoundMessage)TestMessages.TOP_EXCEPTION);
        I18NErrorTest.nesting((I18NThrowable)exBot, (I18NThrowable)exMid, (I18NThrowable)exTop);
    }
}

