/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.except;

import java.io.Serializable;
import org.junit.Test;
import org.marketcetera.util.except.I18NError;
import org.marketcetera.util.except.I18NException;
import org.marketcetera.util.except.I18NThrowable;
import org.marketcetera.util.except.I18NThrowableTestBase;
import org.marketcetera.util.except.TestMessages;
import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.log.I18NBoundMessage1P;

public class I18NExceptionTest
extends I18NThrowableTestBase {
    private static final I18NThrowable[] ALL = new I18NThrowable[]{new I18NException(), new I18NException((Throwable)new CloneNotSupportedException()), new I18NException((Throwable)new CloneNotSupportedException("Test message 1 (expected)")), new I18NException((Throwable)new I18NException((I18NBoundMessage)new I18NBoundMessage1P(TestMessages.MID_EXCEPTION, (Serializable)((Object)"a")))), new I18NException((I18NBoundMessage)new I18NBoundMessage1P(TestMessages.MID_EXCEPTION, (Serializable)((Object)"a"))), new I18NException((Throwable)new CloneNotSupportedException(), (I18NBoundMessage)new I18NBoundMessage1P(TestMessages.MID_EXCEPTION, (Serializable)((Object)"a"))), new I18NException((Throwable)new CloneNotSupportedException("Test message 2 (expected)"), (I18NBoundMessage)new I18NBoundMessage1P(TestMessages.MID_EXCEPTION, (Serializable)((Object)"a"))), new I18NException((Throwable)new I18NException((I18NBoundMessage)TestMessages.BOT_EXCEPTION), (I18NBoundMessage)new I18NBoundMessage1P(TestMessages.MID_EXCEPTION, (Serializable)((Object)"a"))), new I18NError(), null};

    @Test
    public void empty() {
        I18NExceptionTest.empty(new Exception(), (I18NThrowable)new I18NException(), ALL, 0);
    }

    @Test
    public void causeWithoutMessage() {
        CloneNotSupportedException nested = new CloneNotSupportedException();
        I18NExceptionTest.causeWithoutMessage(nested, new Exception(nested), (I18NThrowable)new I18NException((Throwable)nested), ALL, 1);
    }

    @Test
    public void causeWithMessage() {
        CloneNotSupportedException nested = new CloneNotSupportedException("Test message 1 (expected)");
        I18NExceptionTest.causeWithMessage(nested, new Exception(nested), (I18NThrowable)new I18NException((Throwable)nested), ALL, 2);
    }

    @Test
    public void causeWithI18NMessage() {
        I18NException nested = new I18NException((I18NBoundMessage)new I18NBoundMessage1P(TestMessages.MID_EXCEPTION, (Serializable)((Object)"a")));
        I18NExceptionTest.causeWithI18NMessage((I18NThrowable)nested, new Exception(nested), (I18NThrowable)new I18NException((Throwable)nested), ALL, 3);
    }

    @Test
    public void myMessage() {
        I18NExceptionTest.myMessage(new Exception("Test message 1 (expected)"), (I18NThrowable)new I18NException((I18NBoundMessage)new I18NBoundMessage1P(TestMessages.MID_EXCEPTION, (Serializable)((Object)"a"))), ALL, 4);
    }

    @Test
    public void myMessageAndCauseWithoutMessage() {
        CloneNotSupportedException nested = new CloneNotSupportedException();
        I18NExceptionTest.myMessageAndCauseWithoutMessage(nested, new Exception("Test message 1 (expected)", nested), (I18NThrowable)new I18NException((Throwable)nested, (I18NBoundMessage)new I18NBoundMessage1P(TestMessages.MID_EXCEPTION, (Serializable)((Object)"a"))), ALL, 5);
    }

    @Test
    public void myMessageAndCauseWithMessage() {
        CloneNotSupportedException nested = new CloneNotSupportedException("Test message 2 (expected)");
        I18NExceptionTest.myMessageAndCauseWithMessage(nested, new Exception("Test message 1 (expected)", nested), (I18NThrowable)new I18NException((Throwable)nested, (I18NBoundMessage)new I18NBoundMessage1P(TestMessages.MID_EXCEPTION, (Serializable)((Object)"a"))), ALL, 6);
    }

    @Test
    public void myMessageAndCauseWithI18NMessage() {
        I18NException nested = new I18NException((I18NBoundMessage)TestMessages.BOT_EXCEPTION);
        I18NExceptionTest.myMessageAndCauseWithI18NMessage((I18NThrowable)nested, new Exception("Test message 1 (expected)", nested), (I18NThrowable)new I18NException((Throwable)nested, (I18NBoundMessage)new I18NBoundMessage1P(TestMessages.MID_EXCEPTION, (Serializable)((Object)"a"))), ALL, 7);
    }

    @Test
    public void nesting() {
        I18NException exBot = new I18NException((I18NBoundMessage)TestMessages.BOT_EXCEPTION);
        I18NException exMid = new I18NException((Throwable)exBot, (I18NBoundMessage)new I18NBoundMessage1P(TestMessages.MID_EXCEPTION, (Serializable)((Object)"a")));
        I18NException exTop = new I18NException((Throwable)exMid, (I18NBoundMessage)TestMessages.TOP_EXCEPTION);
        I18NExceptionTest.nesting((I18NThrowable)exBot, (I18NThrowable)exMid, (I18NThrowable)exTop);
    }
}

