/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.exec;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Locale;
import org.apache.log4j.Level;
import org.junit.Assert;
import org.junit.Test;
import org.marketcetera.util.exec.InputThread;
import org.marketcetera.util.log.ActiveLocale;
import org.marketcetera.util.test.TestCaseBase;

public class InputThreadTest
extends TestCaseBase {
    private static final String TEST_CATEGORY;
    private static final int SLEEP_DURATION = 1000;
    private static final String TEST_LOCATION;

    private void single(boolean closeOut) throws Exception {
        GenerousInputStream in = new GenerousInputStream();
        ForgetfulOutputStream out = new ForgetfulOutputStream();
        InputThread child = new InputThread("command", (InputStream)in, (OutputStream)out, closeOut);
        child.start();
        Thread.sleep(500L);
        child.interrupt();
        Thread.sleep(500L);
        this.assertSingleEvent(Level.ERROR, TEST_CATEGORY, "Cannot copy output of command 'command'", TEST_LOCATION);
        Assert.assertEquals((long)1L, (long)in.getClosures());
        Assert.assertEquals((long)(closeOut ? 1 : 0), (long)out.getClosures());
    }

    @Test
    public void cannotCopy() throws Exception {
        ActiveLocale.setProcessLocale((Locale)Locale.ROOT);
        InputThreadTest.setLevel((String)TEST_CATEGORY, (Level)Level.ERROR);
        this.single(true);
        this.single(false);
    }

    static {
        TEST_LOCATION = TEST_CATEGORY = InputThread.class.getName();
    }

    private static final class ForgetfulOutputStream
    extends OutputStream {
        private int mClosures = 0;

        private ForgetfulOutputStream() {
        }

        int getClosures() {
            return this.mClosures;
        }

        @Override
        public void write(int b) {
        }

        @Override
        public void close() {
            ++this.mClosures;
        }
    }

    private static final class GenerousInputStream
    extends InputStream {
        private int mClosures = 0;

        private GenerousInputStream() {
        }

        int getClosures() {
            return this.mClosures;
        }

        private static void sleep() throws IOException {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ex) {
                throw new IOException(ex);
            }
        }

        @Override
        public int read() throws IOException {
            GenerousInputStream.sleep();
            return 0;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            GenerousInputStream.sleep();
            return 0;
        }

        @Override
        public void close() {
            ++this.mClosures;
        }
    }
}

