/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.l10n;

import java.io.Serializable;
import java.util.Locale;
import org.junit.Assert;
import org.junit.Test;
import org.marketcetera.util.except.I18NException;
import org.marketcetera.util.l10n.Messages;
import org.marketcetera.util.l10n.PropertiesFileInfo;
import org.marketcetera.util.l10n.PropertyMessageInfo;
import org.marketcetera.util.l10n.TestMessages;
import org.marketcetera.util.log.I18NBoundMessage1P;
import org.marketcetera.util.test.CollectionAssert;
import org.marketcetera.util.test.TestCaseBase;

public class PropertiesFileInfoTest
extends TestCaseBase {
    @Test
    public void english() throws Exception {
        PropertiesFileInfo info = new PropertiesFileInfo(TestMessages.PROVIDER);
        Assert.assertEquals((Object)TestMessages.PROVIDER, (Object)info.getProvider());
        Assert.assertEquals((Object)Locale.ROOT, (Object)info.getLocale());
        CollectionAssert.assertArrayPermutation((Object[])new PropertyMessageInfo[]{new PropertyMessageInfo("m0.msg", 0, "Text"), new PropertyMessageInfo("m1.msg", 1, "Text {0}"), new PropertyMessageInfo("m2.msg", 2, "Text {0} {1}"), new PropertyMessageInfo("m3.msg", 3, "Text {0} {1} {2}"), new PropertyMessageInfo("m4.msg", 4, "Text {0} {1} {2} {3}"), new PropertyMessageInfo("m5.msg", 5, "Text {0} {1} {2} {3} {4}"), new PropertyMessageInfo("m6.msg", 6, "Text {0} {1} {2} {3} {4} {5}"), new PropertyMessageInfo("m7.msg", 7, "Text {0} {1} {2} {3} {4} {5} {6}"), new PropertyMessageInfo("m8.msg", 8, "Text {0} {1} {2} {3} {4} {5} {6} {7}"), new PropertyMessageInfo("b1.ttl", 0, "B Text"), new PropertyMessageInfo("b2.ttl", 1, "B Text {0,date,full}")}, (Object[])info.getMessageInfo().toArray(PropertyMessageInfo.EMPTY_ARRAY));
    }

    @Test
    public void greek() throws Exception {
        Locale locale = new Locale("gr");
        PropertiesFileInfo info = new PropertiesFileInfo(TestMessages.PROVIDER, locale);
        Assert.assertEquals((Object)TestMessages.PROVIDER, (Object)info.getProvider());
        Assert.assertEquals((Object)locale, (Object)info.getLocale());
        CollectionAssert.assertArrayPermutation((Object[])new PropertyMessageInfo[]{new PropertyMessageInfo("m2.msg", 2, "\u0393\u0395\u0399\u0391 \u03a3\u039f\u03a5 {1} {1} {1}"), new PropertyMessageInfo("m3.msg", 5, "{0}: {1,choice,0#|1#{2}}{3,choice,0#|1#({4})}")}, (Object[])info.getMessageInfo().toArray(PropertyMessageInfo.EMPTY_ARRAY));
    }

    @Test
    public void badText() {
        try {
            new PropertiesFileInfo(TestMessages.PROVIDER, Locale.GERMAN);
            Assert.fail();
        }
        catch (I18NException ex) {
            Assert.assertEquals((String)ex.getDetail(), (Object)new I18NBoundMessage1P(Messages.BAD_TEXT, (Serializable)((Object)"{0")), (Object)ex.getI18NBoundMessage());
        }
    }

    @Test
    public void missingFile() {
        try {
            new PropertiesFileInfo(TestMessages.PROVIDER, Locale.FRENCH);
            Assert.fail();
        }
        catch (I18NException ex) {
            Assert.assertEquals((String)ex.getDetail(), (Object)new I18NBoundMessage1P(Messages.NONEXISTENT_RESOURCE, (Serializable)((Object)"util_l10n_test_messages_fr.properties")), (Object)ex.getI18NBoundMessage());
        }
    }
}

