/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.log;

import java.util.Locale;
import java.util.concurrent.Callable;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.marketcetera.util.log.ActiveLocale;
import org.marketcetera.util.test.TestCaseBase;

public class ActiveLocaleTest
extends TestCaseBase {
    private static final Locale DEFAULT_LOCALE = Locale.getDefault();

    private static void checkBasics(Locale processLocale, Locale activeLocale) {
        Assert.assertEquals((Object)processLocale, (Object)ActiveLocale.getProcessLocale());
        Assert.assertEquals((Object)activeLocale, (Object)ActiveLocale.getLocale());
    }

    private static void checkRunnableSingle(Locale processLocale, Locale activeLocale, Locale blockSetLocale, Locale blockGetLocale, Locale proxySetLocale, Locale runnableGetBeforeLocale, Locale runnableSetLocale, Locale runnableGetAfterLocale) {
        RunnableProxy p = new RunnableProxy(proxySetLocale, runnableSetLocale);
        ActiveLocale.runWithLocale((Runnable)p, (Locale)blockSetLocale);
        ActiveLocaleTest.checkBasics(processLocale, activeLocale);
        Assert.assertEquals((Object)blockGetLocale, (Object)p.getBeforeActiveLocale());
        Assert.assertEquals((Object)blockGetLocale, (Object)p.getAfterActiveLocale());
        Assert.assertEquals((Object)runnableGetBeforeLocale, (Object)p.getRunnableBase().getBeforeActiveLocale());
        Assert.assertEquals((Object)runnableGetAfterLocale, (Object)p.getRunnableBase().getAfterActiveLocale());
    }

    private static void checkRunnableAll(Locale processLocale, Locale activeLocale) {
        ActiveLocaleTest.checkRunnableSingle(processLocale, activeLocale, Locale.KOREAN, Locale.KOREAN, Locale.JAPANESE, Locale.JAPANESE, Locale.ITALIAN, Locale.ITALIAN);
        ActiveLocaleTest.checkRunnableSingle(processLocale, activeLocale, null, activeLocale, Locale.JAPANESE, Locale.JAPANESE, Locale.ITALIAN, Locale.ITALIAN);
        ActiveLocaleTest.checkRunnableSingle(processLocale, activeLocale, Locale.KOREAN, Locale.KOREAN, null, Locale.KOREAN, Locale.ITALIAN, Locale.ITALIAN);
        ActiveLocaleTest.checkRunnableSingle(processLocale, activeLocale, Locale.KOREAN, Locale.KOREAN, Locale.JAPANESE, Locale.JAPANESE, null, Locale.KOREAN);
        ActiveLocaleTest.checkRunnableSingle(processLocale, activeLocale, Locale.KOREAN, Locale.KOREAN, null, Locale.KOREAN, null, Locale.KOREAN);
        ActiveLocaleTest.checkRunnableSingle(processLocale, activeLocale, null, activeLocale, Locale.JAPANESE, Locale.JAPANESE, null, activeLocale);
        ActiveLocaleTest.checkRunnableSingle(processLocale, activeLocale, null, activeLocale, null, activeLocale, Locale.ITALIAN, Locale.ITALIAN);
        ActiveLocaleTest.checkRunnableSingle(processLocale, activeLocale, null, activeLocale, null, activeLocale, null, activeLocale);
    }

    private static void checkCallableSingle(Locale processLocale, Locale activeLocale, Locale blockSetLocale, Locale blockGetLocale, Locale proxySetLocale, Locale callableGetBeforeLocale, Locale callableSetLocale, Locale callableGetAfterLocale) throws Exception {
        CallableProxy p = new CallableProxy(proxySetLocale, callableSetLocale);
        Assert.assertEquals((long)3L, (long)((Integer)ActiveLocale.runWithLocale((Callable)p, (Locale)blockSetLocale)).intValue());
        ActiveLocaleTest.checkBasics(processLocale, activeLocale);
        Assert.assertEquals((Object)blockGetLocale, (Object)p.getBeforeActiveLocale());
        Assert.assertEquals((Object)blockGetLocale, (Object)p.getAfterActiveLocale());
        Assert.assertEquals((Object)callableGetBeforeLocale, (Object)p.getCallableBase().getBeforeActiveLocale());
        Assert.assertEquals((Object)callableGetAfterLocale, (Object)p.getCallableBase().getAfterActiveLocale());
    }

    private static void checkCallableAll(Locale processLocale, Locale activeLocale) throws Exception {
        ActiveLocaleTest.checkCallableSingle(processLocale, activeLocale, Locale.KOREAN, Locale.KOREAN, Locale.JAPANESE, Locale.JAPANESE, Locale.ITALIAN, Locale.ITALIAN);
        ActiveLocaleTest.checkCallableSingle(processLocale, activeLocale, null, activeLocale, Locale.JAPANESE, Locale.JAPANESE, Locale.ITALIAN, Locale.ITALIAN);
        ActiveLocaleTest.checkCallableSingle(processLocale, activeLocale, Locale.KOREAN, Locale.KOREAN, null, Locale.KOREAN, Locale.ITALIAN, Locale.ITALIAN);
        ActiveLocaleTest.checkCallableSingle(processLocale, activeLocale, Locale.KOREAN, Locale.KOREAN, Locale.JAPANESE, Locale.JAPANESE, null, Locale.KOREAN);
        ActiveLocaleTest.checkCallableSingle(processLocale, activeLocale, Locale.KOREAN, Locale.KOREAN, null, Locale.KOREAN, null, Locale.KOREAN);
        ActiveLocaleTest.checkCallableSingle(processLocale, activeLocale, null, activeLocale, Locale.JAPANESE, Locale.JAPANESE, null, activeLocale);
        ActiveLocaleTest.checkCallableSingle(processLocale, activeLocale, null, activeLocale, null, activeLocale, Locale.ITALIAN, Locale.ITALIAN);
        ActiveLocaleTest.checkCallableSingle(processLocale, activeLocale, null, activeLocale, null, activeLocale, null, activeLocale);
    }

    private static void checkSimpleChildSingle(Locale processLocale, Locale activeLocale, Locale setLocale, Locale getLocale) throws Exception {
        SimpleChildThread t = new SimpleChildThread(setLocale);
        t.start();
        t.join();
        ActiveLocaleTest.checkBasics(processLocale, activeLocale);
        Assert.assertEquals((Object)activeLocale, (Object)t.getBeforeActiveLocale());
        Assert.assertEquals((Object)getLocale, (Object)t.getAfterActiveLocale());
    }

    private static void checkSimpleChildAll(Locale processLocale, Locale activeLocale) throws Exception {
        Locale threadLocale = processLocale == null ? DEFAULT_LOCALE : processLocale;
        ActiveLocaleTest.checkSimpleChildSingle(processLocale, activeLocale, Locale.ITALIAN, Locale.ITALIAN);
        ActiveLocaleTest.checkSimpleChildSingle(processLocale, activeLocale, null, threadLocale);
    }

    private static void checkSimpleChildFromStackSingle(Locale processLocale, Locale activeLocale, Locale blockSetLocale, Locale blockGetLocale, Locale childSetLocale, Locale childGetAfterLocale) {
        SimpleChildThreadProxy p = new SimpleChildThreadProxy(childSetLocale);
        ActiveLocale.runWithLocale((Runnable)p, (Locale)blockSetLocale);
        ActiveLocaleTest.checkBasics(processLocale, activeLocale);
        Assert.assertEquals((Object)blockGetLocale, (Object)p.getBeforeActiveLocale());
        Assert.assertEquals((Object)blockGetLocale, (Object)p.getAfterActiveLocale());
        Assert.assertEquals((Object)blockGetLocale, (Object)p.getSimpleChildThread().getBeforeActiveLocale());
        Assert.assertEquals((Object)childGetAfterLocale, (Object)p.getSimpleChildThread().getAfterActiveLocale());
    }

    private static void checkSimpleChildFromStackAll(Locale processLocale, Locale activeLocale) {
        Locale threadLocale = processLocale == null ? DEFAULT_LOCALE : processLocale;
        ActiveLocaleTest.checkSimpleChildFromStackSingle(processLocale, activeLocale, Locale.KOREAN, Locale.KOREAN, Locale.ITALIAN, Locale.ITALIAN);
        ActiveLocaleTest.checkSimpleChildFromStackSingle(processLocale, activeLocale, null, activeLocale, Locale.ITALIAN, Locale.ITALIAN);
        ActiveLocaleTest.checkSimpleChildFromStackSingle(processLocale, activeLocale, Locale.KOREAN, Locale.KOREAN, null, threadLocale);
        ActiveLocaleTest.checkSimpleChildFromStackSingle(processLocale, activeLocale, null, activeLocale, null, threadLocale);
    }

    private static void checkComplexChildSingle(Locale processLocale, Locale activeLocale, Locale blockSetLocale, Locale blockGetLocale, Locale proxySetLocale, Locale runnableGetBeforeLocale, Locale runnableSetLocale, Locale runnableGetAfterLocale) {
        ComplexChildThreadProxy p = new ComplexChildThreadProxy(proxySetLocale, runnableSetLocale);
        ActiveLocale.runWithLocale((Runnable)p, (Locale)blockSetLocale);
        ActiveLocaleTest.checkBasics(processLocale, activeLocale);
        Assert.assertEquals((Object)blockGetLocale, (Object)p.getBeforeActiveLocale());
        Assert.assertEquals((Object)blockGetLocale, (Object)p.getAfterActiveLocale());
        Assert.assertEquals((Object)blockGetLocale, (Object)p.getComplexChildThread().getBeforeActiveLocale());
        Assert.assertEquals((Object)blockGetLocale, (Object)p.getComplexChildThread().getAfterActiveLocale());
        Assert.assertEquals((Object)runnableGetBeforeLocale, (Object)p.getComplexChildThread().getRunnableBase().getBeforeActiveLocale());
        Assert.assertEquals((Object)runnableGetAfterLocale, (Object)p.getComplexChildThread().getRunnableBase().getAfterActiveLocale());
    }

    private static void checkComplexChildAll(Locale processLocale, Locale activeLocale) {
        ActiveLocaleTest.checkComplexChildSingle(processLocale, activeLocale, Locale.KOREAN, Locale.KOREAN, Locale.JAPANESE, Locale.JAPANESE, Locale.ITALIAN, Locale.ITALIAN);
        ActiveLocaleTest.checkComplexChildSingle(processLocale, activeLocale, null, activeLocale, Locale.JAPANESE, Locale.JAPANESE, Locale.ITALIAN, Locale.ITALIAN);
        ActiveLocaleTest.checkComplexChildSingle(processLocale, activeLocale, Locale.KOREAN, Locale.KOREAN, null, Locale.KOREAN, Locale.ITALIAN, Locale.ITALIAN);
        ActiveLocaleTest.checkComplexChildSingle(processLocale, activeLocale, Locale.KOREAN, Locale.KOREAN, Locale.JAPANESE, Locale.JAPANESE, null, Locale.KOREAN);
        ActiveLocaleTest.checkComplexChildSingle(processLocale, activeLocale, null, activeLocale, null, activeLocale, Locale.ITALIAN, Locale.ITALIAN);
        ActiveLocaleTest.checkComplexChildSingle(processLocale, activeLocale, Locale.KOREAN, Locale.KOREAN, null, Locale.KOREAN, null, Locale.KOREAN);
        ActiveLocaleTest.checkComplexChildSingle(processLocale, activeLocale, null, activeLocale, Locale.JAPANESE, Locale.JAPANESE, null, activeLocale);
        ActiveLocaleTest.checkComplexChildSingle(processLocale, activeLocale, null, activeLocale, null, activeLocale, null, activeLocale);
    }

    @Before
    public void setupActiveLocaleTest() {
        ActiveLocale.clear();
    }

    @Test
    public void basics() {
        ActiveLocaleTest.checkBasics(null, DEFAULT_LOCALE);
        ActiveLocale.setProcessLocale((Locale)Locale.FRENCH);
        ActiveLocaleTest.checkBasics(Locale.FRENCH, Locale.FRENCH);
        ActiveLocale.setThreadLocale((Locale)Locale.GERMAN);
        ActiveLocaleTest.checkBasics(Locale.FRENCH, Locale.GERMAN);
        ActiveLocale.setProcessLocale(null);
        ActiveLocaleTest.checkBasics(null, Locale.GERMAN);
        ActiveLocale.setThreadLocale(null);
        ActiveLocaleTest.checkBasics(null, DEFAULT_LOCALE);
        ActiveLocale.setProcessLocale((Locale)Locale.FRENCH);
        ActiveLocaleTest.checkBasics(Locale.FRENCH, Locale.FRENCH);
        ActiveLocale.pushLocale((Locale)Locale.GERMAN);
        ActiveLocaleTest.checkBasics(Locale.FRENCH, Locale.GERMAN);
        ActiveLocale.pushLocale((Locale)Locale.KOREAN);
        ActiveLocaleTest.checkBasics(Locale.FRENCH, Locale.KOREAN);
        ActiveLocale.pushLocale((Locale)Locale.JAPANESE);
        ActiveLocaleTest.checkBasics(Locale.FRENCH, Locale.JAPANESE);
        ActiveLocale.setThreadLocale((Locale)Locale.ITALIAN);
        ActiveLocaleTest.checkBasics(Locale.FRENCH, Locale.ITALIAN);
        ActiveLocale.setThreadLocale(null);
        ActiveLocaleTest.checkBasics(Locale.FRENCH, Locale.KOREAN);
        ActiveLocale.popLocale();
        ActiveLocaleTest.checkBasics(Locale.FRENCH, Locale.KOREAN);
        ActiveLocale.popLocale();
        ActiveLocaleTest.checkBasics(Locale.FRENCH, Locale.GERMAN);
        ActiveLocale.popLocale();
        ActiveLocaleTest.checkBasics(Locale.FRENCH, Locale.FRENCH);
        ActiveLocale.setProcessLocale(null);
        ActiveLocaleTest.checkBasics(null, DEFAULT_LOCALE);
    }

    @Test
    public void runnable() {
        ActiveLocaleTest.checkRunnableAll(null, DEFAULT_LOCALE);
        ActiveLocale.setProcessLocale((Locale)Locale.FRENCH);
        ActiveLocaleTest.checkRunnableAll(Locale.FRENCH, Locale.FRENCH);
        ActiveLocale.setThreadLocale((Locale)Locale.GERMAN);
        ActiveLocaleTest.checkRunnableAll(Locale.FRENCH, Locale.GERMAN);
        ActiveLocale.setProcessLocale(null);
        ActiveLocaleTest.checkRunnableAll(null, Locale.GERMAN);
    }

    @Test
    public void callable() throws Exception {
        ActiveLocaleTest.checkCallableAll(null, DEFAULT_LOCALE);
        ActiveLocale.setProcessLocale((Locale)Locale.FRENCH);
        ActiveLocaleTest.checkCallableAll(Locale.FRENCH, Locale.FRENCH);
        ActiveLocale.setThreadLocale((Locale)Locale.GERMAN);
        ActiveLocaleTest.checkCallableAll(Locale.FRENCH, Locale.GERMAN);
        ActiveLocale.setProcessLocale(null);
        ActiveLocaleTest.checkCallableAll(null, Locale.GERMAN);
    }

    @Test
    public void simpleChild() throws Exception {
        ActiveLocaleTest.checkSimpleChildAll(null, DEFAULT_LOCALE);
        ActiveLocale.setProcessLocale((Locale)Locale.FRENCH);
        ActiveLocaleTest.checkSimpleChildAll(Locale.FRENCH, Locale.FRENCH);
        ActiveLocale.setThreadLocale((Locale)Locale.GERMAN);
        ActiveLocaleTest.checkSimpleChildAll(Locale.FRENCH, Locale.GERMAN);
        ActiveLocale.setProcessLocale(null);
        ActiveLocaleTest.checkSimpleChildAll(null, Locale.GERMAN);
    }

    @Test
    public void simpleChildFromStack() {
        ActiveLocaleTest.checkSimpleChildFromStackAll(null, DEFAULT_LOCALE);
        ActiveLocale.setProcessLocale((Locale)Locale.FRENCH);
        ActiveLocaleTest.checkSimpleChildFromStackAll(Locale.FRENCH, Locale.FRENCH);
        ActiveLocale.setThreadLocale((Locale)Locale.GERMAN);
        ActiveLocaleTest.checkSimpleChildFromStackAll(Locale.FRENCH, Locale.GERMAN);
        ActiveLocale.setProcessLocale(null);
        ActiveLocaleTest.checkSimpleChildFromStackAll(null, Locale.GERMAN);
    }

    @Test
    public void complexChild() {
        ActiveLocaleTest.checkComplexChildAll(null, DEFAULT_LOCALE);
        ActiveLocale.setProcessLocale((Locale)Locale.FRENCH);
        ActiveLocaleTest.checkComplexChildAll(Locale.FRENCH, Locale.FRENCH);
        ActiveLocale.setThreadLocale((Locale)Locale.GERMAN);
        ActiveLocaleTest.checkComplexChildAll(Locale.FRENCH, Locale.GERMAN);
        ActiveLocale.setProcessLocale(null);
        ActiveLocaleTest.checkComplexChildAll(null, Locale.GERMAN);
    }

    private static final class ComplexChildThreadProxy
    extends LocaleHolder
    implements Runnable {
        private Locale mSelfSetLocale;
        private Locale mRunnableBaseSetLocale;
        private ComplexChildThread mComplexChildThread;

        ComplexChildThreadProxy(Locale selfSetLocale, Locale runnableBaseSetLocale) {
            this.mSelfSetLocale = selfSetLocale;
            this.mRunnableBaseSetLocale = runnableBaseSetLocale;
        }

        ComplexChildThread getComplexChildThread() {
            return this.mComplexChildThread;
        }

        @Override
        public void run() {
            this.setBeforeActiveLocale();
            this.mComplexChildThread = new ComplexChildThread(this.mSelfSetLocale, this.mRunnableBaseSetLocale);
            this.getComplexChildThread().start();
            try {
                this.getComplexChildThread().join();
            }
            catch (InterruptedException ex) {
                Assert.fail();
            }
            this.setAfterActiveLocale();
        }
    }

    private static final class ComplexChildThread
    extends LocaleHolderThread {
        private Locale mSelfSetLocale;
        private Locale mRunnableBaseSetLocale;
        private RunnableBase mRunnableBase;

        ComplexChildThread(Locale selfSetLocale, Locale runnableBaseSetLocale) {
            this.mSelfSetLocale = selfSetLocale;
            this.mRunnableBaseSetLocale = runnableBaseSetLocale;
        }

        RunnableBase getRunnableBase() {
            return this.mRunnableBase;
        }

        @Override
        public void run() {
            this.setBeforeActiveLocale();
            this.mRunnableBase = new RunnableBase(this.mRunnableBaseSetLocale);
            ActiveLocale.runWithLocale((Runnable)this.getRunnableBase(), (Locale)this.mSelfSetLocale);
            this.setAfterActiveLocale();
        }
    }

    private static final class SimpleChildThreadProxy
    extends LocaleHolder
    implements Runnable {
        private Locale mSetLocale;
        private SimpleChildThread mSimpleChildThread;

        SimpleChildThreadProxy(Locale setLocale) {
            this.mSetLocale = setLocale;
        }

        SimpleChildThread getSimpleChildThread() {
            return this.mSimpleChildThread;
        }

        @Override
        public void run() {
            this.setBeforeActiveLocale();
            this.mSimpleChildThread = new SimpleChildThread(this.mSetLocale);
            this.getSimpleChildThread().start();
            try {
                this.getSimpleChildThread().join();
            }
            catch (InterruptedException ex) {
                Assert.fail();
            }
            this.setAfterActiveLocale();
        }
    }

    private static final class SimpleChildThread
    extends LocaleHolderThread {
        private Locale mSetLocale;

        SimpleChildThread(Locale setLocale) {
            this.mSetLocale = setLocale;
        }

        @Override
        public void run() {
            this.setBeforeActiveLocale();
            ActiveLocale.setThreadLocale((Locale)this.mSetLocale);
            this.setAfterActiveLocale();
        }
    }

    private static class LocaleHolderThread
    extends Thread {
        private Locale mBeforeActiveLocale;
        private Locale mAfterActiveLocale;

        private LocaleHolderThread() {
        }

        Locale getBeforeActiveLocale() {
            return this.mBeforeActiveLocale;
        }

        Locale getAfterActiveLocale() {
            return this.mAfterActiveLocale;
        }

        protected void setBeforeActiveLocale() {
            this.mBeforeActiveLocale = ActiveLocale.getLocale();
        }

        protected void setAfterActiveLocale() {
            this.mAfterActiveLocale = ActiveLocale.getLocale();
        }
    }

    private static final class CallableProxy
    extends LocaleHolder
    implements Callable<Integer> {
        private Locale mSelfSetLocale;
        private Locale mCallableBaseSetLocale;
        private CallableBase mCallableBase;

        CallableProxy(Locale selfSetLocale, Locale callableBaseSetLocale) {
            this.mSelfSetLocale = selfSetLocale;
            this.mCallableBaseSetLocale = callableBaseSetLocale;
        }

        CallableBase getCallableBase() {
            return this.mCallableBase;
        }

        @Override
        public Integer call() throws Exception {
            this.setBeforeActiveLocale();
            this.mCallableBase = new CallableBase(this.mCallableBaseSetLocale);
            int result = (Integer)ActiveLocale.runWithLocale((Callable)this.getCallableBase(), (Locale)this.mSelfSetLocale);
            this.setAfterActiveLocale();
            return result + 2;
        }
    }

    private static final class RunnableProxy
    extends LocaleHolder
    implements Runnable {
        private Locale mSelfSetLocale;
        private Locale mRunnableBaseSetLocale;
        private RunnableBase mRunnableBase;

        RunnableProxy(Locale selfSetLocale, Locale runnableBaseSetLocale) {
            this.mSelfSetLocale = selfSetLocale;
            this.mRunnableBaseSetLocale = runnableBaseSetLocale;
        }

        RunnableBase getRunnableBase() {
            return this.mRunnableBase;
        }

        @Override
        public void run() {
            this.setBeforeActiveLocale();
            this.mRunnableBase = new RunnableBase(this.mRunnableBaseSetLocale);
            ActiveLocale.runWithLocale((Runnable)this.getRunnableBase(), (Locale)this.mSelfSetLocale);
            this.setAfterActiveLocale();
        }
    }

    private static final class CallableBase
    extends LocaleHolder
    implements Callable<Integer> {
        private Locale mSetLocale;

        CallableBase(Locale setLocale) {
            this.mSetLocale = setLocale;
        }

        @Override
        public Integer call() {
            this.setBeforeActiveLocale();
            ActiveLocale.setThreadLocale((Locale)this.mSetLocale);
            this.setAfterActiveLocale();
            return 1;
        }
    }

    private static final class RunnableBase
    extends LocaleHolder
    implements Runnable {
        private Locale mSetLocale;

        RunnableBase(Locale setLocale) {
            this.mSetLocale = setLocale;
        }

        @Override
        public void run() {
            this.setBeforeActiveLocale();
            ActiveLocale.setThreadLocale((Locale)this.mSetLocale);
            this.setAfterActiveLocale();
        }
    }

    private static class LocaleHolder {
        private Locale mBeforeActiveLocale;
        private Locale mAfterActiveLocale;

        private LocaleHolder() {
        }

        Locale getBeforeActiveLocale() {
            return this.mBeforeActiveLocale;
        }

        Locale getAfterActiveLocale() {
            return this.mAfterActiveLocale;
        }

        protected void setBeforeActiveLocale() {
            this.mBeforeActiveLocale = ActiveLocale.getLocale();
        }

        protected void setAfterActiveLocale() {
            this.mAfterActiveLocale = ActiveLocale.getLocale();
        }
    }
}

