/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.log;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import org.apache.commons.lang.SerializationException;
import org.apache.commons.lang.SerializationUtils;
import org.apache.log4j.Level;
import org.apache.log4j.spi.LoggingEvent;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.marketcetera.util.log.ActiveLocale;
import org.marketcetera.util.log.I18NLoggerProxy;
import org.marketcetera.util.log.I18NMessage;
import org.marketcetera.util.log.I18NMessage0P;
import org.marketcetera.util.log.I18NMessage1P;
import org.marketcetera.util.log.I18NMessageProvider;
import org.marketcetera.util.log.TestMessages;
import org.marketcetera.util.test.EqualityAssert;
import org.marketcetera.util.test.SerializableAssert;
import org.marketcetera.util.test.TestCaseBase;

public class I18NMessageProviderTest
extends TestCaseBase {
    private static final String TEST_CATEGORY;
    private static final String TEST_LOCATION;
    private static final String TEST_MEM_PROVIDER = "classloader_prv";

    @Before
    public void setupI18NMessageProviderTest() {
        ActiveLocale.setProcessLocale((Locale)Locale.ROOT);
        I18NMessageProviderTest.setLevel((String)TEST_CATEGORY, (Level)Level.ERROR);
    }

    @Test
    public void idIsValid() {
        Assert.assertEquals((Object)"a", (Object)new I18NMessageProvider("a").getProviderId());
    }

    @Test
    public void equality() {
        EqualityAssert.assertEquality((Object)new I18NMessageProvider("a"), (Object)new I18NMessageProvider("a"), (Object[])new Object[]{new I18NMessageProvider("b")});
        SerializableAssert.assertSerializable((Serializable)TestMessages.PROVIDER);
    }

    @Test
    public void deserialization() {
        byte[] serialized = SerializationUtils.serialize((Serializable)new I18NMessageProvider("nonexistent_prv"));
        try {
            SerializationUtils.deserialize((byte[])serialized);
            Assert.fail();
        }
        catch (SerializationException ex) {
            Assert.assertEquals(IOException.class, ex.getCause().getClass());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void retrievals() {
        Assert.assertEquals((Object)"Hello", (Object)TestMessages.PROVIDER.getText((I18NMessage)TestMessages.HELLO_MSG, new Object[0]));
        Assert.assertEquals((Object)"Hello World!", (Object)TestMessages.PROVIDER.getText((I18NMessage)TestMessages.HELLO_TITLE, new Object[]{"World"}));
        Assert.assertEquals((Object)"Bonjour", (Object)TestMessages.PROVIDER.getText(Locale.FRENCH, (I18NMessage)TestMessages.HELLO_MSG, new Object[0]));
        Assert.assertEquals((Object)"Bonjour Le Monde!", (Object)TestMessages.PROVIDER.getText(Locale.FRENCH, (I18NMessage)TestMessages.HELLO_TITLE, new Object[]{"Le Monde"}));
        Locale saved = Locale.getDefault();
        try {
            Locale.setDefault(Locale.ROOT);
            Assert.assertEquals((Object)"Hello", (Object)TestMessages.PROVIDER.getText(Locale.GERMAN, (I18NMessage)TestMessages.HELLO_MSG, new Object[0]));
            Locale.setDefault(Locale.JAPANESE);
            Assert.assertEquals((Object)"Hello", (Object)TestMessages.PROVIDER.getText(Locale.GERMAN, (I18NMessage)TestMessages.HELLO_MSG, new Object[0]));
            Locale.setDefault(Locale.FRENCH);
            Assert.assertEquals((Object)"Bonjour", (Object)TestMessages.PROVIDER.getText(Locale.GERMAN, (I18NMessage)TestMessages.HELLO_MSG, new Object[0]));
        }
        finally {
            Locale.setDefault(saved);
        }
        Assert.assertEquals((Object)"Hello a {0} 'a' \"a\" b!", (Object)TestMessages.PROVIDER.getText((I18NMessage)TestMessages.HELLO_ECHO, new Object[]{"a", "b"}));
        Assert.assertEquals((Object)"Bonjour a {0} 'a' \"a\" {1}!", (Object)TestMessages.PROVIDER.getText(Locale.FRENCH, (I18NMessage)TestMessages.HELLO_ECHO, new Object[]{"a"}));
        Assert.assertEquals((Object)"Bonjour a {0} 'a' \"a\" b!", (Object)TestMessages.PROVIDER.getText(Locale.FRENCH, (I18NMessage)TestMessages.HELLO_ECHO, new Object[]{"a", "b", "c"}));
        Assert.assertEquals((Object)"There are no orders ma'am.", (Object)TestMessages.PROVIDER.getText((I18NMessage)TestMessages.CHOICE_MSG, new Object[]{0}));
        Assert.assertEquals((Object)"There is just one order ma'am.", (Object)TestMessages.PROVIDER.getText((I18NMessage)TestMessages.CHOICE_MSG, new Object[]{1}));
        Assert.assertEquals((Object)"There are 2 orders ma'am.", (Object)TestMessages.PROVIDER.getText((I18NMessage)TestMessages.CHOICE_MSG, new Object[]{2}));
        Assert.assertEquals((Object)"Pas des ordres ma'am.", (Object)TestMessages.PROVIDER.getText(Locale.FRENCH, (I18NMessage)TestMessages.CHOICE_MSG, new Object[]{0}));
        Assert.assertEquals((Object)"Seulemont un ordre ma'am.", (Object)TestMessages.PROVIDER.getText(Locale.FRENCH, (I18NMessage)TestMessages.CHOICE_MSG, new Object[]{1}));
        Assert.assertEquals((Object)"Il y a 2 ordres ma'am.", (Object)TestMessages.PROVIDER.getText(Locale.FRENCH, (I18NMessage)TestMessages.CHOICE_MSG, new Object[]{2}));
        Assert.assertEquals((Object)"Hello {0}!", (Object)TestMessages.PROVIDER.getText((I18NMessage)TestMessages.HELLO_TITLE, (Object[])null));
        Assert.assertEquals((Object)"Hello null!", (Object)TestMessages.PROVIDER.getText((I18NMessage)TestMessages.HELLO_TITLE, new Object[]{null}));
        ActiveLocale.setProcessLocale((Locale)Locale.FRENCH);
        Assert.assertEquals((Object)"Bonjour", (Object)TestMessages.PROVIDER.getText((I18NMessage)TestMessages.HELLO_MSG, new Object[0]));
        Assert.assertEquals((Object)"Bonjour Le Monde!", (Object)TestMessages.PROVIDER.getText((I18NMessage)TestMessages.HELLO_TITLE, new Object[]{"Le Monde"}));
    }

    @Test
    public void nonexistentMappingFile() {
        I18NMessageProvider provider = new I18NMessageProvider("nonexistent_prv");
        Iterator events = this.getAppender().getEvents().iterator();
        I18NMessageProviderTest.assertEvent((LoggingEvent)((LoggingEvent)events.next()), (Level)Level.ERROR, (String)TEST_CATEGORY, (String)"Message file missing: provider 'nonexistent_prv'; base name 'nonexistent_prv_messages'", (String)TEST_LOCATION);
        I18NMessageProviderTest.assertEvent((LoggingEvent)((LoggingEvent)events.next()), (Level)Level.ERROR, (String)TEST_CATEGORY, (String)"Abnormal exception: stack trace", (String)TEST_LOCATION);
        Assert.assertFalse((boolean)events.hasNext());
        this.getAppender().clear();
        Assert.assertEquals((Object)"provider 'nonexistent_prv'; id 'nonexistent_msg'; entry 'msg'; parameters ()", (Object)provider.getText((I18NMessage)TestMessages.NONEXISTENT, new Object[0]));
        this.assertSingleEvent(Level.ERROR, TEST_CATEGORY, "Message not found: provider 'nonexistent_prv'; id 'nonexistent_msg'; entry 'msg'; parameters ()", TEST_LOCATION);
    }

    @Test
    public void nonexistentMessage() {
        Assert.assertEquals((Object)"provider 'util_log_test'; id 'nonexistent_msg'; entry 'msg'; parameters ('a')", (Object)TestMessages.PROVIDER.getText((I18NMessage)TestMessages.NONEXISTENT, new Object[]{"a"}));
        this.assertSingleEvent(Level.ERROR, TEST_CATEGORY, "Message not found: provider 'util_log_test'; id 'nonexistent_msg'; entry 'msg'; parameters ('a')", TEST_LOCATION);
        ActiveLocale.setProcessLocale((Locale)Locale.FRENCH);
        Assert.assertEquals((Object)"provider 'util_log_test'; id 'nonexistent_msg'; entry 'msg'; parameters ('a')", (Object)TestMessages.PROVIDER.getText((I18NMessage)TestMessages.NONEXISTENT, new Object[]{"a"}));
        this.assertSingleEvent(Level.ERROR, TEST_CATEGORY, "Message n'a pas \u00e9t\u00e9 trouv\u00e9e: fournisseur 'util_log_test'; identit\u00e9 'nonexistent_msg'; entr\u00e9e 'msg'; param\u00e8tres ('a')", TEST_LOCATION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void customClassLoader() throws Exception {
        I18NMessageProvider provider = new I18NMessageProvider(TEST_MEM_PROVIDER);
        Iterator events = this.getAppender().getEvents().iterator();
        I18NMessageProviderTest.assertEvent((LoggingEvent)((LoggingEvent)events.next()), (Level)Level.ERROR, (String)TEST_CATEGORY, (String)"Message file missing: provider 'classloader_prv'; base name 'classloader_prv_messages'", (String)TEST_LOCATION);
        I18NMessageProviderTest.assertEvent((LoggingEvent)((LoggingEvent)events.next()), (Level)Level.ERROR, (String)TEST_CATEGORY, (String)"Abnormal exception: stack trace", (String)TEST_LOCATION);
        Assert.assertFalse((boolean)events.hasNext());
        this.getAppender().clear();
        Properties messages = new Properties();
        messages.put("hello.msg", "Hello");
        messages.put("hello.title", "Hello {0}!");
        try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
            messages.store(output, "");
        }
        final byte[] inputStream = output.toByteArray();
        String propertiesName = "classloader_prv_messages.properties";
        provider = new I18NMessageProvider(TEST_MEM_PROVIDER, new ClassLoader(){

            @Override
            public InputStream getResourceAsStream(String name) {
                if ("classloader_prv_messages.properties".equals(name)) {
                    return new ByteArrayInputStream(inputStream);
                }
                return super.getResourceAsStream(name);
            }
        });
        this.assertNoEvents();
        I18NLoggerProxy logger = new I18NLoggerProxy(provider);
        I18NMessage0P helloMsg = new I18NMessage0P(logger, "hello");
        I18NMessage1P helloTitle = new I18NMessage1P(logger, "hello", "title");
        Locale saved = Locale.getDefault();
        try {
            Locale.setDefault(Locale.ROOT);
            Assert.assertEquals((Object)"Hello", (Object)provider.getText((I18NMessage)helloMsg, new Object[0]));
            Assert.assertEquals((Object)"Hello World!", (Object)provider.getText((I18NMessage)helloTitle, new Object[]{"World"}));
        }
        finally {
            Locale.setDefault(saved);
        }
    }

    static {
        TEST_LOCATION = TEST_CATEGORY = I18NMessageProvider.class.getName();
    }
}

