/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.log;

import java.io.Serializable;
import java.util.Locale;
import org.apache.log4j.Level;
import org.junit.Assert;
import org.junit.Test;
import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.log.I18NBoundMessage0P;
import org.marketcetera.util.log.I18NBoundMessage1P;
import org.marketcetera.util.log.I18NMessage;
import org.marketcetera.util.log.I18NMessage0P;
import org.marketcetera.util.log.I18NMessage1P;
import org.marketcetera.util.log.I18NMessageTestBase;
import org.marketcetera.util.log.TestMessages;

public class TI18NMessage0PTest
extends I18NMessageTestBase {
    private static final String TEST_MSG_EN = "P0 msg (expected) en";
    private static final String TEST_TTL_EN = "P0 ttl (expected) en";
    private static final String TEST_MSG_FR = "P0 msg (expected) fr";
    private static final String TEST_TTL_FR = "P0 ttl (expected) fr";
    private static final String TEST_LOCATION = TI18NMessage0PTest.class.getName();

    private static void castOverride(I18NMessage0P m) {
    }

    protected void boundTests0P(I18NBoundMessage msg, I18NBoundMessage msgCopy, I18NBoundMessage ttl, I18NBoundMessage ttlCopy) {
        this.boundTests(msg, msgCopy, new I18NBoundMessage[]{ttl, new I18NBoundMessage1P(TestMessages.P1_MSG, (Serializable)((Object)"1"))}, I18NBoundMessage.EMPTY_PARAMS, (I18NMessage)TestMessages.P0_MSG, TEST_MSG_EN, TEST_MSG_FR);
        this.boundTests(ttl, ttlCopy, new I18NBoundMessage[]{msg, new I18NBoundMessage1P(TestMessages.P1_MSG, (Serializable)((Object)"1"))}, I18NBoundMessage.EMPTY_PARAMS, (I18NMessage)TestMessages.P0_TTL, TEST_TTL_EN, TEST_TTL_FR);
    }

    @Test
    public void basic() {
        TI18NMessage0PTest.unboundTests(0, (I18NMessage)new I18NMessage0P(TestMessages.LOGGER, "base", "ttl"), (I18NMessage)new I18NMessage0P(TestMessages.LOGGER, "base", "ttl"), new I18NMessage[]{new I18NMessage0P(TEST_LOGGER_D, "base", "ttl"), new I18NMessage0P(TestMessages.LOGGER, "baseD", "ttl"), new I18NMessage0P(TestMessages.LOGGER, "base", "ttlD"), new I18NMessage1P(TestMessages.LOGGER, "base", "ttl")}, (I18NMessage)new I18NMessage0P(TestMessages.LOGGER, "base"));
    }

    @Test
    public void messageProvider() {
        Assert.assertEquals((Object)TEST_MSG_EN, (Object)TestMessages.P0_MSG.getText());
        Assert.assertEquals((Object)TEST_TTL_EN, (Object)TestMessages.P0_TTL.getText());
        Assert.assertEquals((Object)TEST_MSG_FR, (Object)TestMessages.P0_MSG.getText(Locale.FRENCH));
        Assert.assertEquals((Object)TEST_TTL_FR, (Object)TestMessages.P0_TTL.getText(Locale.FRENCH));
    }

    @Test
    public void loggerProxy() {
        TestMessages.P0_MSG.error((Object)"TestCategory", (Throwable)TEST_THROWABLE);
        this.assertSingleEvent(Level.ERROR, "TestCategory", TEST_MSG_EN, TEST_LOCATION);
        TestMessages.P0_MSG.error((Object)"TestCategory");
        this.assertSingleEvent(Level.ERROR, "TestCategory", TEST_MSG_EN, TEST_LOCATION);
        TestMessages.P0_TTL.error((Object)"TestCategory", (Throwable)TEST_THROWABLE);
        this.assertSingleEvent(Level.ERROR, "TestCategory", TEST_TTL_EN, TEST_LOCATION);
        TestMessages.P0_TTL.error((Object)"TestCategory");
        this.assertSingleEvent(Level.ERROR, "TestCategory", TEST_TTL_EN, TEST_LOCATION);
        TestMessages.P0_MSG.warn((Object)"TestCategory", (Throwable)TEST_THROWABLE);
        this.assertSingleEvent(Level.WARN, "TestCategory", TEST_MSG_EN, TEST_LOCATION);
        TestMessages.P0_MSG.warn((Object)"TestCategory");
        this.assertSingleEvent(Level.WARN, "TestCategory", TEST_MSG_EN, TEST_LOCATION);
        TestMessages.P0_TTL.warn((Object)"TestCategory", (Throwable)TEST_THROWABLE);
        this.assertSingleEvent(Level.WARN, "TestCategory", TEST_TTL_EN, TEST_LOCATION);
        TestMessages.P0_TTL.warn((Object)"TestCategory");
        this.assertSingleEvent(Level.WARN, "TestCategory", TEST_TTL_EN, TEST_LOCATION);
        TestMessages.P0_MSG.info((Object)"TestCategory", (Throwable)TEST_THROWABLE);
        this.assertSingleEvent(Level.INFO, "TestCategory", TEST_MSG_EN, TEST_LOCATION);
        TestMessages.P0_MSG.info((Object)"TestCategory");
        this.assertSingleEvent(Level.INFO, "TestCategory", TEST_MSG_EN, TEST_LOCATION);
        TestMessages.P0_TTL.info((Object)"TestCategory", (Throwable)TEST_THROWABLE);
        this.assertSingleEvent(Level.INFO, "TestCategory", TEST_TTL_EN, TEST_LOCATION);
        TestMessages.P0_TTL.info((Object)"TestCategory");
        this.assertSingleEvent(Level.INFO, "TestCategory", TEST_TTL_EN, TEST_LOCATION);
        TestMessages.P0_MSG.debug((Object)"TestCategory", (Throwable)TEST_THROWABLE);
        this.assertSingleEvent(Level.DEBUG, "TestCategory", TEST_MSG_EN, TEST_LOCATION);
        TestMessages.P0_MSG.debug((Object)"TestCategory");
        this.assertSingleEvent(Level.DEBUG, "TestCategory", TEST_MSG_EN, TEST_LOCATION);
        TestMessages.P0_TTL.debug((Object)"TestCategory", (Throwable)TEST_THROWABLE);
        this.assertSingleEvent(Level.DEBUG, "TestCategory", TEST_TTL_EN, TEST_LOCATION);
        TestMessages.P0_TTL.debug((Object)"TestCategory");
        this.assertSingleEvent(Level.DEBUG, "TestCategory", TEST_TTL_EN, TEST_LOCATION);
        TestMessages.P0_MSG.trace((Object)"TestCategory", (Throwable)TEST_THROWABLE);
        this.assertSingleEvent(Level.TRACE, "TestCategory", TEST_MSG_EN, TEST_LOCATION);
        TestMessages.P0_MSG.trace((Object)"TestCategory");
        this.assertSingleEvent(Level.TRACE, "TestCategory", TEST_MSG_EN, TEST_LOCATION);
        TestMessages.P0_TTL.trace((Object)"TestCategory", (Throwable)TEST_THROWABLE);
        this.assertSingleEvent(Level.TRACE, "TestCategory", TEST_TTL_EN, TEST_LOCATION);
        TestMessages.P0_TTL.trace((Object)"TestCategory");
        this.assertSingleEvent(Level.TRACE, "TestCategory", TEST_TTL_EN, TEST_LOCATION);
    }

    @Test
    public void bound() {
        this.boundTests0P((I18NBoundMessage)TestMessages.P0_MSG, (I18NBoundMessage)TestMessages.P0_MSG_COPY, (I18NBoundMessage)TestMessages.P0_TTL, (I18NBoundMessage)TestMessages.P0_TTL_COPY);
        I18NBoundMessage0P msg = new I18NBoundMessage0P(TestMessages.P0_MSG);
        I18NBoundMessage0P ttl = new I18NBoundMessage0P(TestMessages.P0_TTL);
        this.boundTests0P((I18NBoundMessage)msg, (I18NBoundMessage)new I18NBoundMessage0P(TestMessages.P0_MSG), (I18NBoundMessage)ttl, (I18NBoundMessage)new I18NBoundMessage0P(TestMessages.P0_TTL));
        Assert.assertFalse((boolean)TestMessages.P0_MSG.equals((Object)msg));
        Assert.assertFalse((boolean)msg.equals((Object)TestMessages.P0_MSG));
        Assert.assertFalse((boolean)TestMessages.P0_TTL.equals((Object)ttl));
        Assert.assertFalse((boolean)ttl.equals((Object)TestMessages.P0_TTL));
        TI18NMessage0PTest.castOverride((I18NMessage0P)msg.getMessage());
    }
}

