/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.misc;

import java.util.Arrays;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.junit.Assert;
import org.junit.Test;
import org.marketcetera.util.misc.CollectionUtils;
import org.marketcetera.util.test.TestCaseBase;

public class CollectionUtilsTest
extends TestCaseBase {
    @Test
    public void getLastNonNull() {
        Assert.assertNull((Object)CollectionUtils.getLastNonNull(null));
        Assert.assertNull((Object)CollectionUtils.getLastNonNull(Arrays.asList(new Integer[0])));
        Assert.assertNull((Object)CollectionUtils.getLastNonNull(Arrays.asList(new Integer[]{null})));
        Assert.assertEquals((Object)NumberUtils.INTEGER_ONE, (Object)CollectionUtils.getLastNonNull(Arrays.asList(1)));
        Assert.assertEquals((Object)NumberUtils.INTEGER_ONE, (Object)CollectionUtils.getLastNonNull(Arrays.asList(2, null, 1, null)));
        Assert.assertEquals((Object)NumberUtils.INTEGER_ONE, (Object)CollectionUtils.getLastNonNull(Arrays.asList(2, null, null, 1)));
        Assert.assertEquals((Object)NumberUtils.INTEGER_ONE, (Object)CollectionUtils.getLastNonNull(Arrays.asList(1, null, null)));
    }

    @Test
    public void toArray() {
        Assert.assertNull((Object)CollectionUtils.toArray(null));
        Assert.assertArrayEquals((int[])ArrayUtils.EMPTY_INT_ARRAY, (int[])CollectionUtils.toArray(Arrays.asList(new Integer[0])));
        Assert.assertArrayEquals((int[])ArrayUtils.EMPTY_INT_ARRAY, (int[])CollectionUtils.toArray(Arrays.asList(new Integer[]{null})));
        Assert.assertArrayEquals((int[])new int[]{1}, (int[])CollectionUtils.toArray(Arrays.asList(1)));
        Assert.assertArrayEquals((int[])new int[]{1, 2}, (int[])CollectionUtils.toArray(Arrays.asList(null, 1, null, 2, null)));
    }
}

