/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.misc;

import java.nio.charset.Charset;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.marketcetera.util.misc.RandomStrings;
import org.marketcetera.util.misc.StringUtils;
import org.marketcetera.util.misc.UCPFilter;
import org.marketcetera.util.test.TestCaseBase;
import org.marketcetera.util.unicode.UnicodeCharset;

public class RandomStringsTest
extends TestCaseBase {
    private static final int RANDOM_ITERATION_COUNT = 100;
    private static final int CHAR_ITERATION_COUNT = 100;
    private static final int STR_LEN = 20;
    private static final int STR_LEN_ITERATION_COUNT = 100;
    private static final int STR_ITERATION_COUNT = 100;
    private static final UCPFilter UCP_FILTER_CUSTOM = new UCPFilter(){

        public boolean isAcceptable(int ucp) {
            return ucp >= 256 && ucp <= 258;
        }
    };
    public static final UCPFilter UCP_FILTER_ALL = new UCPFilter(){

        public boolean isAcceptable(int ucp) {
            return ucp >= 0 && ucp <= 0x10FFFF;
        }
    };
    public static final UCPFilter UCP_FILTER_UTF8 = UCPFilter.forCharset((Charset)UnicodeCharset.UTF8.getCharset());
    public static final UCPFilter UCP_FILTER_DC = UCPFilter.getDefaultCharset();
    public static final UCPFilter UCP_FILTER_FS = UCPFilter.getFileSystemCharset();

    private static void testUCP(UCPGenerator generator, UCPFilter checker) {
        int ucpFirst = generator.generate();
        boolean foundDifferent = false;
        for (int i = 0; i < 100; ++i) {
            int ucp = generator.generate();
            Assert.assertTrue((String)("Value was " + Integer.toHexString(ucp)), (boolean)checker.isAcceptable(ucp));
            if (ucp == ucpFirst) continue;
            foundDifferent = true;
        }
        Assert.assertTrue((boolean)foundDifferent);
    }

    private static void testStrLen(StrGenerator generator, UCPFilter checker) {
        String sFirst = generator.generate();
        boolean foundDifferent = false;
        for (int i = 0; i < 100; ++i) {
            String s = generator.generate();
            int[] ucps = StringUtils.toUCPArray((String)s);
            Assert.assertEquals((long)20L, (long)ucps.length);
            for (int ucp : ucps) {
                Assert.assertTrue((String)("Value was " + Integer.toHexString(ucp)), (boolean)checker.isAcceptable(ucp));
            }
            if (s.equals(sFirst)) continue;
            foundDifferent = true;
        }
        Assert.assertTrue((boolean)foundDifferent);
    }

    private static void testStr(int minLen, int maxLen, StrGenerator generator, UCPFilter checker) {
        String sFirst = generator.generate();
        boolean foundDifferent = false;
        for (int i = 0; i < 100; ++i) {
            String s = generator.generate();
            int[] ucps = StringUtils.toUCPArray((String)s);
            Assert.assertTrue((String)("Length is " + ucps.length), (ucps.length >= minLen && ucps.length <= maxLen ? 1 : 0) != 0);
            for (int ucp : ucps) {
                Assert.assertTrue((String)("Value was " + Integer.toHexString(ucp)), (boolean)checker.isAcceptable(ucp));
            }
            if (s.equals(sFirst)) continue;
            foundDifferent = true;
        }
        Assert.assertTrue((boolean)foundDifferent);
    }

    private static void testStrId(int len, String s) {
        int[] ucps = StringUtils.toUCPArray((String)s);
        Assert.assertEquals((long)len, (long)ucps.length);
        if (len >= 1) {
            Assert.assertTrue((String)("Value was " + Integer.toHexString(ucps[0])), (boolean)Character.isLetter(ucps[0]));
        }
        if (len >= 2) {
            Assert.assertTrue((String)("Value was " + Integer.toHexString(ucps[1])), (boolean)Character.isDigit(ucps[1]));
        }
        for (int i = 2; i < len; ++i) {
            Assert.assertTrue((String)("Value was " + Integer.toHexString(ucps[i])), (boolean)Character.isLetterOrDigit(ucps[i]));
        }
    }

    @Before
    public void setupRandomStringsTest() {
        RandomStrings.resetGeneratorFixed();
    }

    @Test
    public void reset() {
        int i;
        int ucp = RandomStrings.genUCP();
        for (int i2 = 0; i2 < 100; ++i2) {
            RandomStrings.resetGeneratorFixed();
            Assert.assertEquals((long)ucp, (long)RandomStrings.genUCP());
        }
        long seed = RandomStrings.resetGeneratorRandom();
        ucp = RandomStrings.genUCP();
        for (int i3 = 0; i3 < 100; ++i3) {
            RandomStrings.resetGeneratorRandom((long)seed);
            Assert.assertEquals((long)ucp, (long)RandomStrings.genUCP());
        }
        boolean failure = true;
        seed = RandomStrings.resetGeneratorRandom();
        for (i = 0; i < 100; ++i) {
            if (seed == RandomStrings.resetGeneratorRandom()) continue;
            failure = false;
            break;
        }
        if (failure) {
            Assert.fail((String)"Cannot create random seed");
        }
        failure = true;
        RandomStrings.resetGeneratorRandom();
        ucp = RandomStrings.genUCP();
        for (i = 0; i < 100; ++i) {
            RandomStrings.resetGeneratorRandom();
            if (ucp == RandomStrings.genUCP()) continue;
            failure = false;
            break;
        }
        if (failure) {
            Assert.fail((String)"Cannot produce random numbers");
        }
    }

    @Test
    public void genUCP() {
        RandomStringsTest.testUCP(new UCPGenerator(){

            @Override
            public int generate() {
                return RandomStrings.genUCP();
            }
        }, UCP_FILTER_ALL);
        RandomStringsTest.testUCP(new UCPGenerator(){

            @Override
            public int generate() {
                return RandomStrings.genUCP((UCPFilter)UCP_FILTER_CUSTOM);
            }
        }, UCP_FILTER_CUSTOM);
        RandomStringsTest.testUCP(new UCPGenerator(){

            @Override
            public int generate() {
                return RandomStrings.genUCPCharset((Charset)UnicodeCharset.UTF8.getCharset());
            }
        }, UCP_FILTER_UTF8);
        RandomStringsTest.testUCP(new UCPGenerator(){

            @Override
            public int generate() {
                return RandomStrings.genUCPDefCharset();
            }
        }, UCP_FILTER_DC);
        RandomStringsTest.testUCP(new UCPGenerator(){

            @Override
            public int generate() {
                return RandomStrings.genUCPFileSystem();
            }
        }, UCP_FILTER_FS);
        RandomStringsTest.testUCP(new UCPGenerator(){

            @Override
            public int generate() {
                return RandomStrings.genUCPValid();
            }
        }, UCPFilter.VALID);
        RandomStringsTest.testUCP(new UCPGenerator(){

            @Override
            public int generate() {
                return RandomStrings.genUCPDigit();
            }
        }, UCPFilter.DIGIT);
        RandomStringsTest.testUCP(new UCPGenerator(){

            @Override
            public int generate() {
                return RandomStrings.genUCPLetter();
            }
        }, UCPFilter.LETTER);
        RandomStringsTest.testUCP(new UCPGenerator(){

            @Override
            public int generate() {
                return RandomStrings.genUCPAlNum();
            }
        }, UCPFilter.ALNUM);
    }

    @Test
    public void genStrLen() {
        Assert.assertEquals((Object)"", (Object)RandomStrings.genStr((UCPFilter)UCP_FILTER_CUSTOM, (int)0));
        RandomStringsTest.testStrLen(new StrGenerator(){

            @Override
            public String generate() {
                return RandomStrings.genStr((UCPFilter)UCP_FILTER_CUSTOM, (int)20);
            }
        }, UCP_FILTER_CUSTOM);
        Assert.assertEquals((Object)"", (Object)RandomStrings.genStrCharset((Charset)UnicodeCharset.UTF8.getCharset(), (int)0));
        RandomStringsTest.testStrLen(new StrGenerator(){

            @Override
            public String generate() {
                return RandomStrings.genStrCharset((Charset)UnicodeCharset.UTF8.getCharset(), (int)20);
            }
        }, UCP_FILTER_UTF8);
        Assert.assertEquals((Object)"", (Object)RandomStrings.genStrDefCharset((int)0));
        RandomStringsTest.testStrLen(new StrGenerator(){

            @Override
            public String generate() {
                return RandomStrings.genStrDefCharset((int)20);
            }
        }, UCP_FILTER_DC);
        Assert.assertEquals((Object)"", (Object)RandomStrings.genStrFileSystem((int)0));
        RandomStringsTest.testStrLen(new StrGenerator(){

            @Override
            public String generate() {
                return RandomStrings.genStrFileSystem((int)20);
            }
        }, UCP_FILTER_FS);
        Assert.assertEquals((Object)"", (Object)RandomStrings.genStrValid((int)0));
        RandomStringsTest.testStrLen(new StrGenerator(){

            @Override
            public String generate() {
                return RandomStrings.genStrValid((int)20);
            }
        }, UCPFilter.VALID);
        Assert.assertEquals((Object)"", (Object)RandomStrings.genStrDigit((int)0));
        RandomStringsTest.testStrLen(new StrGenerator(){

            @Override
            public String generate() {
                return RandomStrings.genStrDigit((int)20);
            }
        }, UCPFilter.DIGIT);
        Assert.assertEquals((Object)"", (Object)RandomStrings.genStrLetter((int)0));
        RandomStringsTest.testStrLen(new StrGenerator(){

            @Override
            public String generate() {
                return RandomStrings.genStrLetter((int)20);
            }
        }, UCPFilter.LETTER);
        Assert.assertEquals((Object)"", (Object)RandomStrings.genStrAlNum((int)0));
        RandomStringsTest.testStrLen(new StrGenerator(){

            @Override
            public String generate() {
                return RandomStrings.genStrAlNum((int)20);
            }
        }, UCPFilter.ALNUM);
    }

    @Test
    public void genStrIdLen() {
        Assert.assertEquals((Object)"", (Object)RandomStrings.genStrId((int)0));
        RandomStringsTest.testStrId(1, RandomStrings.genStrId((int)1));
        RandomStringsTest.testStrId(2, RandomStrings.genStrId((int)2));
        String sFirst = RandomStrings.genStrId((int)20);
        boolean foundDifferent = false;
        for (int i = 0; i < 100; ++i) {
            String s = RandomStrings.genStrId((int)20);
            RandomStringsTest.testStrId(20, s);
            if (s.equals(sFirst)) continue;
            foundDifferent = true;
        }
        Assert.assertTrue((boolean)foundDifferent);
    }

    @Test
    public void genStr() {
        RandomStringsTest.testStr(1, 255, new StrGenerator(){

            @Override
            public String generate() {
                return RandomStrings.genStrCharset((Charset)UnicodeCharset.UTF8.getCharset());
            }
        }, UCP_FILTER_UTF8);
        RandomStringsTest.testStr(1, 255, new StrGenerator(){

            @Override
            public String generate() {
                return RandomStrings.genStrDefCharset();
            }
        }, UCP_FILTER_DC);
        RandomStringsTest.testStr(1, 255, new StrGenerator(){

            @Override
            public String generate() {
                return RandomStrings.genStrFileSystem();
            }
        }, UCP_FILTER_FS);
        RandomStringsTest.testStr(1, 255, new StrGenerator(){

            @Override
            public String generate() {
                return RandomStrings.genStrValid();
            }
        }, UCPFilter.VALID);
        RandomStringsTest.testStr(1, 20, new StrGenerator(){

            @Override
            public String generate() {
                return RandomStrings.genStrDigit();
            }
        }, UCPFilter.DIGIT);
        RandomStringsTest.testStr(1, 255, new StrGenerator(){

            @Override
            public String generate() {
                return RandomStrings.genStrLetter();
            }
        }, UCPFilter.LETTER);
        RandomStringsTest.testStr(1, 255, new StrGenerator(){

            @Override
            public String generate() {
                return RandomStrings.genStrAlNum();
            }
        }, UCPFilter.ALNUM);
    }

    @Test
    public void genStrId() {
        String sFirst = RandomStrings.genStrId();
        boolean foundDifferent = false;
        for (int i = 0; i < 100; ++i) {
            String s = RandomStrings.genStrId();
            int[] ucps = StringUtils.toUCPArray((String)s);
            Assert.assertTrue((String)("Length is " + ucps.length), (ucps.length >= 2 && ucps.length <= 255 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Value was " + Integer.toHexString(ucps[0])), (boolean)Character.isLetter(ucps[0]));
            Assert.assertTrue((String)("Value was " + Integer.toHexString(ucps[1])), (boolean)Character.isDigit(ucps[1]));
            for (int j = 2; j < ucps.length; ++j) {
                Assert.assertTrue((String)("Value was " + Integer.toHexString(ucps[j])), (boolean)Character.isLetterOrDigit(ucps[j]));
            }
            if (s.equals(sFirst)) continue;
            foundDifferent = true;
        }
        Assert.assertTrue((boolean)foundDifferent);
    }

    private static interface StrGenerator {
        public String generate();
    }

    private static interface UCPGenerator {
        public int generate();
    }
}

