/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.unicode;

import org.apache.commons.lang.ArrayUtils;
import org.junit.Assert;
import org.junit.Test;
import org.marketcetera.util.except.I18NException;
import org.marketcetera.util.test.TestCaseBase;
import org.marketcetera.util.test.UnicodeData;
import org.marketcetera.util.unicode.DecodingStrategy;
import org.marketcetera.util.unicode.Messages;
import org.marketcetera.util.unicode.SignatureCharset;

public class DecodingStrategyTest
extends TestCaseBase {
    private static void common(DecodingStrategy strategy, byte[] data, SignatureCharset sc) throws Exception {
        if (sc == null) {
            Assert.assertNull((Object)strategy.getPrefixMatch(data));
            try {
                strategy.decode(data);
                Assert.fail();
            }
            catch (I18NException ex) {
                Assert.assertEquals((String)ex.getDetail(), (Object)Messages.NO_SIGNATURE_MATCHES, (Object)ex.getI18NBoundMessage());
            }
            return;
        }
        data = ArrayUtils.addAll((byte[])sc.getSignature().getMark(), (byte[])data);
        Assert.assertEquals((Object)sc, (Object)strategy.getPrefixMatch(data));
        Assert.assertEquals((Object)"Hello Spr\u00e5k \u0393\u0395\u0399\u0391 \u03a3\u039f\u03a5 \u0645\u0646\u0632\u0644 \u3055\u3088\u3046\u306a\u3089 \ud800\udc88 \ud800\udc89 \ud834\udd1e", (Object)strategy.decode(data));
    }

    private static void single(DecodingStrategy strategy, int length, byte[] data, SignatureCharset sc) throws Exception {
        Assert.assertNotNull((Object)strategy.getSerializations());
        Assert.assertEquals((long)length, (long)strategy.getSerializations().length);
        Assert.assertNull((Object)strategy.decode(null));
        DecodingStrategyTest.common(strategy, UnicodeData.COMBO_UTF8, SignatureCharset.UTF8_UTF8);
        DecodingStrategyTest.common(strategy, UnicodeData.COMBO_UTF16BE, SignatureCharset.UTF16BE_UTF16BE);
        DecodingStrategyTest.common(strategy, UnicodeData.COMBO_UTF16LE, SignatureCharset.UTF16LE_UTF16LE);
        DecodingStrategyTest.common(strategy, UnicodeData.COMBO_UTF32BE, SignatureCharset.UTF32BE_UTF32BE);
        DecodingStrategyTest.common(strategy, UnicodeData.COMBO_UTF32LE, SignatureCharset.UTF32LE_UTF32LE);
        DecodingStrategyTest.common(strategy, data, sc);
    }

    @Test
    public void all() throws Exception {
        DecodingStrategyTest.single(DecodingStrategy.UTF8_DEFAULT, 4, UnicodeData.COMBO_UTF8, SignatureCharset.NONE_UTF8);
        DecodingStrategyTest.single(DecodingStrategy.UTF16_DEFAULT, 3, UnicodeData.COMBO_UTF16BE, SignatureCharset.NONE_UTF16BE);
        DecodingStrategyTest.single(DecodingStrategy.UTF32_DEFAULT, 3, UnicodeData.COMBO_UTF32BE, SignatureCharset.NONE_UTF32BE);
        DecodingStrategyTest.single(DecodingStrategy.SIG_REQ, 5, UnicodeData.COMBO_UTF32BE, null);
    }
}

