/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.ws.stateless;

import java.util.Locale;
import org.junit.Assert;
import org.junit.Before;
import org.marketcetera.util.log.ActiveLocale;
import org.marketcetera.util.test.EqualityAssert;
import org.marketcetera.util.test.TestCaseBase;
import org.marketcetera.util.ws.stateless.StatelessClientContext;
import org.marketcetera.util.ws.tags.AppId;
import org.marketcetera.util.ws.tags.NodeId;
import org.marketcetera.util.ws.tags.VersionId;
import org.marketcetera.util.ws.tags.VersionIdTest;
import org.marketcetera.util.ws.wrappers.LocaleWrapper;

public class ClientContextTestBase
extends TestCaseBase {
    private static final VersionId TEST_VERSION = VersionIdTest.TEST_VERSION;
    private static final VersionId TEST_VERSION_D = VersionIdTest.TEST_VERSION_D;
    private static final AppId TEST_APP = new AppId("testApp");
    private static final AppId TEST_APP_D = new AppId("testAppD");
    private static final NodeId TEST_CLIENT = NodeId.generate();
    private static final NodeId TEST_CLIENT_D = NodeId.generate();
    private static final LocaleWrapper TEST_LOCALE = new LocaleWrapper(new Locale("la", "CO", "va"));
    private static final LocaleWrapper TEST_LOCALE_D = new LocaleWrapper(new Locale("lad", "COD", "vad"));

    @Before
    public void setupClientContextTestBase() {
        ActiveLocale.setProcessLocale((Locale)Locale.ROOT);
    }

    protected static void fillContext(StatelessClientContext context) {
        context.setVersionId(TEST_VERSION);
        context.setAppId(TEST_APP);
        context.setClientId(TEST_CLIENT);
        context.setLocale(TEST_LOCALE);
    }

    protected static void single(StatelessClientContext context, StatelessClientContext copy, StatelessClientContext empty, String suffix) {
        EqualityAssert.assertEquality((Object)context, (Object)copy, (Object[])new Object[]{empty});
        Assert.assertEquals((Object)TEST_VERSION, (Object)context.getVersionId());
        Assert.assertEquals((Object)TEST_APP, (Object)context.getAppId());
        Assert.assertEquals((Object)TEST_CLIENT, (Object)context.getClientId());
        Assert.assertEquals((Object)TEST_LOCALE, (Object)context.getLocale());
        Assert.assertEquals((Object)("Protocol version testVersion; application testApp; client " + TEST_CLIENT + "; locale 'la_CO_va'" + suffix), (Object)context.toString());
        Assert.assertNull((Object)empty.getVersionId());
        Assert.assertNull((Object)empty.getAppId());
        Assert.assertNull((Object)empty.getClientId());
        Assert.assertNull((Object)empty.getLocale());
        context.setVersionId(TEST_VERSION_D);
        Assert.assertEquals((Object)TEST_VERSION_D, (Object)context.getVersionId());
        Assert.assertEquals((Object)("Protocol version testVersionD; application testApp; client " + TEST_CLIENT + "; locale 'la_CO_va'" + suffix), (Object)context.toString());
        context.setVersionId(null);
        Assert.assertNull((Object)context.getVersionId());
        Assert.assertEquals((Object)("Protocol version null; application testApp; client " + TEST_CLIENT + "; locale 'la_CO_va'" + suffix), (Object)context.toString());
        context.setAppId(TEST_APP_D);
        Assert.assertEquals((Object)TEST_APP_D, (Object)context.getAppId());
        Assert.assertEquals((Object)("Protocol version null; application testAppD; client " + TEST_CLIENT + "; locale 'la_CO_va'" + suffix), (Object)context.toString());
        context.setAppId(null);
        Assert.assertNull((Object)context.getAppId());
        Assert.assertEquals((Object)("Protocol version null; application null; client " + TEST_CLIENT + "; locale 'la_CO_va'" + suffix), (Object)context.toString());
        context.setClientId(TEST_CLIENT_D);
        Assert.assertEquals((Object)TEST_CLIENT_D, (Object)context.getClientId());
        Assert.assertEquals((Object)("Protocol version null; application null; client " + TEST_CLIENT_D + "; locale 'la_CO_va'" + suffix), (Object)context.toString());
        context.setClientId(null);
        Assert.assertNull((Object)context.getClientId());
        Assert.assertEquals((Object)("Protocol version null; application null; client null; locale 'la_CO_va'" + suffix), (Object)context.toString());
        context.setLocale(TEST_LOCALE_D);
        Assert.assertEquals((Object)TEST_LOCALE_D, (Object)context.getLocale());
        Assert.assertEquals((Object)("Protocol version null; application null; client null; locale 'lad_COD_vad'" + suffix), (Object)context.toString());
        LocaleWrapper wrapper = new LocaleWrapper(null);
        context.setLocale(wrapper);
        Assert.assertEquals((Object)wrapper, (Object)context.getLocale());
        Assert.assertEquals((Object)("Protocol version null; application null; client null; locale ''" + suffix), (Object)context.toString());
        context.setLocale(null);
        Assert.assertNull((Object)context.getLocale());
        Assert.assertEquals((Object)("Protocol version null; application null; client null; locale ''" + suffix), (Object)context.toString());
    }
}

