/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.ws.stateless;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Locale;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.log4j.Level;
import org.apache.log4j.spi.LoggingEvent;
import org.junit.Assert;
import org.junit.Before;
import org.marketcetera.util.except.I18NException;
import org.marketcetera.util.log.ActiveLocale;
import org.marketcetera.util.log.I18NBoundMessage2P;
import org.marketcetera.util.test.TestCaseBase;
import org.marketcetera.util.ws.stateless.Messages;
import org.marketcetera.util.ws.stateless.StatelessClientContext;
import org.marketcetera.util.ws.stateless.StatelessRemoteCall;
import org.marketcetera.util.ws.stateless.StatelessRemoteCaller;
import org.marketcetera.util.ws.stateless.StatelessRemoteRunner;
import org.marketcetera.util.ws.stateless.TestMessages;
import org.marketcetera.util.ws.tags.AppId;
import org.marketcetera.util.ws.tags.EqualsTagFilter;
import org.marketcetera.util.ws.tags.NodeId;
import org.marketcetera.util.ws.tags.VersionId;
import org.marketcetera.util.ws.tags.VersionIdTest;
import org.marketcetera.util.ws.wrappers.LocaleWrapper;
import org.marketcetera.util.ws.wrappers.RemoteException;

public class StatelessRemoteCallTestBase
extends TestCaseBase {
    protected static final EqualsTagFilter TEST_VERSION_FILTER = new EqualsTagFilter(null, TestMessages.MESSAGE);
    protected static final EqualsTagFilter TEST_APP_FILTER = new EqualsTagFilter(null, TestMessages.MESSAGE);
    protected static final EqualsTagFilter TEST_CLIENT_FILTER = new EqualsTagFilter(null, TestMessages.MESSAGE);
    private static final VersionId TEST_VERSION = VersionId.SELF;
    protected static final VersionId TEST_VERSION_D = VersionIdTest.TEST_VERSION_D;
    private static final AppId TEST_APP = new AppId("testApp");
    private static final NodeId TEST_CLIENT = NodeId.generate();
    protected static final Locale TEST_LOCALE = new Locale("la", "CO", "va");
    protected static final Integer TEST_INT = NumberUtils.INTEGER_ONE;
    protected static final RuntimeException TEST_EXCEPTION = new IllegalArgumentException();
    private static final String TEST_LOCATION = StatelessRemoteCall.class.getName();
    protected static Object sSetByRunner;

    @Before
    public void setupStatelessRemoteCallTestBase() {
        ActiveLocale.setProcessLocale((Locale)Locale.ROOT);
    }

    protected static void single(StatelessRemoteCall call, StatelessRemoteCall empty, StatelessRemoteCall defaults) {
        Assert.assertEquals((Object)TEST_VERSION_FILTER, (Object)call.getVersionIdFilter());
        Assert.assertEquals((Object)TEST_APP_FILTER, (Object)call.getAppIdFilter());
        Assert.assertEquals((Object)TEST_CLIENT_FILTER, (Object)call.getClientIdFilter());
        Assert.assertNull((Object)empty.getVersionIdFilter());
        Assert.assertNull((Object)empty.getAppIdFilter());
        Assert.assertNull((Object)empty.getClientIdFilter());
        Assert.assertEquals((Object)StatelessRemoteCall.DEFAULT_VERSION_FILTER, (Object)defaults.getVersionIdFilter());
        Assert.assertNull((Object)defaults.getAppIdFilter());
        Assert.assertNull((Object)defaults.getClientIdFilter());
    }

    protected static void fillContext(StatelessClientContext context) {
        context.setVersionId(TEST_VERSION);
        context.setAppId(TEST_APP);
        context.setClientId(TEST_CLIENT);
        context.setLocale(new LocaleWrapper(TEST_LOCALE));
    }

    protected void checkEvents(StatelessClientContext context, StatelessRemoteCall call, boolean success) {
        String contextStr = context.toString();
        Iterator events = this.getAppender().getEvents().iterator();
        StatelessRemoteCallTestBase.assertEvent((LoggingEvent)((LoggingEvent)events.next()), (Level)Level.DEBUG, (String)call.getClass().getName(), (String)("Remote call is starting; context: " + contextStr), (String)TEST_LOCATION);
        if (success) {
            StatelessRemoteCallTestBase.assertEvent((LoggingEvent)((LoggingEvent)events.next()), (Level)Level.DEBUG, (String)call.getClass().getName(), (String)("Remote call ended successfully; context: " + contextStr), (String)TEST_LOCATION);
        } else {
            StatelessRemoteCallTestBase.assertEvent((LoggingEvent)((LoggingEvent)events.next()), (Level)Level.DEBUG, (String)call.getClass().getName(), (String)("Remote call ended with failure; context: " + contextStr), (String)TEST_LOCATION);
            events.next();
        }
        Assert.assertFalse((boolean)events.hasNext());
        this.getAppender().clear();
    }

    private <T> void singleSuccess(StatelessClientContext context, StatelessRemoteCaller<T> caller, T value) throws Exception {
        StatelessRemoteCallTestBase.setLevel((String)caller.getClass().getName(), (Level)Level.DEBUG);
        Assert.assertEquals(value, (Object)caller.execute(context));
        this.checkEvents(context, (StatelessRemoteCall)caller, true);
    }

    private void singleFailure(StatelessClientContext context, StatelessRemoteCaller<?> caller, Class<?> exceptionClass) {
        StatelessRemoteCallTestBase.setLevel((String)caller.getClass().getName(), (Level)Level.DEBUG);
        StatelessRemoteCallTestBase.setRunnerData(null);
        try {
            caller.execute(context);
            Assert.fail();
        }
        catch (RemoteException ex) {
            Assert.assertNull((Object)sSetByRunner);
            Assert.assertEquals(exceptionClass, ex.getCause().getClass());
        }
        this.checkEvents(context, (StatelessRemoteCall)caller, false);
    }

    protected static void setRunnerData(Object value) {
        sSetByRunner = value;
    }

    private void singleSuccess(StatelessClientContext context, StatelessRemoteRunner runner, Object value) throws Exception {
        StatelessRemoteCallTestBase.setLevel((String)runner.getClass().getName(), (Level)Level.DEBUG);
        StatelessRemoteCallTestBase.setRunnerData(null);
        runner.execute(context);
        Assert.assertEquals((Object)value, (Object)sSetByRunner);
        this.checkEvents(context, (StatelessRemoteCall)runner, true);
    }

    private void singleFailure(StatelessClientContext context, StatelessRemoteRunner runner, Class<?> exceptionClass) {
        StatelessRemoteCallTestBase.setLevel((String)runner.getClass().getName(), (Level)Level.DEBUG);
        StatelessRemoteCallTestBase.setRunnerData(null);
        try {
            runner.execute(context);
            Assert.fail();
        }
        catch (RemoteException ex) {
            Assert.assertNull((Object)sSetByRunner);
            Assert.assertEquals(exceptionClass, ex.getCause().getClass());
        }
        this.checkEvents(context, (StatelessRemoteCall)runner, false);
    }

    protected void calls(StatelessClientContext context, StatelessRemoteCaller<Integer> intCall, StatelessRemoteCaller<Locale> localeCall, StatelessRemoteCaller<?> throwCall, StatelessRemoteCaller<?> throwVersionIdCall, StatelessRemoteCaller<?> throwAppIdCall, StatelessRemoteCaller<?> throwClientIdCall) throws Exception {
        StatelessRemoteCallTestBase.fillContext(context);
        this.singleSuccess(context, intCall, TEST_INT);
        this.singleSuccess(context, localeCall, TEST_LOCALE);
        this.singleFailure(context, throwCall, TEST_EXCEPTION.getClass());
        this.singleFailure(context, throwVersionIdCall, I18NException.class);
        this.singleFailure(context, throwAppIdCall, I18NException.class);
        this.singleFailure(context, throwClientIdCall, I18NException.class);
        context.setVersionId(TEST_VERSION_D);
        try {
            intCall.execute(context);
            Assert.fail();
        }
        catch (RemoteException ex) {
            Assert.assertEquals((Object)new I18NBoundMessage2P(Messages.VERSION_MISMATCH, (Serializable)VersionId.SELF, (Serializable)TEST_VERSION_D), (Object)((I18NException)ex.getCause()).getI18NBoundMessage());
        }
    }

    protected void calls(StatelessClientContext context, StatelessRemoteRunner intRun, StatelessRemoteRunner localeRun, StatelessRemoteRunner throwRun, StatelessRemoteRunner throwVersionIdRun, StatelessRemoteRunner throwAppIdRun, StatelessRemoteRunner throwClientIdRun) throws Exception {
        StatelessRemoteCallTestBase.fillContext(context);
        this.singleSuccess(context, intRun, TEST_INT);
        this.singleSuccess(context, localeRun, TEST_LOCALE);
        this.singleFailure(context, throwRun, TEST_EXCEPTION.getClass());
        this.singleFailure(context, throwVersionIdRun, I18NException.class);
        this.singleFailure(context, throwAppIdRun, I18NException.class);
        this.singleFailure(context, throwClientIdRun, I18NException.class);
        context.setVersionId(TEST_VERSION_D);
        try {
            intRun.execute(context);
            Assert.fail();
        }
        catch (RemoteException ex) {
            Assert.assertEquals((Object)new I18NBoundMessage2P(Messages.VERSION_MISMATCH, (Serializable)VersionId.SELF, (Serializable)TEST_VERSION_D), (Object)((I18NException)ex.getCause()).getI18NBoundMessage());
        }
    }
}

